/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security;

import java.io.IOException;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SOAPUtil {
    private static final Log LOG = LogFactory.getLog((String)"Messenger.SOAPUtil");
    private static TransformerFactory _transformerFactory;

    public static Document toDocument(SOAPMessage soapMessage) throws TransformerConfigurationException, TransformerException, SOAPException, IOException {
        return SOAPUtil.toDocument(soapMessage, false);
    }

    public static Document toDocument(SOAPMessage soapMessage, boolean removeNsPrefixAttrFromHeader) throws TransformerConfigurationException, TransformerException, SOAPException, IOException {
        Source src = soapMessage.getSOAPPart().getContent();
        Transformer transformer = _transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        DOMResult result = new DOMResult();
        transformer.transform(src, result);
        Document document = (Document)result.getNode();
        if (removeNsPrefixAttrFromHeader) {
            SOAPUtil.removeNsPrefixAttrFromHeader(document);
        }
        return document;
    }

    private static void removeNsPrefixAttrFromHeader(Document document) {
        Node header;
        Node envelope = document.getFirstChild();
        if (envelope != null && "Envelope".equals(envelope.getLocalName()) && (header = envelope.getFirstChild()) != null && "Header".equals(header.getLocalName())) {
            NamedNodeMap attributes = header.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attribute = (Attr)attributes.item(i);
                if (!"http://www.w3.org/2003/05/soap-envelope".equals(attribute.getTextContent())) continue;
                ((Element)header).removeAttributeNode(attribute);
            }
        }
    }

    static {
        try {
            _transformerFactory = TransformerFactory.newInstance();
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage());
        }
    }
}

