/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security;

import de.pontonconsulting.xmlpipe.security.CertificateRequest;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.Enumeration;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.openssl.PEMException;
import org.springframework.stereotype.Component;

@Component
public class PublicKeyAlgorithmUtility {
    public String getKeyAlgorithmInfo(X509Certificate certificate) {
        PublicKey publicKey = certificate.getPublicKey();
        return this.determineKeyAlgorithm(publicKey);
    }

    public String getKeyAlgorithmInfoForCertificateRequest(CertificateRequest certificateRequest) {
        try {
            PublicKey publicKey = certificateRequest.getPublicKey();
            return this.determineKeyAlgorithm(publicKey);
        }
        catch (PEMException e) {
            return "unknown";
        }
    }

    public String determineKeyAlgorithm(PublicKey publicKey) {
        try {
            if (publicKey instanceof java.security.interfaces.ECPublicKey) {
                return String.format("%s [%s]", publicKey.getAlgorithm(), this.deriveCurveName(publicKey));
            }
            if (publicKey instanceof RSAPublicKey) {
                RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
                return String.format("%s [%s]", publicKey.getAlgorithm(), rsaPublicKey.getModulus().bitLength());
            }
            return publicKey.getAlgorithm();
        }
        catch (GeneralSecurityException e) {
            return "unknown";
        }
    }

    private String deriveCurveName(org.bouncycastle.jce.spec.ECParameterSpec ecParameterSpec) throws GeneralSecurityException {
        Enumeration names = ECNamedCurveTable.getNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            X9ECParameters params = ECNamedCurveTable.getByName((String)name);
            if (!params.getN().equals(ecParameterSpec.getN()) || !params.getH().equals(ecParameterSpec.getH()) || !params.getCurve().equals(ecParameterSpec.getCurve()) || !params.getG().equals(ecParameterSpec.getG())) continue;
            return name;
        }
        throw new GeneralSecurityException("Could not find name for curve");
    }

    public String deriveCurveName(PublicKey publicKey) throws GeneralSecurityException {
        if (publicKey instanceof java.security.interfaces.ECPublicKey) {
            java.security.interfaces.ECPublicKey pk = (java.security.interfaces.ECPublicKey)publicKey;
            ECParameterSpec params = pk.getParams();
            return this.deriveCurveName(EC5Util.convertSpec((ECParameterSpec)params));
        }
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey pk = (ECPublicKey)publicKey;
            return this.deriveCurveName(pk.getParameters());
        }
        throw new IllegalArgumentException("Can only be used with instances of ECPublicKey (either jce or bc implementation)");
    }
}

