/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security;

import de.pontonconsulting.xmlpipe.cp.PartyId;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CryptoManager {
    public static final Logger _log = LogManager.getLogger((String)"Messenger.CryptoManager");
    private final CertificateUtility _certificateUtility;
    private final Profiles _profiles;

    public CryptoManager(CertificateUtility certificateUtility, Profiles profiles) {
        this._certificateUtility = certificateUtility;
        this._profiles = profiles;
    }

    public void checkCertificateForVerification(X509Certificate certificate, XpMessage xpMessage) throws GeneralSecurityException {
        try {
            Set<X509Certificate> senderCerts;
            CppPartner sender = this._profiles.getProfileForLocalId(xpMessage.getCommunication().getSender().getId(), true);
            if (sender.isCertUpdateAllowed() && !sender.getAllCertificates().contains(certificate)) {
                String organizationalUnit = this._certificateUtility.getOrganizationalUnit(certificate);
                if (Arrays.stream(sender.getPartyIds()).map(PartyId::getValue).anyMatch(organizationalUnit::equals)) {
                    sender.addPartnerCertificate(certificate);
                    sender.save();
                }
            }
            if ((senderCerts = sender.getAllCertificates()).size() == 0) {
                _log.error("No certificate installed for sender '{}'", (Object)sender.getDisplayName());
                throw new GeneralSecurityException("No certificate installed for sender.");
            }
            if (!sender.isCertificateTrusted(sender.getCertificateId(certificate))) {
                String usingInfoText = this._certificateUtility.toUsingInfoText(certificate, "certificate is revoked ");
                throw new GeneralSecurityException(usingInfoText);
            }
            X500Principal issuer = certificate.getIssuerX500Principal();
            BigInteger serial = certificate.getSerialNumber();
            for (X509Certificate senderCertificate : senderCerts) {
                X500Principal tempIssuer = senderCertificate.getIssuerX500Principal();
                BigInteger tempSerial = senderCertificate.getSerialNumber();
                if (!issuer.equals(tempIssuer) || !serial.equals(tempSerial)) continue;
                return;
            }
            String usingInfoText = this._certificateUtility.toUsingInfoText(certificate, "No certificate installed for sender with");
            throw new GeneralSecurityException(usingInfoText);
        }
        catch (GeneralSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeneralSecurityException("Could not check certificates for sender.", e);
        }
    }

    public void checkCertificateForDecryption(X509Certificate certificate, XpMessage xpMessage) throws GeneralSecurityException {
        try {
            CppPartner receiver = this._profiles.getProfileForLocalId(xpMessage.getCommunication().getReceiver().getId(), true);
            Set<X509Certificate> receiverCerts = receiver.getAllCertificates();
            if (receiverCerts.size() == 0) {
                _log.error("No certificate installed for receiver '{}'", (Object)receiver.getDisplayName());
                throw new GeneralSecurityException("No certificate installed for receiver.");
            }
            X500Principal issuer = certificate.getIssuerX500Principal();
            BigInteger serial = certificate.getSerialNumber();
            for (X509Certificate receiverCertificate : receiverCerts) {
                X500Principal tempIssuer = receiverCertificate.getIssuerX500Principal();
                BigInteger tempSerial = receiverCertificate.getSerialNumber();
                if (!issuer.equals(tempIssuer) || !serial.equals(tempSerial)) continue;
                return;
            }
            String usingInfoText = this._certificateUtility.toUsingInfoText(certificate, "No certificate installed for receiver with");
            throw new GeneralSecurityException(usingInfoText);
        }
        catch (GeneralSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GeneralSecurityException("Could not check certificates for receiver.", e);
        }
    }
}

