/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security;

import de.pontonconsulting.common.encoding.Base64Encoder;
import de.pontonconsulting.xmlpipe.admintool.InstallCertException;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.security.CertificateInfo;
import de.pontonconsulting.xmlpipe.security.CryptoUtil;
import de.pontonconsulting.xmlpipe.security.PublicKeyAlgorithmUtility;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.commons.lang3.StringUtils;
import org.apache.wss4j.common.crypto.DERDecoder;
import org.apache.wss4j.common.crypto.X509SubjectPublicKeyInfo;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;

public class CertificateUtility {
    private static final String HEADER = "-----BEGIN CERTIFICATE-----";
    private static final String FOOTER = "-----END CERTIFICATE-----";
    public static final String SKI_OID = "2.5.29.14";
    public static final String DEFAULT_USING_TEXT = "used certificate";
    public static final String TEMP_PREFIX = "temp_$";
    private static final String ISSUER = "Issuer";
    private static final String SN = "SN";
    private static CertificateFactory certFactory = null;
    private static final String SERIAL_NR_SEPARATOR = ":";
    private static Comparator<X509Certificate> _certComparator = null;
    private static final String SEPARATOR = "_";

    public String getBase64(X509Certificate cert) throws CertificateEncodingException {
        return this.getBase64(cert.getEncoded());
    }

    public String getBase64(byte[] encodedCert) {
        StringBuilder sb = new StringBuilder();
        String base64EncodedCert = Base64Encoder.encode(encodedCert);
        sb.append(base64EncodedCert);
        return sb.toString();
    }

    public X509Certificate getX509Certificate(String base64) throws CertificateException, NoSuchProviderException, InstallCertException {
        if (((String)base64).contains(HEADER) && ((String)base64).contains(FOOTER)) {
            base64 = ((String)base64).substring(((String)base64).indexOf(HEADER), ((String)base64).indexOf(FOOTER)) + FOOTER;
        }
        base64 = this.formatBASE64Cert((String)base64);
        return this.getX509Certificate(((String)base64).getBytes());
    }

    public String formatBASE64Cert(String base64Cert) {
        if (base64Cert == null) {
            return null;
        }
        Object result = base64Cert.replaceAll(HEADER, "");
        result = ((String)result).replaceAll(FOOTER, "");
        result = ((String)result).replaceAll(" ", "");
        result = ((String)result).replaceAll("\t", "");
        result = ((String)result).replaceAll("\n", "");
        result = ((String)result).replaceAll("\r", "");
        result = "-----BEGIN CERTIFICATE-----\r\n" + (String)result + "\r\n-----END CERTIFICATE-----\r\n";
        return result;
    }

    public X509Certificate getX509Certificate(byte[] certAsBytes) throws CertificateException, NoSuchProviderException, InstallCertException {
        X509Certificate cert;
        CertificateFactory cf = this.getCertFactory();
        ByteArrayInputStream bais = new ByteArrayInputStream(certAsBytes);
        try {
            cert = (X509Certificate)cf.generateCertificate(bais);
        }
        catch (ClassCastException | IndexOutOfBoundsException e) {
            cert = null;
        }
        if (cert == null) {
            throw new InstallCertException(32001, "Certificate format not recognized");
        }
        return cert;
    }

    public CertificateFactory getCertFactory() throws CertificateException, NoSuchProviderException {
        if (certFactory == null) {
            certFactory = CertificateFactory.getInstance("X.509", "BC");
        }
        return certFactory;
    }

    public String serialNr2String(BigInteger serialNr, String separator) {
        Object serialNrHex = serialNr.toString(16).toUpperCase();
        if (((String)serialNrHex).length() % 2 != 0) {
            serialNrHex = "0" + (String)serialNrHex;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < ((String)serialNrHex).length(); ++i) {
            if (i != 0 && i % 2 == 0) {
                result.append(separator).append(((String)serialNrHex).charAt(i));
                continue;
            }
            result.append(((String)serialNrHex).charAt(i));
        }
        return result.toString();
    }

    public String serialNr2String(BigInteger serialNr) {
        return this.serialNr2String(serialNr, SERIAL_NR_SEPARATOR);
    }

    public boolean certificatesEqual(X509Certificate cert1, X509Certificate cert2) throws CertificateEncodingException {
        return ByteBuffer.wrap(cert1.getEncoded()).equals(ByteBuffer.wrap(cert2.getEncoded()));
    }

    public boolean isCertValid(X509Certificate cert) {
        boolean valid = true;
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            valid = false;
        }
        return valid;
    }

    public boolean isCertAlreadyInstalled(X509Certificate certToInstall, CppPartner partner) throws CertificateEncodingException {
        boolean isInstalled = false;
        Set<X509Certificate> installedCerts = partner.getAllCertificates();
        for (X509Certificate installedCert : installedCerts) {
            if (!this.certificatesEqual(installedCert, certToInstall)) continue;
            isInstalled = true;
        }
        return isInstalled;
    }

    public String toUsingInfoText(X509Certificate cert) {
        return this.toUsingInfoText(cert, null, DEFAULT_USING_TEXT);
    }

    public String toUsingInfoText(X509Certificate cert, String using) {
        return this.toUsingInfoText(cert, null, using);
    }

    public String toUsingInfoText(X509Certificate cert, String rfc, String using) {
        if (cert == null) {
            return null;
        }
        String issuerDn = this.getIssuerDN(cert, rfc);
        StringBuilder builder = new StringBuilder(StringUtils.isBlank((CharSequence)using) ? DEFAULT_USING_TEXT : using);
        builder.append(" ").append(cert.getSubjectX500Principal().toString()).append("; ").append(SN).append(": ");
        builder.append(this.serialNr2String(cert.getSerialNumber())).append(" (");
        builder.append(cert.getSerialNumber()).append("), ").append(ISSUER).append(": ").append(issuerDn);
        return builder.toString();
    }

    public String getSignatureUnknownErrorText(X509Certificate certificate) {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>(1);
        if (certificate != null) {
            certificates.add(certificate);
        }
        return this.getSignatureUnknownErrorText(certificates);
    }

    public String getSignatureUnknownErrorText(List<X509Certificate> certificates) {
        ArrayList<CertificateInfo> certificateInfos = new ArrayList<CertificateInfo>();
        if (certificates != null) {
            for (X509Certificate certificate : certificates) {
                certificateInfos.add(new CertificateInfo(certificate));
            }
        }
        return this.getSignatureUnknownErrorTextFor(certificateInfos);
    }

    public String getDecryptionUnknownErrorTextFor(List<CertificateInfo> certificateInfos) {
        return this.getCertificateUnknownErrorText(certificateInfos, "Message was encrypted without Certificate Information!", "Message was encrypted with unknown Certificate");
    }

    public String getSignatureUnknownErrorTextFor(List<CertificateInfo> certificateInfos) {
        return this.getCertificateUnknownErrorText(certificateInfos, "Signature was created without Certificate Information!", "Signature was created with unknown Certificate");
    }

    private String getCertificateUnknownErrorText(List<CertificateInfo> certificateInfos, String noCertInfoText, String errorTextPrefix) {
        if (certificateInfos == null || certificateInfos.isEmpty()) {
            return noCertInfoText;
        }
        StringBuilder builder = new StringBuilder(errorTextPrefix);
        if (certificateInfos.size() > 1) {
            builder.append("s: ");
        } else {
            builder.append(": ");
        }
        for (CertificateInfo cert : certificateInfos) {
            builder.append("[SN: ");
            builder.append(this.serialNr2String(cert.getSerial()));
            builder.append(" (").append(cert.getSerial()).append(")");
            builder.append(" Issuer: ");
            builder.append(cert.getIssuerString());
            builder.append("] ");
        }
        return builder.toString().trim();
    }

    public String getIssuerDN(X509Certificate certificate, String rfc) {
        String issuerDn = !StringUtils.isBlank((CharSequence)rfc) ? certificate.getIssuerX500Principal().getName(rfc) : certificate.getIssuerX500Principal().getName("RFC1779");
        return issuerDn.trim();
    }

    public byte[] getSKIBytesFromCert(X509Certificate cert) throws WSSecurityException {
        byte[] derEncodedValue = cert.getExtensionValue(SKI_OID);
        if (cert.getVersion() < 3 || derEncodedValue == null) {
            X509SubjectPublicKeyInfo spki = new X509SubjectPublicKeyInfo(cert.getPublicKey());
            byte[] value = spki.getSubjectPublicKey();
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                return digest.digest(value);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("No SKI certificate extension and no SHA1 message digest available", ex);
            }
        }
        DERDecoder extVal = new DERDecoder(derEncodedValue);
        extVal.expect((byte)4);
        extVal.getLength();
        extVal.expect((byte)4);
        int keyIDLen = extVal.getLength();
        return extVal.getBytes(keyIDLen);
    }

    public String buildAliasForCA(X509Certificate cert) {
        return cert.getSubjectX500Principal().getName("CANONICAL");
    }

    public String buildAliasForClient(X509Certificate cert) {
        try {
            X500Name x500name = new JcaX509CertificateHolder(cert).getSubject();
            RDN cn = x500name.getRDNs(BCStyle.CN)[0];
            return IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue()) + SEPARATOR + String.valueOf(cert.getSerialNumber()) + ".cert";
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return null;
        }
    }

    public String buildAlias(X509Certificate certificate) {
        if (certificate == null) {
            return null;
        }
        return this.buildAlias(this.getIssuerX500PrincipalName(certificate), this.getSerialNumber(certificate));
    }

    public String buildAlias(String issuerDN, String serialNumber) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(serialNumber);
        stringBuilder.append(SEPARATOR);
        stringBuilder.append(issuerDN);
        return stringBuilder.toString();
    }

    public String[] getIssuerAndSerialForAlias(String alias) {
        String[] result = new String[2];
        int index = alias.indexOf(SEPARATOR);
        if (index < 0) {
            throw new IllegalArgumentException("Wrong alias format: " + alias);
        }
        result[1] = alias.substring(0, index);
        result[0] = alias.substring(index + 1);
        return result;
    }

    public String getOrganizationalUnit(X509Certificate certificate) throws Exception {
        LdapName ldapName = new LdapName(certificate.getSubjectX500Principal().getName());
        List<Rdn> rdns = ldapName.getRdns();
        for (Rdn rdn : rdns) {
            if (!"OU".equalsIgnoreCase(rdn.getType())) continue;
            return rdn.getValue().toString();
        }
        return null;
    }

    public String getSerialNumber(X509Certificate certificate) {
        return certificate.getSerialNumber().toString();
    }

    public String getIssuerX500PrincipalName(X509Certificate certificate) {
        return certificate.getIssuerX500Principal().getName();
    }

    public String getKeyAlgorithmInfo(X509Certificate certificate) {
        PublicKeyAlgorithmUtility publicKeyAlgorithmUtility = new PublicKeyAlgorithmUtility();
        return publicKeyAlgorithmUtility.determineKeyAlgorithm(certificate.getPublicKey());
    }

    public String getIssuer(X509Certificate certificate) {
        return certificate.getIssuerX500Principal().toString();
    }

    public String getSubject(X509Certificate certificate) {
        return certificate.getSubjectX500Principal().toString();
    }

    public OffsetDateTime getValidFrom(X509Certificate certificate) {
        return certificate.getNotBefore().toInstant().atOffset(ZoneOffset.UTC);
    }

    public OffsetDateTime getValidTo(X509Certificate certificate) {
        return certificate.getNotAfter().toInstant().atOffset(ZoneOffset.UTC);
    }

    public void storePkcs12PrivateKey(String certAlias, String privateKeyPassword, PrivateKey privateKey, Certificate[] chain, OutputStream output) throws GeneralSecurityException, IOException {
        CryptoUtil.storePkcs12PrivateKey(certAlias, privateKeyPassword, privateKey, chain, output);
    }

    public String generateTempAlias() {
        return TEMP_PREFIX + System.currentTimeMillis();
    }
}

