/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;

public class CertificateRequest {
    private static final String SHA_256_WITH_RSA = "SHA256WithRSA";
    private static final String SHA_256_WITH_ECDSA = "SHA256withECDSA";
    private final String id;
    private final PKCS10CertificationRequest _certRequest;
    private final X500Name _subject;

    public CertificateRequest(String id, byte[] encodedCertificateRequest) throws IOException {
        this.id = id;
        this._certRequest = new PKCS10CertificationRequest(encodedCertificateRequest);
        this._subject = this._certRequest.getSubject();
    }

    public CertificateRequest(String id, X500Name subject, PublicKey publicKey, PrivateKey signingKey) throws GeneralSecurityException, OperatorCreationException {
        this(id, subject, null, publicKey, signingKey);
    }

    public CertificateRequest(String id, X500Name subject, Map<String, String> extensions, PublicKey publicKey, PrivateKey signingKey, GeneralNames subjectAltNames) throws GeneralSecurityException, OperatorCreationException {
        this.id = id;
        this._subject = subject;
        ContentSigner signer = new JcaContentSignerBuilder(this.getAlgorithm(signingKey)).build(signingKey);
        JcaPKCS10CertificationRequestBuilder csrbuilder = new JcaPKCS10CertificationRequestBuilder(this._subject, publicKey);
        this.addAttributes((PKCS10CertificationRequestBuilder)csrbuilder, extensions);
        try {
            if (subjectAltNames != null) {
                ExtensionsGenerator extGen = new ExtensionsGenerator();
                extGen.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltNames);
                csrbuilder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extGen.generate());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._certRequest = csrbuilder.build(signer);
    }

    public CertificateRequest(String id, X500Name subject, KeyUsage keyUsage, ExtendedKeyUsage extendedKeyUsage, PublicKey publicKey, PrivateKey signingKey, GeneralNames subjectAltNames) throws GeneralSecurityException, OperatorCreationException, IOException {
        this.id = id;
        this._subject = subject;
        ContentSigner signer = new JcaContentSignerBuilder(this.getAlgorithm(signingKey)).build(signingKey);
        JcaPKCS10CertificationRequestBuilder csrbuilder = new JcaPKCS10CertificationRequestBuilder(this._subject, publicKey);
        if (subjectAltNames != null || keyUsage != null || extendedKeyUsage != null) {
            ExtensionsGenerator extGen = new ExtensionsGenerator();
            if (subjectAltNames != null) {
                extGen.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltNames);
            }
            if (keyUsage != null) {
                extGen.addExtension(Extension.keyUsage, true, (ASN1Encodable)keyUsage);
            }
            if (extendedKeyUsage != null) {
                extGen.addExtension(Extension.extendedKeyUsage, true, (ASN1Encodable)extendedKeyUsage);
            }
            csrbuilder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extGen.generate());
        }
        this._certRequest = csrbuilder.build(signer);
    }

    public CertificateRequest(String id, X500Name subject, Map<String, String> extensions, PublicKey publicKey, PrivateKey signingKey) throws GeneralSecurityException, OperatorCreationException {
        this(id, subject, extensions, publicKey, signingKey, null);
    }

    public String getId() {
        return this.id;
    }

    private String getAlgorithm(PrivateKey privateKey) {
        if (privateKey instanceof ECPrivateKey) {
            return SHA_256_WITH_ECDSA;
        }
        if (privateKey instanceof RSAPrivateKey) {
            return SHA_256_WITH_RSA;
        }
        throw new IllegalArgumentException("Private Key type is not supported.");
    }

    private void addAttributes(PKCS10CertificationRequestBuilder csrbuilder, Map<String, String> extensions) {
        if (extensions != null) {
            for (String oid : extensions.keySet()) {
                csrbuilder.addAttribute(new ASN1ObjectIdentifier(oid), (ASN1Encodable)new DERUTF8String(extensions.get(oid)));
            }
        }
    }

    public String getSubject() {
        return this._subject.toString();
    }

    public String getSubjectCN() {
        RDN cn = this._subject.getRDNs(BCStyle.CN)[0];
        return IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
    }

    public String getPEM() throws IOException {
        return this.getPEM(this._certRequest);
    }

    public PublicKey getPublicKey() throws PEMException {
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        return converter.getPublicKey(this._certRequest.getSubjectPublicKeyInfo());
    }

    private String getPEM(Object object) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JcaPEMWriter pemWrt = new JcaPEMWriter((Writer)stringWriter);
        pemWrt.writeObject(object);
        pemWrt.flush();
        pemWrt.close();
        return stringWriter.toString();
    }

    public byte[] getDER() throws IOException {
        return this._certRequest.getEncoded();
    }
}

