/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security;

import de.pontonconsulting.xmlpipe.adapter.encoding.Base64Encoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class CertificateReader {
    private static final long ONE_YEAR = 31536000000L;
    private static final int SAN_TYPE_MAIL_ADDRESS = 1;
    private static final int SAN_TYPE_DNS = 2;
    private static final int SAN_TYPE_IP = 7;
    private static SecureRandom _random;
    private static final String SHA_256_WITH_RSA = "SHA256WithRSA";
    private static final String SHA_256_WITH_ECDSA = "SHA256withECDSA";

    public CertificateReader() {
        _random = new SecureRandom();
        _random.nextInt();
    }

    public final String retrieveCN(X509Certificate cert) throws CertificateException {
        return this.retrieveCertificateAttribute("cn", cert);
    }

    private List<String> getSubjectAltNames(X509Certificate certificate, int type) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (subjectAltNames == null) {
                return Collections.emptyList();
            }
            for (List<?> subjectAltName : subjectAltNames) {
                String altName;
                Integer altNameType;
                if (subjectAltName == null || subjectAltName.size() < 2 || (altNameType = (Integer)subjectAltName.get(0)) == null || altNameType != type || (altName = (String)subjectAltName.get(1)) == null) continue;
                result.add(altName);
            }
            return result;
        }
        catch (CertificateParsingException e) {
            return Collections.emptyList();
        }
    }

    public final String retrieveEmail(X509Certificate cert) throws CertificateException {
        try {
            return this.retrieveCertificateAttribute("e", cert);
        }
        catch (CertificateException e) {
            return this.retrieveCertificateAttribute("emailaddress", cert);
        }
    }

    public final List<String> retrieveSAN_Emails(X509Certificate cert) {
        return this.getSubjectAltNames(cert, 1);
    }

    private final String retrieveCertificateAttribute(String attribute, X509Certificate cert) throws CertificateException {
        String subjectDN = cert.getSubjectDN().getName();
        int from = subjectDN.toLowerCase().indexOf(attribute + "=");
        if (from == -1) {
            throw new CertificateException("Certificate attribute '" + attribute + "' not found in certificate.");
        }
        int to = subjectDN.toLowerCase().indexOf(",", from += (attribute + "=").length());
        if (to == -1) {
            if (from == subjectDN.length()) {
                throw new CertificateException("Certificate attribute '" + attribute + "' is empty.");
            }
            to = subjectDN.length();
        }
        return subjectDN.substring(from, to).trim();
    }

    public final X509Certificate readCertificateFromFile(String filename) throws IOException, CertificateException, NoSuchProviderException {
        X509Certificate result;
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(new File(filename).toPath(), new OpenOption[0]));){
            result = this.readCertificateFromInputStream(in);
        }
        return result;
    }

    private X509Certificate readCertificateFromInputStream(InputStream inputStream) throws CertificateException, NoSuchProviderException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate cert = (X509Certificate)factory.generateCertificate(inputStream);
        return cert;
    }

    public KeyPair generateKeyPair(String algorithm, Integer keySize) throws GeneralSecurityException {
        if (algorithm.equals("RSA")) {
            return this.generateRSAKeyPair(algorithm, keySize);
        }
        return this.generateECKeypair(algorithm);
    }

    private String getAlgorithm(PrivateKey privateKey) {
        if (privateKey instanceof ECPrivateKey) {
            return SHA_256_WITH_ECDSA;
        }
        if (privateKey instanceof RSAPrivateKey) {
            return SHA_256_WITH_RSA;
        }
        throw new IllegalArgumentException("Private Key type is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyPair generateRSAKeyPair(String algorithm, Integer keySize) throws GeneralSecurityException {
        KeyPairGenerator kpg;
        KeyPairGenerator keyPairGenerator = kpg = KeyPairGenerator.getInstance(algorithm, "BC");
        synchronized (keyPairGenerator) {
            kpg.initialize(keySize, _random);
        }
        return kpg.generateKeyPair();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyPair generateECKeypair(String curveId) throws GeneralSecurityException {
        KeyPairGenerator kpGen;
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)curveId);
        KeyPairGenerator keyPairGenerator = kpGen = KeyPairGenerator.getInstance("ECDSA", "BC");
        synchronized (keyPairGenerator) {
            kpGen.initialize((AlgorithmParameterSpec)spec, _random);
        }
        return kpGen.generateKeyPair();
    }

    public final String certificateBase64Encoded(X509Certificate certificate) throws CertificateEncodingException {
        return CertificateReader.certificateBase64Encoded(certificate.getEncoded());
    }

    public static final String certificateBase64Encoded(byte[] encodedCert) {
        StringBuilder sb = new StringBuilder();
        String base64EncodedCert = Base64Encoder.encode((byte[])encodedCert, (int)64);
        String HEADER = "-----BEGIN CERTIFICATE-----\n";
        String FOOTER = "\n-----END CERTIFICATE-----\n";
        sb.append("-----BEGIN CERTIFICATE-----\n");
        sb.append(base64EncodedCert);
        sb.append("\n-----END CERTIFICATE-----\n");
        return sb.toString();
    }

    public final X509Certificate createCertificate(X500Name subject, PublicKey publicKey, X500Name issuer, PrivateKey privateKey) throws GeneralSecurityException, OperatorCreationException {
        Date notBefore = new Date();
        Date notAfter = new Date(notBefore.getTime() + 31536000000L);
        JcaX509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(issuer, BigInteger.valueOf(System.currentTimeMillis()), notBefore, notAfter, subject, publicKey);
        ContentSigner signer = new JcaContentSignerBuilder(this.getAlgorithm(privateKey)).setProvider("BC").build(privateKey);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateBuilder.build(signer));
    }
}

