/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security;

import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.EventLogEntry;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerCertificateData;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.PartnerProfile;
import de.pontonconsulting.xmlpipe.messenger.database.tables.EventLog;
import de.pontonconsulting.xmlpipe.messenger.database.tables.PartnerProfileDAO;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CertificateExpireCheckTask {
    public static final String CERTEXPIRECKECK_EXPIRED_PREFIX = "certexpirecheck;expired;";
    public static final String CERTEXPIRECKECK_WILLEXPIRED_PREFIX = "certexpirecheck;willexpire;";
    private static final String LOCATION_PARTNER = "/api/partner/";
    private static final Log _log = LogFactory.getLog((String)"Messenger.CertificateExpireChecker");
    private final PartnerProfileDAO partnerProfileDAO;
    private final ReferenceDateTask referenceDateTask;
    private final EventLog _EventLog;
    private final CertificateUtility certificateUtility;

    public CertificateExpireCheckTask(PartnerProfileDAO partnerProfileDAO, ReferenceDateTask referenceDateTask, EventLog EventLog2, CertificateUtility certificateUtility) {
        this.referenceDateTask = referenceDateTask;
        this._EventLog = EventLog2;
        this.certificateUtility = certificateUtility;
        _log.debug((Object)"Starting the CertificateExpireChecker");
        this.partnerProfileDAO = partnerProfileDAO;
    }

    public void checkForExpiredPartnerCertificates() {
        List<PartnerCertificateData> certificates = this.partnerProfileDAO.getAllPartnerCertificates();
        for (PartnerCertificateData certificate : certificates) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.checkForExpiredPartnerCertificates(certificate);
        }
    }

    public void checkForExpiredPartnerCertificates(CppPartner cppPartner) {
        this.partnerProfileDAO.getAllPartnerCertificatesForPartnerId(cppPartner.getLocalId()).forEach(this::checkForExpiredPartnerCertificates);
    }

    public void checkForExpiredPartnerCertificates(PartnerCertificateData partnerCertificateData) {
        boolean shouldValidateAgreement = false;
        String logMsg = "Checking certificates of local partner: '";
        Optional<PartnerProfile> optional = this.partnerProfileDAO.getPartnerProfile(partnerCertificateData.getPartnerId());
        if (optional.isEmpty()) {
            return;
        }
        PartnerProfile partner = optional.get();
        String link = LOCATION_PARTNER + partner.getPartnerId() + "/certificate/" + partnerCertificateData.getInternalCertId();
        if (_log.isTraceEnabled()) {
            _log.trace((Object)(logMsg + partner.getDisplayName() + "[" + String.valueOf(partner.getBackendPartnerIds().stream().findFirst().get()) + "]'"));
        }
        List<String> partnerCerEventIds = this._EventLog.getEventIdsForPrefix(CERTEXPIRECKECK_EXPIRED_PREFIX + partner.getPartnerId() + ";");
        partnerCerEventIds.addAll(this._EventLog.getEventIdsForPrefix(CERTEXPIRECKECK_WILLEXPIRED_PREFIX + partner.getPartnerId() + ";"));
        partnerCerEventIds.remove(CERTEXPIRECKECK_EXPIRED_PREFIX + partner.getPartnerId() + ";" + partnerCertificateData.getInternalCertId());
        if (!this.checkCertificate(partner, partnerCertificateData, link)) {
            shouldValidateAgreement = true;
        }
        for (String partnerCerEventId : partnerCerEventIds) {
            this._EventLog.delete(partnerCerEventId);
        }
    }

    public boolean checkCertificatePK(PartnerCertificateData partnerCertificateData, PartnerProfile partnerProfile) {
        if (partnerProfile.isRemote()) {
            return true;
        }
        return partnerCertificateData.getEncryptedPrivateKey() != null && partnerCertificateData.getEncryptedPrivateKey().length > 0;
    }

    public boolean checkCertificate(PartnerProfile partner, PartnerCertificateData partnerCertificateData, String link) {
        EventLogEntry event;
        boolean valid = true;
        OffsetDateTime now = this.referenceDateTask.getReferenceOffsetDateTime();
        String willexpireeventid = CERTEXPIRECKECK_WILLEXPIRED_PREFIX + partnerCertificateData.getPartnerId() + ";" + partnerCertificateData.getInternalCertId();
        String eventid = CERTEXPIRECKECK_EXPIRED_PREFIX + partnerCertificateData.getPartnerId() + ";" + partnerCertificateData.getInternalCertId();
        String component = "certExpireChecker.component";
        Object description = "Certificate " + partnerCertificateData.getSubjectDn() + " is missing its private key.";
        String[] args = new String[]{partnerCertificateData.getSubjectDn(), partner.getDisplayName() + "[" + String.valueOf(partner.getBackendPartnerIds().stream().findFirst().get()) + "]", partnerCertificateData.getValidTo().format(DateTimeFormatter.ISO_DATE_TIME)};
        if (now.isAfter(partnerCertificateData.getValidTo())) {
            valid = false;
            this._EventLog.delete(willexpireeventid);
            _log.warn((Object)("The certificate '" + partnerCertificateData.getInternalCertId() + "' of '" + partner.getDisplayName() + "[" + String.valueOf(partner.getBackendPartnerIds()) + "]' is expired."));
            description = "certExpireChecker.description.expired";
            event = new EventLogEntry(eventid, now.toInstant().toEpochMilli(), component, (String)description, args, "", EventLog.STATUS_ERROR, link);
            this._EventLog.add(event);
        } else if (now.plusDays(1L).isAfter(partnerCertificateData.getValidTo())) {
            valid = false;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("The certificate '" + partnerCertificateData.getInternalCertId() + "' of '" + partner.getDisplayName() + "[" + String.valueOf(partner.getBackendPartnerIds()) + "]' will expire soon."));
            }
            description = "certExpireChecker.description.expire_soon";
            event = new EventLogEntry(willexpireeventid, now.toInstant().toEpochMilli(), component, (String)description, args, "", EventLog.STATUS_WARN, link);
            this._EventLog.add(event);
        } else {
            this._EventLog.delete(eventid);
        }
        if (valid && !this.checkCertificatePK(partnerCertificateData, partner)) {
            _log.warn((Object)("The certificate '" + partnerCertificateData.getInternalCertId() + "' of '" + partner.getDisplayName() + "[" + String.valueOf(partner.getBackendPartnerIds()) + "]' is missing its private key."));
            if (this._EventLog.contains(eventid)) {
                return valid;
            }
            description = "certExpireChecker.description.no_pk";
            event = new EventLogEntry(willexpireeventid, now.toInstant().toEpochMilli(), component, (String)description, args, "", EventLog.STATUS_ERROR, link);
            this._EventLog.add(event);
        }
        return valid;
    }
}

