/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.util;

import de.pontonconsulting.xmlpipe.messenger.util.XmlDecryptionResult;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.XpWSSecurity;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import java.math.BigInteger;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlEncryptionUtil {
    private static final Logger LOGGER = LogManager.getLogger((String)"Messenger.XmlEncryptionUtil");
    private final Map<String, XmlEncryptionType> ENC_DATA_ALGORITHMS = new HashMap<String, XmlEncryptionType>(14);
    private final Map<String, XmlEncryptionType> ENC_KEY_ALGORITHMS = new HashMap<String, XmlEncryptionType>(14);
    private final CertificateUtility certificateUtility;

    public final String encryptionTypeToString(XmlEncryptionType type) {
        return "[Version=" + type.getVersion() + ", Algorithm=" + type.getAlgorithm() + ", AlgorithmUri=" + type.getNamespace() + "]";
    }

    public XmlEncryptionUtil(CertificateUtility certificateUtility) {
        this.certificateUtility = certificateUtility;
        this.ENC_DATA_ALGORITHMS.put("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", XmlEncryptionType.TRIPLEDES);
        this.ENC_DATA_ALGORITHMS.put("http://www.w3.org/2001/04/xmlenc#kw-tripledes", XmlEncryptionType.TRIPLEDES_KeyWrap);
        this.ENC_DATA_ALGORITHMS.put("http://www.w3.org/2001/04/xmlenc#aes128-cbc", XmlEncryptionType.AES_128);
        this.ENC_DATA_ALGORITHMS.put("http://www.w3.org/2009/xmlenc11#aes128-gcm", XmlEncryptionType.AES_128_GCM);
        this.ENC_DATA_ALGORITHMS.put("http://www.w3.org/2001/04/xmlenc#kw-aes128", XmlEncryptionType.AES_128_KeyWrap);
        this.ENC_DATA_ALGORITHMS.put("http://www.w3.org/2001/04/xmlenc#aes192-cbc", XmlEncryptionType.AES_192);
        this.ENC_DATA_ALGORITHMS.put("http://www.w3.org/2009/xmlenc11#aes192-gcm", XmlEncryptionType.AES_192_GCM);
        this.ENC_DATA_ALGORITHMS.put("http://www.w3.org/2001/04/xmlenc#kw-aes192", XmlEncryptionType.AES_192_KeyWrap);
        this.ENC_DATA_ALGORITHMS.put("http://www.w3.org/2001/04/xmlenc#aes256-cbc", XmlEncryptionType.AES_256);
        this.ENC_DATA_ALGORITHMS.put("http://www.w3.org/2009/xmlenc11#aes256-gcm", XmlEncryptionType.AES_256_GCM);
        this.ENC_DATA_ALGORITHMS.put("http://www.w3.org/2001/04/xmlenc#kw-aes256", XmlEncryptionType.AES_256_KeyWrap);
        this.ENC_KEY_ALGORITHMS.put("http://www.w3.org/2001/04/xmlenc#rsa-1_5", XmlEncryptionType.RSA_v1dot5);
        this.ENC_KEY_ALGORITHMS.put("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", XmlEncryptionType.RSA_OAEP);
        this.ENC_KEY_ALGORITHMS.put("http://www.w3.org/2009/xmlenc11#rsa-oaep", XmlEncryptionType.RSA_OAEP_11);
    }

    private XMLCipher getCipherInstance(XmlEncryptionType xmlEncryptionType) {
        try {
            return XMLCipher.getInstance((String)xmlEncryptionType.namespace);
        }
        catch (XMLEncryptionException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private SecretKey createSymmetricEncryptionKey(XmlEncryptionType xmlEncryptionType) {
        try {
            if (xmlEncryptionType.getKeylength() != 0) {
                KeyGenerator keyGenerator = KeyGenerator.getInstance(xmlEncryptionType.getAlgorithm());
                keyGenerator.init(xmlEncryptionType.getKeylength());
                return keyGenerator.generateKey();
            }
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private SecretKeySpec createSecretKeySpec(SecretKey secretKey, XmlEncryptionType xmlEncryptionType) {
        return new SecretKeySpec(secretKey.getEncoded(), xmlEncryptionType.getAlgorithm());
    }

    public Document encrypt(Document document, Element elementToEncrypt, X509Certificate x509Certificate, boolean encryptContentsOnly, XmlEncryptionType dataMode, XmlEncryptionType keyMode) throws Exception {
        switch (dataMode.ordinal()) {
            case 11: 
            case 12: 
            case 13: {
                throw new IllegalArgumentException("Please use symmetric encryption for data encryption.");
            }
        }
        SecretKey symmetricKey = this.createSymmetricEncryptionKey(dataMode);
        XMLCipher xmlCipher = this.getCipherInstance(dataMode);
        xmlCipher.init(1, (Key)symmetricKey);
        XMLCipher keyCipher = this.getCipherInstance(keyMode);
        keyCipher.init(3, (Key)x509Certificate.getPublicKey());
        EncryptedKey encryptedKey = keyCipher.encryptKey(document, (Key)symmetricKey);
        KeyInfo keyInfo = encryptedKey.getKeyInfo();
        if (keyInfo == null) {
            keyInfo = new KeyInfo(document);
            encryptedKey.setKeyInfo(keyInfo);
        }
        X509Data x509Data = new X509Data(document);
        x509Data.addCertificate(x509Certificate);
        x509Data.addSubjectName(x509Certificate.getSubjectX500Principal().getName());
        x509Data.addIssuerSerial(x509Certificate.getIssuerX500Principal().getName(), x509Certificate.getSerialNumber());
        keyInfo.add(x509Data);
        EncryptedData encryptedData = xmlCipher.getEncryptedData();
        keyInfo = encryptedData.getKeyInfo();
        if (keyInfo == null) {
            keyInfo = new KeyInfo(document);
            encryptedData.setKeyInfo(keyInfo);
        }
        keyInfo.add(encryptedKey);
        return xmlCipher.doFinal(document, elementToEncrypt, encryptContentsOnly);
    }

    public XmlDecryptionResult decrypt(Document document, List<SignCertInfo> signCertInfos) {
        String encryptionDataAlgorithmNS = this.getEncryptionDataAlgorithmNS(document);
        XmlEncryptionType encryptionType = this.ENC_DATA_ALGORITHMS.get(encryptionDataAlgorithmNS);
        if (encryptionType == null) {
            String errorMessage = "The encryption algorithm '" + encryptionDataAlgorithmNS + "' is not supported to decrypt data.";
            return new XmlDecryptionResult(false, null, errorMessage);
        }
        return this.decrypt(document, signCertInfos, encryptionType);
    }

    /*
     * Loose catch block
     */
    private XmlDecryptionResult decrypt(Document document, List<SignCertInfo> signCertInfos, XmlEncryptionType mode) {
        SecretKey secretKey;
        X509Certificate usedCertificate;
        BigInteger serialNumber;
        X500Principal issuerX500Principal;
        XMLCipher xmlCipher;
        block20: {
            Object errorMessage;
            X509Certificate x509Certificate;
            xmlCipher = this.getCipherInstance(mode);
            String encryptionKeyAlgorithmNS = this.getEncryptionKeyAlgorithmNS(document);
            XmlEncryptionType encryptionType = this.ENC_KEY_ALGORITHMS.get(encryptionKeyAlgorithmNS);
            if (encryptionType == null) {
                String errorMessage2 = "The encryption algorithm '" + encryptionKeyAlgorithmNS + "' is not supported to decrypt a symmetric key.";
                return new XmlDecryptionResult(false, null, errorMessage2);
            }
            issuerX500Principal = null;
            serialNumber = null;
            usedCertificate = null;
            XMLCipher keyCipher = this.getCipherInstance(encryptionType);
            keyCipher.init(4, null);
            EncryptedKey encryptedKey = keyCipher.loadEncryptedKey(document, this.getEncryptedKeyElement(document));
            KeyInfo keyInfo = encryptedKey.getKeyInfo();
            if (keyInfo != null) {
                X509Certificate embeddedCertificate = keyInfo.getX509Certificate();
                if (embeddedCertificate != null) {
                    issuerX500Principal = embeddedCertificate.getIssuerX500Principal();
                    serialNumber = embeddedCertificate.getSerialNumber();
                } else {
                    for (int i = 0; i < keyInfo.lengthX509Data(); ++i) {
                        try {
                            issuerX500Principal = null;
                            serialNumber = null;
                            X509Data x509Data = keyInfo.itemX509Data(i);
                            XMLX509IssuerSerial xmlX509IssuerSerial = x509Data.itemIssuerSerial(0);
                            if (xmlX509IssuerSerial == null) continue;
                            serialNumber = xmlX509IssuerSerial.getSerialNumber();
                            issuerX500Principal = new X500Principal(xmlX509IssuerSerial.getIssuerName());
                            continue;
                        }
                        catch (Exception e) {
                            LOGGER.warn("Could not get certificate information from the XML EncryptedData Element: " + e.toString());
                        }
                    }
                }
            }
            secretKey = null;
            if (serialNumber != null && issuerX500Principal != null) {
                for (SignCertInfo signCertInfo : signCertInfos) {
                    x509Certificate = signCertInfo.getCertificateChain()[0];
                    PrivateKey privateKey = signCertInfo.getPrivateKey();
                    if (!x509Certificate.getSerialNumber().equals(serialNumber) || !x509Certificate.getIssuerX500Principal().equals(issuerX500Principal)) continue;
                    usedCertificate = x509Certificate;
                    try {
                        keyCipher = this.getCipherInstance(encryptionType);
                        keyCipher.init(4, (Key)privateKey);
                        secretKey = (SecretKey)keyCipher.decryptKey(encryptedKey, encryptionType.getNamespace());
                        break;
                    }
                    catch (Exception e) {
                        String errorMessage3 = "Could not decrypted symmetric key with the private key of the Certificate: serial: " + this.certificateUtility.serialNr2String(serialNumber) + " (" + String.valueOf(serialNumber) + ") , Issuer: " + issuerX500Principal.toString();
                        return new XmlDecryptionResult(false, usedCertificate, errorMessage3);
                    }
                }
                if (secretKey == null) {
                    errorMessage = "Message was encrypted with a wrong Certificate. Could not find certificate serial: " + this.certificateUtility.serialNr2String(serialNumber) + " (" + String.valueOf(serialNumber) + ") , Issuer: " + issuerX500Principal.toString();
                    return new XmlDecryptionResult(false, usedCertificate, (String)errorMessage);
                }
                break block20;
            }
            for (SignCertInfo signCertInfo : signCertInfos) {
                try {
                    x509Certificate = signCertInfo.getCertificateChain()[0];
                    PrivateKey privateKey = signCertInfo.getPrivateKey();
                    keyCipher = this.getCipherInstance(encryptionType);
                    keyCipher.init(4, (Key)privateKey);
                    secretKey = (SecretKey)keyCipher.decryptKey(encryptedKey, encryptionType.getNamespace());
                    serialNumber = x509Certificate.getSerialNumber();
                    issuerX500Principal = x509Certificate.getIssuerX500Principal();
                    usedCertificate = x509Certificate;
                    break;
                }
                catch (Exception ex) {
                    LOGGER.debug(ex.getMessage(), (Throwable)ex);
                }
            }
            if (secretKey != null) break block20;
            errorMessage = "Message was encrypted with a wrong Certificate or could not decrypt the symmetric key.";
            return new XmlDecryptionResult(false, usedCertificate, "Message was encrypted with a wrong Certificate or could not decrypt the symmetric key.");
            {
                catch (Exception e) {
                    String errorMessage4 = "Could not decrypt data: " + e.toString();
                    return new XmlDecryptionResult(false, usedCertificate, errorMessage4);
                }
            }
        }
        try {
            SecretKeySpec secretKeySpec = this.createSecretKeySpec(secretKey, mode);
            xmlCipher.init(2, (Key)secretKeySpec);
            Element encryptedData = this.getEncryptedDataElement(document);
            xmlCipher.doFinal(document, encryptedData);
            XmlDecryptionResult xmlDecryptionResult = new XmlDecryptionResult(true, usedCertificate, null);
            xmlDecryptionResult.setAlgorithm(XpWSSecurity.resolveAlgorithmUri(mode.getNamespace()));
            xmlDecryptionResult.setAlgorithmUri(mode.getNamespace());
            xmlDecryptionResult.setVersion(XpWSSecurity.resolveAlgorithmVersion(mode.getNamespace()));
            return xmlDecryptionResult;
        }
        catch (Exception e) {
            String errorMessage = "Could not decrypt data with the Certificate serial: " + this.certificateUtility.serialNr2String(serialNumber) + " (" + String.valueOf(serialNumber) + ") , Issuer: " + issuerX500Principal.toString() + ": " + e.toString();
            return new XmlDecryptionResult(false, usedCertificate, errorMessage);
        }
    }

    private String getEncryptionKeyAlgorithmNS(Document document) {
        String algorithmNS;
        NodeList encryptedKeyMethodElements;
        Element encryptedKeyElement = this.getEncryptedKeyElement(document);
        if (encryptedKeyElement != null && (encryptedKeyMethodElements = encryptedKeyElement.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod")) != null && encryptedKeyMethodElements.getLength() > 0 && !StringUtils.isBlank((CharSequence)(algorithmNS = ((Element)encryptedKeyMethodElements.item(0)).getAttribute("Algorithm")))) {
            return algorithmNS;
        }
        return null;
    }

    private String getEncryptionDataAlgorithmNS(Document document) {
        String algorithmNS;
        NodeList encryptionMethodElements;
        Element encryptedDataElement = this.getEncryptedDataElement(document);
        if (encryptedDataElement != null && (encryptionMethodElements = encryptedDataElement.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod")) != null && encryptionMethodElements.getLength() > 0 && !StringUtils.isBlank((CharSequence)(algorithmNS = ((Element)encryptionMethodElements.item(0)).getAttribute("Algorithm")))) {
            return algorithmNS;
        }
        return null;
    }

    private Element getEncryptedDataElement(Document document) {
        NodeList encryptedDataElements = document.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
        if (encryptedDataElements != null && encryptedDataElements.getLength() > 0) {
            return (Element)encryptedDataElements.item(0);
        }
        return null;
    }

    private Element getEncryptedKeyElement(Document document) {
        NodeList encryptedKeyElements = document.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
        if (encryptedKeyElements != null && encryptedKeyElements.getLength() > 0) {
            return (Element)encryptedKeyElements.item(0);
        }
        return null;
    }

    public static enum XmlEncryptionType {
        TRIPLEDES("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "DESede", "1.0", 192),
        TRIPLEDES_KeyWrap("http://www.w3.org/2001/04/xmlenc#kw-tripledes", "DESede", "1.0", 192),
        AES_128("http://www.w3.org/2001/04/xmlenc#aes128-cbc", "AES", "1.0", 128),
        AES_128_KeyWrap("http://www.w3.org/2001/04/xmlenc#kw-aes128", "AES", "1.0", 128),
        AES_128_GCM("http://www.w3.org/2009/xmlenc11#aes128-gcm", "AES", "1.1", 128),
        AES_192("http://www.w3.org/2001/04/xmlenc#aes192-cbc", "AES", "1.0", 192),
        AES_192_KeyWrap("http://www.w3.org/2001/04/xmlenc#kw-aes192", "AES", "1.0", 192),
        AES_192_GCM("http://www.w3.org/2009/xmlenc11#aes192-gcm", "AES", "1.1", 192),
        AES_256("http://www.w3.org/2001/04/xmlenc#aes256-cbc", "AES", "1.0", 256),
        AES_256_KeyWrap("http://www.w3.org/2001/04/xmlenc#kw-aes256", "AES", "1.0", 256),
        AES_256_GCM("http://www.w3.org/2009/xmlenc11#aes256-gcm", "AES", "1.1", 256),
        RSA_v1dot5("http://www.w3.org/2001/04/xmlenc#rsa-1_5", "RSA", "1.0", 0),
        RSA_OAEP("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "RSA", "1.0", 0),
        RSA_OAEP_11("http://www.w3.org/2009/xmlenc11#rsa-oaep", "RSA", "1.1", 0);

        private final String namespace;
        private final String algorithm;
        private final String version;
        private final int keylength;

        private XmlEncryptionType(String namespace, String algorithm, String version, int keylength) {
            this.namespace = namespace;
            this.algorithm = algorithm;
            this.version = version;
            this.keylength = keylength;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public String getVersion() {
            return this.version;
        }

        public int getKeylength() {
            return this.keylength;
        }
    }
}

