/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.transport.ssl;

import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.security.PontonKeystore;
import jakarta.xml.bind.JAXBException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CertificateTrustManager
implements X509TrustManager {
    private static Log _log = LogFactory.getFactory().getInstance("Messenger.CertificateTrustManager");
    private final boolean _serverCertificateCheck;
    private final MessengerConfig messengerConfig;
    private final PontonKeystore keyStore;

    public CertificateTrustManager(PontonKeystore keyStore, MessengerConfig messengerConfig) {
        this(keyStore, messengerConfig, true);
    }

    public CertificateTrustManager(PontonKeystore keyStore, MessengerConfig messengerConfig, boolean serverCertificateCheck) {
        this.keyStore = keyStore;
        this.messengerConfig = messengerConfig;
        this._serverCertificateCheck = serverCertificateCheck;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        _log.trace((Object)("Client Certificate:" + String.valueOf(chain[0])));
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain != null && chain.length > 0) {
            _log.trace((Object)("Certificate chain contains " + chain.length + " certificates."));
            if (this._serverCertificateCheck) {
                try {
                    this.checkCertificate(chain);
                }
                catch (CertificateException e) {
                    _log.error((Object)("Received server certificate:\n" + chain[0].toString()));
                    _log.error((Object)e.getMessage());
                    throw e;
                }
            }
        } else {
            throw new CertificateException("No certificates in chain.");
        }
    }

    private void checkCertificate(X509Certificate[] chain) throws CertificateException, CertificateExpiredException, CertificateNotYetValidException {
        boolean certCheck = false;
        try {
            certCheck = this.messengerConfig.isSSLCertificateCheck();
        }
        catch (JAXBException e1) {
            certCheck = MessengerConfig.DEFAULT_SSL_CERTCHECK;
        }
        if (certCheck) {
            this.keyStore.verifyCertificateIssuer(chain[0]);
        } else {
            X509Certificate certificate = chain[0];
            if (_log.isTraceEnabled()) {
                _log.trace((Object)(" Certificate: " + certificate.getSubjectDN().getName()));
            }
            certificate.checkValidity();
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

