/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.transport;

import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.transport.HttpProxySelector;
import de.pontonconsulting.xmlpipe.messenger.transport.XpHttpClient;
import de.pontonconsulting.xmlpipe.security.ServerCertificateTrustManager;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.concurrent.Executor;
import javax.net.ssl.X509TrustManager;

public class XpHttpClientFactory {
    private final HttpProxySelector httpProxySelector;
    private final Executor executor;
    private final ServerCertificateTrustManager serverCertificateTrustManager;
    private final boolean useHttp1_1only;

    public XpHttpClientFactory(HttpProxySelector httpProxySelector, Executor executor, ServerCertificateTrustManager serverCertificateTrustManager, MessengerConfig messengerConfig) {
        this.httpProxySelector = httpProxySelector;
        this.executor = executor;
        this.serverCertificateTrustManager = serverCertificateTrustManager;
        this.useHttp1_1only = Boolean.valueOf(messengerConfig.getProperty("ponton.messenger.http_client.use_http_1_1_only"));
    }

    public XpHttpClient createXpHttpClient(PrivateKey key, X509Certificate[] certificateChain) {
        return new XpHttpClient(this.httpProxySelector, key, certificateChain, this.executor, this.serverCertificateTrustManager, this.useHttp1_1only);
    }

    public XpHttpClient createXpTrustAllHttpClient() {
        X509TrustManager trustManager = new X509TrustManager(this){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        return new XpHttpClient(this.httpProxySelector, null, null, this.executor, trustManager, this.useHttp1_1only);
    }
}

