/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.transport;

import de.pontonconsulting.common.mail.MimeMessage;
import de.pontonconsulting.xmlpipe.messenger.transport.BaseTransportProvider;
import de.pontonconsulting.xmlpipe.messenger.transport.ProviderResponse;
import de.pontonconsulting.xmlpipe.messenger.transport.SmtpSender;
import de.pontonconsulting.xmlpipe.messenger.transport.SmtpSenderFactory;
import de.pontonconsulting.xmlpipe.messenger.transport.TransportException;
import de.pontonconsulting.xmlpipe.messenger.transport.XpMessageInputStream;
import de.pontonconsulting.xmlpipe.util.EmailUtils;
import jakarta.activation.DataHandler;
import jakarta.mail.Address;
import jakarta.mail.AuthenticationFailedException;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SmtpProvider
extends BaseTransportProvider {
    private static final String TEXT_XML = "text/xml; charset=utf-8";
    private static final String MAIL_SUBJECT = "XML Business Message";
    private static final String SMTP_URI_ID = "mailto:";
    private static final String SMIME_URI = "smime:";
    private static final String ENCODING_DEFAULT = "base64";
    private static final String[] NAMES = new String[]{"SMTP", "SMIME"};
    private SmtpSenderFactory _smtpSenderFactory;
    private static final Log _log = LogFactory.getLog((String)"Messenger.SmtpProvider");

    @Override
    public void shutdown() {
    }

    @Override
    public boolean canHandleUri(String uri) {
        if (uri != null) {
            String lower = uri.toLowerCase();
            return lower.startsWith(SMTP_URI_ID) || lower.startsWith(SMIME_URI);
        }
        return false;
    }

    @Override
    public String getDefaultTransferEncoding() {
        return ENCODING_DEFAULT;
    }

    @Override
    public ProviderResponse sendData(File contentFile, long contentLength, String contentType, HashMap<String, String> outHeader, URI uri, X509Certificate[] certificateChain, PrivateKey key, String user, String password, int retryInterval) throws TransportException {
        throw new TransportException(-1, "The method SmtpProvider.sendData() is not yet implemented.");
    }

    @Override
    protected URI createURI(String destination) throws URISyntaxException {
        return EmailUtils.parseEmailAndGetURI(destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ProviderResponse sendMessage(File messageFile, File messageHeaderFile, URI destination, X509Certificate[] transportCertificateChain, PrivateKey key, String user, String password, int retryInterval) throws TransportException {
        ProviderResponse response;
        block9: {
            XpMessageInputStream xpStream = null;
            response = new ProviderResponse(destination.getScheme());
            try {
                String contentType;
                ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(Files.newInputStream(messageHeaderFile.toPath(), new OpenOption[0])));
                Map headers = (Map)ois.readObject();
                String from = (String)headers.get("From");
                SmtpSender smtpSender = null;
                smtpSender = StringUtils.isNotBlank((CharSequence)from) ? this._smtpSenderFactory.getSmtpSender(from) : this._smtpSenderFactory.getSmtpSender();
                ois.close();
                headers.remove("X-allow-header-in-payload");
                xpStream = new XpMessageInputStream(headers, messageFile);
                MimeMessage msg = this.updateContentTransferEncoding(new MimeMessage(smtpSender.getSession(), xpStream));
                msg.removeHeader("Content-Length");
                msg.setFrom((Address)new InternetAddress(smtpSender.getFrom()));
                InternetAddress[] address = new InternetAddress[]{new InternetAddress(destination.getSchemeSpecificPart())};
                msg.setRecipients(Message.RecipientType.TO, (Address[])address);
                if (msg.getSubject() == null) {
                    msg.setSubject(MAIL_SUBJECT);
                }
                if ((contentType = msg.getContentType()) == null) {
                    msg.setHeader("Content-Type", TEXT_XML);
                }
                smtpSender.sendMessage(msg);
                response.setFailed(false);
                IOUtils.closeQuietly((InputStream)xpStream);
            }
            catch (AuthenticationFailedException a) {
                String error = "SMTP Authentication failed for user: " + user;
                _log.error((Object)error);
                response.getHeaders().put("X-reply-text", error);
                response.setResponseMessage(error.getBytes());
                response.setFailed(true);
            }
            catch (Exception e) {
                String error = "Error while sending out email: " + e.getMessage();
                _log.error((Object)error);
                response.getHeaders().put("X-reply-text", error);
                response.setResponseMessage(error.getBytes());
                response.setFailed(true);
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(xpStream);
            }
        }
        return response;
    }

    private MimeMessage updateContentTransferEncoding(MimeMessage mimeMessage) throws MessagingException, IOException {
        MimeMessage newMimeMessage = new MimeMessage(mimeMessage.getSession());
        this.copyHeaders((Part)mimeMessage, (Part)newMimeMessage);
        ContentType contentType = new ContentType(mimeMessage.getContentType());
        if ("multipart".equalsIgnoreCase(contentType.getPrimaryType())) {
            MimeMultipart newMimeMultipart = this.copyMimeMultipart((Part)mimeMessage, contentType.getSubType());
            newMimeMessage.setContent((Multipart)newMimeMultipart);
            newMimeMessage.saveChanges();
            ContentType newContentType = new ContentType(mimeMessage.getContentType());
            newContentType.setParameter("boundary", new ContentType(newMimeMultipart.getContentType()).getParameter("boundary"));
            newMimeMessage.setHeader("Content-Type", newContentType.toString());
        } else {
            newMimeMessage.setDataHandler(new DataHandler(mimeMessage.getDataHandler().getDataSource()));
            newMimeMessage.saveChanges();
            newMimeMessage.setHeader("Content-Type", mimeMessage.getContentType());
            newMimeMessage.setHeader("Content-Transfer-Encoding", this.getDefaultTransferEncoding());
        }
        return newMimeMessage;
    }

    private MimeMultipart copyMimeMultipart(Part fromPart, String contentSubType) throws IOException, MessagingException {
        MimeMultipart mimeMultipart = (MimeMultipart)fromPart.getContent();
        MimeMultipart newMimeMultipart = new MimeMultipart(contentSubType);
        for (int i = 0; i < mimeMultipart.getCount(); ++i) {
            BodyPart bodyPart = mimeMultipart.getBodyPart(i);
            ContentType bodyPartContentType = new ContentType(bodyPart.getContentType());
            MimeBodyPart newBodyPart = new MimeBodyPart();
            this.copyHeaders((Part)bodyPart, (Part)newBodyPart);
            newBodyPart.setDataHandler(new DataHandler(bodyPart.getDataHandler().getDataSource()));
            newBodyPart.setHeader("Content-Type", bodyPart.getContentType());
            if (!"multipart".equalsIgnoreCase(bodyPartContentType.getPrimaryType())) {
                newBodyPart.setHeader("Content-Transfer-Encoding", this.getDefaultTransferEncoding());
            }
            newMimeMultipart.addBodyPart((BodyPart)newBodyPart);
        }
        return newMimeMultipart;
    }

    private void copyHeaders(Part fromPart, Part toPart) throws MessagingException {
        fromPart.getAllHeaders().asIterator().forEachRemaining(header -> {
            try {
                toPart.addHeader(header.getName(), header.getValue());
            }
            catch (MessagingException e) {
                _log.warn((Object)("Could not copy header '" + header.getName() + ": " + header.getValue() + "'."), (Throwable)e);
            }
        });
    }

    @Override
    public boolean isUsingSynchronousProtocol() {
        return false;
    }

    @Override
    public String[] getTransportNames() {
        return NAMES;
    }

    public void setSmtpSenderFactory(SmtpSenderFactory smtpSenderFactory) {
        this._smtpSenderFactory = smtpSenderFactory;
    }
}

