/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.transport;

import de.pontonconsulting.xmlpipe.events.ReloadConfiguration;
import de.pontonconsulting.xmlpipe.messenger.transport.ProviderResponse;
import de.pontonconsulting.xmlpipe.messenger.transport.TransportException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import org.springframework.context.ApplicationListener;

public abstract class BaseTransportProvider
implements ApplicationListener<ReloadConfiguration> {
    public abstract boolean isUsingSynchronousProtocol();

    public abstract boolean canHandleUri(String var1);

    public abstract String getDefaultTransferEncoding();

    public abstract ProviderResponse sendData(File var1, long var2, String var4, HashMap<String, String> var5, URI var6, X509Certificate[] var7, PrivateKey var8, String var9, String var10, int var11) throws TransportException, InterruptedException;

    public abstract ProviderResponse sendMessage(File var1, File var2, URI var3, X509Certificate[] var4, PrivateKey var5, String var6, String var7, int var8) throws TransportException, InterruptedException;

    public ProviderResponse sendMessage(File messageFile, File messageHeaderFile, String destination, X509Certificate[] chain, PrivateKey key, String user, String password, int retryInterval) throws TransportException, URISyntaxException, InterruptedException {
        return this.sendMessage(messageFile, messageHeaderFile, this.createURI(destination), chain, key, user, password, retryInterval);
    }

    protected URI createURI(String destination) throws URISyntaxException {
        return new URI(destination);
    }

    public abstract String[] getTransportNames();

    public abstract void shutdown();

    public void onApplicationEvent(ReloadConfiguration event) {
    }
}

