/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.service;

import de.ponton.xmlpipe.queue.InboundQueue;
import de.ponton.xmlpipe.queue.QueueMessageConsumer;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.messenger.InboundQueueException;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.FileType;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpInboundMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdapterService {
    private static final String DEFAULT_ADAPTER = "--------";
    private static final Logger AUDIT = LogManager.getLogger((String)"Audit.AdapterService");
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.AdapterService");
    private final InboundQueue _inboundMessageQueue;
    private final MessageDAO _messageDAO;
    private final IFolders _folders;
    private final QueueMessageConsumer inboundMessageConsumer;
    private final ArchiveProcessor archiveProcessor;

    public AdapterService(InboundQueue inboundMessageQueue, MessageDAO messageDAO, IFolders folders, QueueMessageConsumer inboundMessageConsumer, ArchiveProcessor archiveProcessor) {
        this._inboundMessageQueue = inboundMessageQueue;
        this._messageDAO = messageDAO;
        this._folders = folders;
        this.inboundMessageConsumer = inboundMessageConsumer;
        this.archiveProcessor = archiveProcessor;
    }

    public void changeAdapter(String user, long messageDataId, String adapterId) throws InboundQueueException, IOException, ClassNotFoundException, DbException {
        this.changeAdapter(user, messageDataId, adapterId, "oldAdapter");
    }

    public void changeAdapter(String user, long messageDataId, String adapterId, String oldAdapterId) throws IOException, InboundQueueException, ClassNotFoundException, DbException {
        block10: {
            if (DEFAULT_ADAPTER.equals(adapterId)) {
                LOG.info("No destination Adapter selected.");
                return;
            }
            try {
                MessageInfo info = this._messageDAO.getMessageInfo(messageDataId);
                if (info == null) {
                    LOG.warn("Could not change adapter for message with unknown id: [{}].", (Object)messageDataId);
                    throw new IllegalArgumentException("Could not change adapter for message with unknown id: " + messageDataId + ".");
                }
                if (!info.isInbound()) {
                    LOG.warn("Could not change adapter for the outbound message with id: [{}].", (Object)messageDataId);
                    throw new IllegalArgumentException("Could not change adapter for the outbound message with id: " + messageDataId + ".");
                }
                if (this.inboundMessageConsumer.interruptDelivery(messageDataId)) {
                    LOG.warn("Could not change adapter for message in delivery with id: [{}]. MessageTask was interrupted anyway.", (Object)messageDataId);
                    throw new IllegalArgumentException("Could not change adapter for message in delivery with id: " + messageDataId + ".");
                }
                String messageId = info.getMessageId();
                boolean changed = this._inboundMessageQueue.changeAdapterId(messageDataId, adapterId);
                if (changed) {
                    AUDIT.info("user '{}' rerouted message {} from adapter {} to adapter {}", (Object)user, (Object)messageId, (Object)oldAdapterId, (Object)adapterId);
                    LOG.info("user '{}' rerouted message {} from adapter {} to adapter {}", (Object)user, (Object)messageId, (Object)oldAdapterId, (Object)adapterId);
                    break block10;
                }
                try {
                    AUDIT.info("user '{}' triggered a resend of message {} to adapter {}", (Object)user, (Object)messageId, (Object)adapterId);
                    LOG.info("user '{}' triggered a resend of message {} to adapter {}", (Object)user, (Object)messageId, (Object)adapterId);
                    File inboundMessageFolder = new File(this._folders.getWorkInboundFolder(), String.valueOf(info.getDatabaseId()));
                    XpInboundMessage xpInboundMessage = this._messageDAO.loadXpInboundMessage(messageDataId);
                    if (Objects.isNull(xpInboundMessage) || xpInboundMessage.wasStoredWithMessengerVersionBelow5_0()) {
                        xpInboundMessage = new XpInboundMessage(this.archiveProcessor.getXpMessageFromArchive(info).orElseThrow(() -> new IOException("Can't find old XpMessage for message " + messageId)));
                    }
                    this.archiveProcessor.exportArchiveFiles(info, inboundMessageFolder, new FileType[0]);
                    this._messageDAO.updateMessageFolder(info.getDatabaseId(), xpInboundMessage.getCurrentContentReferenceFolder());
                    this._inboundMessageQueue.deliverMessageToAdapter(adapterId, xpInboundMessage);
                    LOG.info("Message {} [{}] is queued for resend to adapter id: {}", (Object)messageId, (Object)messageDataId, (Object)adapterId);
                }
                catch (InboundQueueException | IOException ex) {
                    LOG.error("could not resend message {} [{}] to adapter {}: {}", (Object)messageId, (Object)messageDataId, (Object)adapterId, (Object)ex.getMessage());
                    throw ex;
                }
            }
            catch (DbException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
    }
}

