/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.packaging;

import de.pontonconsulting.common.activation.SimpleFileDataSource;
import de.pontonconsulting.common.security.IPasswordCrypt;
import de.pontonconsulting.xmlpipe.as.AS1ObjectFactory;
import de.pontonconsulting.xmlpipe.as.AS2ObjectFactory;
import de.pontonconsulting.xmlpipe.as.AS3ObjectFactory;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.listener.ListenerManager;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.message.XpMessageAttachment;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ProcessingResult;
import de.pontonconsulting.xmlpipe.messenger.ReceiveFromListener;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MDNDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4UIOptions;
import de.pontonconsulting.xmlpipe.messenger.packaging.BasePackager;
import de.pontonconsulting.xmlpipe.messenger.packaging.EbXml20UIOptions;
import de.pontonconsulting.xmlpipe.messenger.packaging.PackagingException;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Plain
extends BasePackager {
    public static final String PACKAGERNAME = "Plain";
    private static final String ATTACHMENT_FILENAME = "attachment; filename=";
    private static final String US_ASCII = "US-ASCII";
    private static final String RELATED = "related";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String CONTENT_TYPE = "Content-Type";
    public static final Logger _log = LogManager.getLogger((String)"Messenger.PlainPackager");
    private static final UIOption[] OPTIONS;
    public static final String PASSWORD = "/password";
    private XpMessage _message;

    public Plain(MessengerConfig messengerConfig, ListenerManager listenerManager, MessengerLog messengerLog, MDNDataDAO mdnDataDAO, IPasswordCrypt passwordCrypt, KeystoreBean keystore, Profiles profiles, Agreements agreements, IdGenerator idGenerator, MessageDAO messageDAO, ReferenceDateTask referenceDate, IFolders folders, ReceiveFromListener receiveFromListener, SchemataConfig schemataConfig, IMessengerProperties messengerProperties, CertificateUtility certificateUtility, AS1ObjectFactory as1ObjectFactory, AS2ObjectFactory as2ObjectFactory, AS3ObjectFactory as3ObjectFactory, EbXml20UIOptions ebXml20UIOptions, AS4UIOptions as4UIOptions, MessageWorkDataDAO messageWorkDataDAO) {
        super(messengerConfig, listenerManager, messengerLog, mdnDataDAO, passwordCrypt, keystore, profiles, agreements, idGenerator, messageDAO, referenceDate, folders, receiveFromListener, schemataConfig, messengerProperties, certificateUtility, as1ObjectFactory, as2ObjectFactory, as3ObjectFactory, ebXml20UIOptions, as4UIOptions, messageWorkDataDAO);
    }

    @Override
    public UIOption[] getUIOptions() {
        return OPTIONS;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void storePrequeueingFormat(XpMessage message, File messageFile, File messageHeaderFile) throws PackagingException {
        BufferedOutputStream messageDat = null;
        BufferedOutputStream messageDatHeader = null;
        this._message = message;
        this.checkMessageType();
        this.checkTransportValidity();
        boolean ackRequested = false;
        try {
            String value = this._message.getCommunication().getPackagingOptionValue("/RequestACK");
            ackRequested = Boolean.parseBoolean(value);
        }
        catch (OptionNotFoundException e3) {
            ackRequested = false;
        }
        this._message.setAckRequested(ackRequested);
        try {
            messageDat = new BufferedOutputStream(Files.newOutputStream(messageFile.toPath(), new OpenOption[0]));
            messageDatHeader = new BufferedOutputStream(Files.newOutputStream(messageHeaderFile.toPath(), new OpenOption[0]));
            this.writeToStream(messageDat, messageDatHeader);
            if (_log.isTraceEnabled()) {
                _log.trace("Plain Message created.");
            }
            this.closeOutputStream(messageDat);
            this.closeOutputStream(messageDatHeader);
            return;
        }
        catch (PackagingException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new PackagingException(24000, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.closeOutputStream(messageDat);
                this.closeOutputStream(messageDatHeader);
                throw throwable;
            }
        }
    }

    @Override
    protected Logger getLogger() {
        return _log;
    }

    private void closeOutputStream(OutputStream messageDat) {
        if (messageDat != null) {
            try {
                messageDat.close();
            }
            catch (Exception e1) {
                _log.debug(e1.getMessage());
            }
        }
    }

    private void writeToStream(OutputStream messageDat, OutputStream messageDatHeader) throws Exception {
        Vector<XpMessageAttachment> attachments = this._message.getAttachments();
        if (attachments.size() == 0) {
            this.createSinglePart(messageDat, messageDatHeader);
        } else {
            this.createMultiPart(messageDat, messageDatHeader, attachments);
        }
    }

    private void createMultiPart(OutputStream messageDat, OutputStream messageDatHeader, Vector<XpMessageAttachment> attachments) throws MessagingException, IOException {
        try (SimpleFileDataSource dataSource = new SimpleFileDataSource(this._message.getCurrentContentType(), this._message.getCurrentContentReference());){
            MimeMultipart multi = new MimeMultipart(RELATED);
            MimeBodyPart mbp1 = new MimeBodyPart();
            mbp1.setDataHandler(new DataHandler((DataSource)dataSource));
            mbp1.addHeader(CONTENT_TYPE, this._message.getCurrentContentType());
            mbp1.addHeader("Content-Id", this._message.getMessageId());
            mbp1.addHeader("X-MessageId", this._message.getMessageId());
            String poFilename = this._message.getProcessingDirective("ProcessedOriginalFilename");
            if (StringUtils.isNotBlank((CharSequence)poFilename)) {
                String encoded = "";
                try {
                    encoded = MimeUtility.encodeText((String)poFilename.trim());
                }
                catch (UnsupportedEncodingException ex) {
                    _log.warn(ex.getMessage());
                    encoded = poFilename.trim();
                }
                mbp1.addHeader("Content-Disposition", ATTACHMENT_FILENAME + encoded);
            }
            mbp1.addHeader(CONTENT_LENGTH, String.valueOf(this._message.getCurrentContentReference().length()));
            mbp1.addHeader("X-allow-header-in-payload", "false");
            multi.addBodyPart((BodyPart)mbp1);
            for (XpMessageAttachment element : attachments) {
                MimeBodyPart mbp = new MimeBodyPart();
                mbp.setDataHandler(new DataHandler((DataSource)new SimpleFileDataSource(element.getType(), element.getAttachment())));
                mbp.addHeader(CONTENT_TYPE, element.getType());
                mbp.addHeader(CONTENT_LENGTH, String.valueOf(element.getAttachment().length()));
                String filename = element.getAttachment().getName();
                String encoded = URLEncoder.encode(filename, StandardCharsets.US_ASCII);
                mbp.addHeader("Content-Id", encoded);
                mbp.addHeader("Content-Disposition", ATTACHMENT_FILENAME + filename);
                multi.addBodyPart((BodyPart)mbp);
            }
            multi.writeTo(messageDat);
            HashMap<String, String> header2 = new HashMap<String, String>();
            Optional.ofNullable(this._message.getProcessingDirective("X-CopyOf")).ifPresent(value -> header2.put("X-CopyOf", (String)value));
            Optional.ofNullable(this._message.getProcessingDirective("X-OriginalReceiver")).ifPresent(value -> header2.put("X-OriginalReceiver", (String)value));
            header2.put(CONTENT_TYPE, multi.getContentType());
            header2.put("X-MessageId", this._message.getMessageId());
            String originalFilename = this._message.getProcessingDirective("OriginalFilename");
            if (StringUtils.isNotBlank((CharSequence)originalFilename)) {
                String encoded = "";
                try {
                    encoded = MimeUtility.encodeText((String)originalFilename.trim());
                }
                catch (UnsupportedEncodingException ex) {
                    _log.warn(ex.getMessage());
                    encoded = originalFilename.trim();
                }
                header2.put("X-Original-Filename", encoded);
            }
            this.writeHeader(messageDatHeader, header2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSinglePart(OutputStream messageDat, OutputStream messageDatHeader) throws FileNotFoundException, IOException {
        String poFilename;
        File content = this._message.getCurrentContentReference();
        HashMap<String, String> header2 = new HashMap<String, String>();
        Optional.ofNullable(this._message.getProcessingDirective("X-CopyOf")).ifPresent(value -> header2.put("X-CopyOf", (String)value));
        Optional.ofNullable(this._message.getProcessingDirective("X-OriginalReceiver")).ifPresent(value -> header2.put("X-OriginalReceiver", (String)value));
        header2.put("Content-Id", this._message.getMessageId());
        header2.put("X-MessageId", this._message.getMessageId());
        String originalFilename = this._message.getProcessingDirective("OriginalFilename");
        if (StringUtils.isNotBlank((CharSequence)originalFilename)) {
            String encoded = "";
            try {
                encoded = MimeUtility.encodeText((String)originalFilename.trim());
            }
            catch (Exception ex) {
                _log.warn(ex.getMessage());
                encoded = originalFilename.trim();
            }
            header2.put("X-Original-Filename", encoded);
        }
        if (StringUtils.isNotBlank((CharSequence)(poFilename = this._message.getProcessingDirective("ProcessedOriginalFilename")))) {
            String encoded = "";
            try {
                encoded = MimeUtility.encodeText((String)poFilename.trim());
            }
            catch (UnsupportedEncodingException ex) {
                _log.warn(ex.getMessage());
                encoded = poFilename.trim();
            }
            header2.put(CONTENT_TYPE, this._message.getCurrentContentType() + "; name=" + encoded);
        }
        header2.put(CONTENT_LENGTH, String.valueOf(content.length()));
        header2.put("X-allow-header-in-payload", "false");
        BufferedInputStream in = null;
        try {
            byte[] buffer = new byte[16384];
            in = new BufferedInputStream(Files.newInputStream(content.toPath(), new OpenOption[0]));
            int len = 0;
            while ((len = ((InputStream)in).read(buffer)) != -1) {
                messageDat.write(buffer, 0, len);
            }
            this.writeHeader(messageDatHeader, header2);
            this.closeInputStream(in);
            this.closeOutputStream(messageDat);
        }
        catch (Throwable throwable) {
            this.closeInputStream(in);
            this.closeOutputStream(messageDat);
            throw throwable;
        }
    }

    private void closeInputStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeader(OutputStream messageDatHeader, HashMap<String, String> header2) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(messageDatHeader);){
            oos.writeObject(header2);
        }
    }

    private void checkTransportValidity() throws PackagingException {
        String url = this._message.getCommunication().getTransportURL().toLowerCase();
        if (!(url.startsWith("http:") || url.startsWith("https:") || url.startsWith("ftp:") || url.startsWith("ftps:"))) {
            throw new PackagingException(24002, "Plain-Packager only supports http(s) and ftp(s) transport.");
        }
    }

    private void checkMessageType() throws PackagingException {
        if ("PING".equals(this._message.getMessageType()) && "ponton".equals(this._message.getSchemaSet()) && "2.1".equals(this._message.getMessageVersion())) {
            throw new PackagingException(24001, "Plain-Packager doesn't support pings");
        }
    }

    @Override
    public XpMessage createAsyncAck(List<ProcessingResult> result, XpMessage xpResponse, boolean signed) throws PackagingException {
        return null;
    }

    @Override
    public XpMessage createErrorResponse(List<ProcessingResult> result, XpMessage xpResponse, boolean signed) throws PackagingException {
        return null;
    }

    static {
        UIOption requestAck = new UIOption("packagingOption.plain.request.ack", "/RequestACK", "boolean", "true", "hilfe_header_requestack", "packagingOption.plain.request.ack", "packagingOption.agreement.help.plain.request.ack", "packagingOption.profile.help.plain.request.ack", UIOption.SENDER);
        requestAck.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOption password = new UIOption("packagingOption.plain.password", PASSWORD, "string", "", "hilfe_header_password", "packagingOption.plain.password", "packagingOption.agreement.help.plain.password", "packagingOption.profile.help.plain.password", UIOption.RECEIVER);
        password.setVisibility(UIOption.VISIBILITY.INBOUND);
        OPTIONS = new UIOption[]{requestAck, password};
    }
}

