/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.packaging;

import de.pontonconsulting.xmlpipe.jaxb.as4.Envelope;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.io.output.XmlStreamWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JAXBToSOAPConverter {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.JAXBToSOAPConverter");
    private static final String AS4MESSAGE_PONTON_DE = "<as4message@ponton.de>";
    private static final String AS4SIGNAL_PONTON_DE = "<as4signal@ponton.de>";
    private static final String APPLICATION_SOAP_XML = "application/soap+xml";
    private final JAXBContext _jaxbContext;
    private final MessageFactory _messageFactory;

    public JAXBToSOAPConverter(JAXBContext jaxbContext, MessageFactory messageFactory) {
        this._jaxbContext = jaxbContext;
        this._messageFactory = messageFactory;
    }

    public SOAPMessage convertEnvelope(Envelope envelope, boolean isMessage) {
        SOAPMessage result = null;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            this.marshal(envelope, byteStream);
            byte[] contentArray = byteStream.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(contentArray);
            MimeHeaders mimeHeaders = new MimeHeaders();
            mimeHeaders.setHeader("Content-Type", APPLICATION_SOAP_XML);
            if (isMessage) {
                mimeHeaders.setHeader("Content-ID", AS4MESSAGE_PONTON_DE);
            } else {
                mimeHeaders.setHeader("Content-ID", AS4SIGNAL_PONTON_DE);
            }
            result = this._messageFactory.createMessage(mimeHeaders, (InputStream)inputStream);
        }
        catch (JAXBException e) {
            LOG.error("could not marshal JAXB", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("could not read XML from stream", (Throwable)e);
        }
        catch (SOAPException e) {
            LOG.error("could not create SOAP message", (Throwable)e);
        }
        return result;
    }

    private void marshal(Envelope envelope, OutputStream outputStream) throws JAXBException {
        Marshaller marshaller = this._jaxbContext.createMarshaller();
        marshaller.marshal((Object)envelope, (Writer)new XmlStreamWriter(outputStream));
    }
}

