/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.packaging;

import de.pontonconsulting.common.security.IPasswordCrypt;
import de.pontonconsulting.xmlpipe.as.AS1ObjectFactory;
import de.pontonconsulting.xmlpipe.as.AS2ObjectFactory;
import de.pontonconsulting.xmlpipe.as.AS3ObjectFactory;
import de.pontonconsulting.xmlpipe.as.ASException;
import de.pontonconsulting.xmlpipe.as.ASMessage;
import de.pontonconsulting.xmlpipe.as.MDNParameters;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpp.CertificateIdNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.listener.ListenerManager;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ProcessingResult;
import de.pontonconsulting.xmlpipe.messenger.ReceiveFromListener;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MDNDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4UIOptions;
import de.pontonconsulting.xmlpipe.messenger.packaging.BasePackager;
import de.pontonconsulting.xmlpipe.messenger.packaging.EbXml20UIOptions;
import de.pontonconsulting.xmlpipe.messenger.packaging.PackagingException;
import de.pontonconsulting.xmlpipe.messenger.transport.ProviderResponse;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.MessageDigestCalculator;
import de.pontonconsulting.xmlpipe.security.SecurityException;
import de.pontonconsulting.xmlpipe.security.smime.SMIMECompressor;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEEncrypter;
import de.pontonconsulting.xmlpipe.security.smime.SMIMESigner;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import jakarta.mail.Header;
import jakarta.mail.Multipart;
import jakarta.mail.internet.InternetHeaders;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;

public abstract class ASPackager
extends BasePackager {
    public static final String DUMMY_URL = "messenger@pontonxp.de";
    protected static final int SIXTYFOUR_KB = 65536;
    protected static final int ONE_MB = 0x100000;
    public static final String PRIMARY_TYPE_MULTIPART = "multipart";
    public static final String SECONDARY_TYPE_RELATED = "related";
    public static final String SUBTYPE_REPORT = "report; report-type=disposition-notification";
    public static final String CONTENT_TYPE_MULTIPART_REPORT = "multipart/report";
    public static final String CONTENT_TYPE_MULTIPART_SIGNED = "multipart/signed";
    public static final String ATTACHMENT_TYPE_BUSINESS_DATA = "business-data";
    public static final String ATTACHMENT_TYPE_SIGNATURE = "signature";
    public static final String REQUEST_MDN = "/RequestMDN";
    public static final String SIGN_MESSAGE = "/SignMessage";
    public static final String ENCRYPT_MESSAGE = "/EncryptMessage";
    public static final String EXTENDED_ENCRYPTION_ALGORITHM = "/EncryptMessage/ExtendedEncryptionAlgorithm";
    public static final String COMPRESS_MESSAGE = "/CompressMessage";
    public static final String SMIME_MDN_SIGNATURE = "/SmimeMdnSignature";
    public static final String DUPLICATE_ELIMINATION = "/DuplicateElimination";
    public static final String WITH_BODY = "/WithBody";
    public static final String SUBJECT = "/Subject";
    public static final String MAIL_CLIENT_SUPPORT = "/MailClientSupport";
    public static final String FALSE = "false";
    public static final String OFF = "off";
    public static final String SHA1_SIGNED = "SHA-1 signed";
    public static final String SHA_224_SIGNED = "SHA-224 signed";
    public static final String SHA_256_SIGNED = "SHA-256 signed";
    public static final String SHA_384_SIGNED = "SHA-384 signed";
    public static final String SHA_512_SIGNED = "SHA-512 signed";
    public static final String SHA1_PSS_SIGNED = "SHA-1/PSS signed";
    public static final String SHA_224_PSS_SIGNED = "SHA-224/PSS signed";
    public static final String SHA_256_PSS_SIGNED = "SHA-256/PSS signed";
    public static final String SHA_384_PSS_SIGNED = "SHA-384/PSS signed";
    public static final String SHA_512_PSS_SIGNED = "SHA-512/PSS signed";
    public static final String SHA_256_ECDSA_SIGNED = "SHA-256/ECDSA signed";
    public static final String SHA_384_ECDSA_SIGNED = "SHA-384/ECDSA signed";
    public static final String SHA_512_ECDSA_SIGNED = "SHA-512/ECDSA signed";
    public static final String MD5_SIGNED = "MD5 signed";
    public static final String SAME_AS_BUSINESS_SIGNATURE = "Same as business signature";
    private static final Map<String, String> OPTION_TO_SIGN_ALG;
    public static final String UNSIGNED = "unsigned";
    public static final String SMTP_RESPONSE = "SMTP response";
    protected static CertificateFactory _certFactory;
    private final SMIMECompressor _smimeCompressor;
    private final SMIMEEncrypter _smimeEncrypter;
    private final SMIMESigner _smimeSigner;
    protected XpMessage _xpMessage;
    protected ASMessage _asMessage;
    private Logger _log;
    protected boolean _includeHeaderInDigestCalculation;
    protected boolean _needsTransferEncoding = true;
    static final UIOption UIOPTION_SIGN;
    static final UIOption UIOPTION_REQUEST_MDN;
    static final UIOption UIOPTION_COMPRESS;
    static final UIOption UIOPTION_ENCRYPT;
    static final UIOption UIOPTION_EXTENDED_ENCRYPTION_ALGORITHM;
    static final UIOption UIOPTION_DUPLICATE_ELIMINATION;
    private static final String OPTION_VALUE_DES_EDE3_CBC = "DES_EDE3_CBC";
    private static final String OPTION_VALUE_AES128_CBC = "AES128_CBC";
    private static final String OPTION_VALUE_AES192_CBC = "AES192_CBC";
    private static final String OPTION_VALUE_AES256_CBC = "AES256_CBC";
    private static final String OPTION_VALUE_DES_EDE3_CBC_OAEP = "DES_EDE3_CBC/OAEP_SHA1";
    private static final String OPTION_VALUE_AES128_CBC_OAEP = "AES128_CBC/OAEP_SHA1";
    private static final String OPTION_VALUE_AES192_CBC_OAEP = "AES192_CBC/OAEP_SHA1";
    private static final String OPTION_VALUE_AES256_CBC_OAEP = "AES256_CBC/OAEP_SHA1";
    private static final String OPTION_VALUE_AES128_CBC_OAEP_SHA256 = "AES128_CBC/OAEP_SHA256";
    private static final String OPTION_VALUE_AES192_CBC_OAEP_SHA256 = "AES192_CBC/OAEP_SHA256";
    private static final String OPTION_VALUE_AES256_CBC_OAEP_SHA256 = "AES256_CBC/OAEP_SHA256";
    private static final String OPTION_VALUE_AES128_CBC_OAEP_SHA512 = "AES128_CBC/OAEP_SHA512";
    private static final String OPTION_VALUE_AES192_CBC_OAEP_SHA512 = "AES192_CBC/OAEP_SHA512";
    private static final String OPTION_VALUE_AES256_CBC_OAEP_SHA512 = "AES256_CBC/OAEP_SHA512";
    private static final String OPTION_VALUE_AES128_GCM_OAEP_SHA256 = "AES128_GCM/OAEP_SHA256";
    private static final String OPTION_VALUE_AES192_GCM_OAEP_SHA256 = "AES192_GCM/OAEP_SHA256";
    private static final String OPTION_VALUE_AES256_GCM_OAEP_SHA256 = "AES256_GCM/OAEP_SHA256";
    private static final String OPTION_VALUE_AES128_GCM_OAEP_SHA512 = "AES128_GCM/OAEP_SHA512";
    private static final String OPTION_VALUE_AES192_GCM_OAEP_SHA512 = "AES192_GCM/OAEP_SHA512";
    private static final String OPTION_VALUE_AES256_GCM_OAEP_SHA512 = "AES256_GCM/OAEP_SHA512";
    private static final String OPTION_VALUE_AES128_GCM = "AES128_GCM";
    private static final String OPTION_VALUE_AES192_GCM = "AES192_GCM";
    private static final String OPTION_VALUE_AES256_GCM = "AES256_GCM";
    private static final String OPTION_VALUE_AES128_GCM_ECDH = "AES128_GCM/ECDH_SHA224";
    private static final String OPTION_VALUE_AES192_GCM_ECDH = "AES192_GCM/ECDH_SHA224";
    private static final String OPTION_VALUE_AES256_GCM_ECDH = "AES256_GCM/ECDH_SHA224";
    private static final String OPTION_VALUE_AES128_GCM_ECDH_SHA256 = "AES128_GCM/ECDH_SHA256";
    private static final String OPTION_VALUE_AES192_GCM_ECDH_SHA256 = "AES192_GCM/ECDH_SHA256";
    private static final String OPTION_VALUE_AES256_GCM_ECDH_SHA256 = "AES256_GCM/ECDH_SHA256";
    private static final String OPTION_VALUE_AES128_GCM_ECDH_SHA512 = "AES128_GCM/ECDH_SHA512";
    private static final String OPTION_VALUE_AES192_GCM_ECDH_SHA512 = "AES192_GCM/ECDH_SHA512";
    private static final String OPTION_VALUE_AES256_GCM_ECDH_SHA512 = "AES256_GCM/ECDH_SHA512";

    public static String getSignAlgorithm(String signOption) {
        return OPTION_TO_SIGN_ALG.get(signOption);
    }

    public ASPackager(MessengerConfig messengerConfig, ListenerManager listenerManager, MessengerLog messengerLog, MDNDataDAO mdnDataDAO, IPasswordCrypt passwordCrypt, KeystoreBean keystore, Profiles profiles, Agreements agreements, IdGenerator idGenerator, MessageDAO messageDAO, ReferenceDateTask referenceDate, IFolders folders, ReceiveFromListener receiveFromListener, SchemataConfig schemataConfig, IMessengerProperties messengerProperties, CertificateUtility certificateUtility, AS1ObjectFactory as1ObjectFactory, AS2ObjectFactory as2ObjectFactory, AS3ObjectFactory as3ObjectFactory, EbXml20UIOptions ebXml20UIOptions, AS4UIOptions as4UIOptions, SMIMECompressor smimeCompressor, SMIMEEncrypter smimeEncrypter, SMIMESigner smimeSigner, MessageWorkDataDAO messageWorkDataDAO) {
        super(messengerConfig, listenerManager, messengerLog, mdnDataDAO, passwordCrypt, keystore, profiles, agreements, idGenerator, messageDAO, referenceDate, folders, receiveFromListener, schemataConfig, messengerProperties, certificateUtility, as1ObjectFactory, as2ObjectFactory, as3ObjectFactory, ebXml20UIOptions, as4UIOptions, messageWorkDataDAO);
        this._smimeCompressor = smimeCompressor;
        this._smimeEncrypter = smimeEncrypter;
        this._smimeSigner = smimeSigner;
        if (_certFactory == null) {
            try {
                _certFactory = CertificateFactory.getInstance("X.509", "BC");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._includeHeaderInDigestCalculation = false;
    }

    protected abstract MessageDigestCalculator createMessageDigestCalculator(String var1) throws SecurityException;

    protected abstract boolean preHandleTransmissionResponse(long var1, ProviderResponse var3);

    @Override
    public boolean handleTransmissionResponse(long messageDataId, ProviderResponse response) {
        if (this.preHandleTransmissionResponse(messageDataId, response)) {
            return super.handleTransmissionResponse(messageDataId, response);
        }
        return false;
    }

    public void setLogger(Logger log) {
        this._log = log;
    }

    @Override
    protected Logger getLogger() {
        return this._log;
    }

    private void setSignedReceiptParameters(String dispositionNotificationTo) {
        try {
            MDNParameters mdnParams = new MDNParameters((String)StringUtils.defaultIfEmpty((CharSequence)dispositionNotificationTo, (CharSequence)DUMMY_URL));
            this._asMessage.setMDNParameters(mdnParams);
            String option = this._xpMessage.getCommunication().getPackagingOptionValue(REQUEST_MDN);
            if (SHA1_SIGNED.equals(option)) {
                this._asMessage.setMDNRequested(true);
                mdnParams.setSignedReceiptMicAlgValues(new String[]{"sha1"});
                mdnParams.setSignedReceiptProtocolValues(new String[]{"pkcs7-signature"});
            } else if (SHA_224_SIGNED.equals(option)) {
                this._asMessage.setMDNRequested(true);
                mdnParams.setSignedReceiptMicAlgValues(new String[]{"sha224", "sha-224"});
                mdnParams.setSignedReceiptProtocolValues(new String[]{"pkcs7-signature"});
            } else if (SHA_256_SIGNED.equals(option)) {
                this._asMessage.setMDNRequested(true);
                mdnParams.setSignedReceiptMicAlgValues(new String[]{"sha256", "sha-256"});
                mdnParams.setSignedReceiptProtocolValues(new String[]{"pkcs7-signature"});
            } else if (SHA_384_SIGNED.equals(option)) {
                this._asMessage.setMDNRequested(true);
                mdnParams.setSignedReceiptMicAlgValues(new String[]{"sha384", "sha-384"});
                mdnParams.setSignedReceiptProtocolValues(new String[]{"pkcs7-signature"});
            } else if (SHA_512_SIGNED.equals(option)) {
                this._asMessage.setMDNRequested(true);
                mdnParams.setSignedReceiptMicAlgValues(new String[]{"sha512", "sha-512"});
                mdnParams.setSignedReceiptProtocolValues(new String[]{"pkcs7-signature"});
            } else if (MD5_SIGNED.equals(option)) {
                this._asMessage.setMDNRequested(true);
                mdnParams.setSignedReceiptMicAlgValues(new String[]{"md5"});
                mdnParams.setSignedReceiptProtocolValues(new String[]{"pkcs7-signature"});
            } else if (UNSIGNED.equals(option)) {
                this._asMessage.setMDNRequested(true);
                this._asMessage.getMDNParameters().setSignedReceiptMicAlgRequired(false);
                this._asMessage.getMDNParameters().setSignedReceiptProtocolRequired(false);
            } else if (SMTP_RESPONSE.equals(option)) {
                this._asMessage.setHandleResponse(true);
                this._asMessage.setMDNRequested(false);
                this._asMessage.getMDNParameters().setSignedReceiptMicAlgRequired(false);
                this._asMessage.getMDNParameters().setSignedReceiptProtocolRequired(false);
            } else {
                this._asMessage.setMDNRequested(false);
                this._asMessage.getMDNParameters().setSignedReceiptMicAlgRequired(false);
                this._asMessage.getMDNParameters().setSignedReceiptProtocolRequired(false);
            }
        }
        catch (OptionNotFoundException onfe) {
            this._asMessage.setMDNRequested(false);
            this._asMessage.getMDNParameters().setSignedReceiptMicAlgRequired(false);
            this._asMessage.getMDNParameters().setSignedReceiptProtocolRequired(false);
        }
    }

    protected final void prepareMessage(String dispositionNotificationTo) throws ASException, DbException {
        String option2;
        this.setSignedReceiptParameters(dispositionNotificationTo);
        this._xpMessage.setAckRequested(this.isAckRequired());
        try {
            option2 = this._xpMessage.getCommunication().getPackagingOptionValue(SIGN_MESSAGE);
            if (!UNSIGNED.equals(option2)) {
                this._includeHeaderInDigestCalculation = true;
            }
        }
        catch (OptionNotFoundException option2) {
            // empty catch block
        }
        try {
            option2 = this._xpMessage.getCommunication().getPackagingOptionValue(ENCRYPT_MESSAGE);
            if ("true".equals(option2)) {
                this._includeHeaderInDigestCalculation = true;
            }
        }
        catch (OptionNotFoundException option3) {
            // empty catch block
        }
        this.calculateMessageDigest();
        String micDigest = this._asMessage.getMICDigest();
        if (StringUtils.isNotBlank((CharSequence)micDigest)) {
            this.getMdnDataDAO().insertMDNData(this._asMessage.getMessageId(), micDigest, this._asMessage.getMICAlgorithm());
        }
        this.signMessage();
        this.compressMessage();
        this.encryptMessage();
    }

    protected boolean isAckRequired() {
        return this._asMessage.isMDNRequested();
    }

    private final void signMessage() throws ASException {
        try {
            String option = this._xpMessage.getCommunication().getPackagingOptionValue(SIGN_MESSAGE);
            if (UNSIGNED.equals(option)) {
                return;
            }
            String signAlg = ASPackager.getSignAlgorithm(option);
            if (signAlg == null) {
                throw new ASException(43000, "Unknown signature algorithm specified: " + option);
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace("Going to sign the message using " + signAlg);
            }
            SignCertInfo signCertInfo = this._xpMessage.getCommunication().getPackagingSignKey();
            Certificate[] certificateChain = signCertInfo.getCertificateChain();
            PrivateKey privateKey = signCertInfo.getPrivateKey();
            MimeBodyPart signedPart = new MimeBodyPart();
            MimeMultipart signedMultiPart = this._smimeSigner.createSignedMimeMessage(this._asMessage.getMimePart(), null, privateKey, certificateChain, signAlg, this._asMessage.getTransferEncoding());
            signedPart.setContent((Multipart)signedMultiPart);
            signedPart.addHeader("Content-Type", signedMultiPart.getContentType());
            this._asMessage.setMimePart(signedPart);
            String usingInfoText = this.getCertificateUtility().toUsingInfoText((X509Certificate)certificateChain[0], signAlg + " and certificate ");
            this._log.debug("message signed: {}", (Object)usingInfoText);
            this.getMessengerLog().log2db(84, this._xpMessage.getDatabaseId(), " " + usingInfoText);
            this._needsTransferEncoding = false;
        }
        catch (OptionNotFoundException option) {
        }
        catch (CertificateIdNotFoundException | GeneralSecurityException e) {
            this._log.error("Cannot get private key for localId '{}': {}", (Object)this._xpMessage.getSenderLocalId(), (Object)e.getMessage());
            this.getMessengerLog().log2db(535, this._xpMessage.getDatabaseId(), e.toString());
            throw new ASException(-1, "Cannot get private key for localId '" + this._xpMessage.getSenderLocalId() + "': " + e.getMessage());
        }
        catch (Exception e) {
            this._log.error("Could not sign the message: {}", (Object)e.getMessage());
            this.getMessengerLog().log2db(535, this._xpMessage.getDatabaseId(), " " + e.getMessage());
            throw new ASException(43000, (Throwable)e);
        }
    }

    private final void compressMessage() throws ASException {
        try {
            String option = this._xpMessage.getCommunication().getPackagingOptionValue(COMPRESS_MESSAGE);
            if ("true".equals(option)) {
                if (this._log.isTraceEnabled()) {
                    this._log.trace("Going to compress the message.");
                }
                MimeBodyPart plainContent = this._asMessage.getMimePart();
                int beforeSize = plainContent.getSize();
                MimeBodyPart compressedContent = this._smimeCompressor.createCompressedMimePart(plainContent, this._asMessage.getTransferEncoding());
                this._asMessage.setMimePart(compressedContent);
                int afterSize = compressedContent.getSize();
                String text = null;
                if (beforeSize > 0 && afterSize > 0) {
                    text = beforeSize + " bytes -> " + afterSize + " bytes";
                    this._log.debug("Message compressed: {}", (Object)text);
                } else {
                    this._log.debug("Message compressed.");
                }
                this.getMessengerLog().log2db(88, this._xpMessage.getDatabaseId(), text);
                this._needsTransferEncoding = false;
            }
        }
        catch (OptionNotFoundException option) {
        }
        catch (Exception e) {
            this._log.fatal("Could not compress the message: {}", (Object)e.getMessage());
            this.getMessengerLog().log2db(539, this._xpMessage.getDatabaseId(), " " + e.getMessage());
            throw new ASException(43000, (Throwable)e);
        }
    }

    private final void encryptMessage() throws ASException {
        try {
            String option = this._xpMessage.getCommunication().getPackagingOptionValue(ENCRYPT_MESSAGE);
            if ("true".equals(option)) {
                if (this._log.isTraceEnabled()) {
                    this._log.trace("Going to encrypt the message.");
                }
                String algorithm = this.getEncryptionAlgorithm();
                X509Certificate receiverCert = this._xpMessage.getCommunication().getPackagingEncryptionCertificate();
                this._asMessage.setMimePart(this._smimeEncrypter.createEncryptedMimePart(this._asMessage.getMimePart(), algorithm, receiverCert, this._asMessage.getTransferEncoding()));
                String usingInfoText = this.getCertificateUtility().toUsingInfoText(receiverCert, algorithm + " and certificate");
                this._log.debug("Message encrypted: {}", (Object)usingInfoText);
                this.getMessengerLog().log2db(86, this._xpMessage.getDatabaseId(), usingInfoText);
                this._needsTransferEncoding = false;
            }
        }
        catch (OptionNotFoundException option) {
        }
        catch (Exception e) {
            this._log.debug("Could not encrypt the message: {}", (Object)e.getMessage());
            this.getMessengerLog().log2db(537, this._xpMessage.getDatabaseId(), " " + e.getMessage());
            throw new ASException(43005, (Throwable)e);
        }
    }

    private String getEncryptionAlgorithm() {
        try {
            Object encryptionAlgo = this._xpMessage.getCommunication().getPackagingOptionValue(EXTENDED_ENCRYPTION_ALGORITHM);
            if (((String)encryptionAlgo).endsWith("/OAEP")) {
                encryptionAlgo = (String)encryptionAlgo + "_SHA1";
            }
            return encryptionAlgo;
        }
        catch (OptionNotFoundException onfe) {
            return OPTION_VALUE_DES_EDE3_CBC;
        }
    }

    private final void calculateMessageDigest() throws ASException {
        if (this._asMessage.isMDNRequested() && this._asMessage.getMDNParameters().isSignedReceiptProtocolRequired()) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("A signed MDN is requested - going to calculate the message digest");
            }
            try {
                StringBuilder suppliedAlgorithmIdentifiers = new StringBuilder();
                String[] micAlgorithms = this._asMessage.getMDNParameters().getSignedReceiptMicAlgValues();
                String micAlgorithm = null;
                String digestAlgorithm = null;
                for (int i = 0; i < micAlgorithms.length; ++i) {
                    suppliedAlgorithmIdentifiers.append(micAlgorithms[i]).append(" ");
                    digestAlgorithm = MDNParameters.getDigestAlgorithm(micAlgorithms[i]);
                    if (digestAlgorithm != null) {
                        micAlgorithm = micAlgorithms[i];
                        break;
                    }
                    if (i != micAlgorithms.length - 1) continue;
                    throw new NoSuchAlgorithmException("Cannot identify algorithm by '" + suppliedAlgorithmIdentifiers.toString() + "'");
                }
                this._log.debug("Calculating '{}' message digest.", micAlgorithm);
                MessageDigestCalculator mdc = this.createMessageDigestCalculator(digestAlgorithm);
                this._asMessage.setMICValue(mdc.getDigestBase64(), micAlgorithm);
                if (this._log.isTraceEnabled()) {
                    this._log.trace("{} message digest calculated.", (Object)micAlgorithm);
                    this._log.trace("base64-digest: {}", (Object)mdc.getDigestBase64());
                    this._log.trace("binary-digest: 0x{}", (Object)new BigInteger(mdc.getDigest()).toString(16));
                }
            }
            catch (SecurityException se) {
                throw new ASException(43006, (Throwable)se);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new ASException(43006, (Throwable)nsae);
            }
        }
    }

    protected Map<String, String> convertInternetHeadersToHashMap(InternetHeaders headers) {
        BufferedOutputStream headersOut = null;
        File headersFile = new File(this._xpMessage.getCurrentContentReferenceFolder(), "headers.txt");
        try {
            this._log.debug("Storing message headers to: {}", (Object)headersFile.getAbsolutePath());
            headersOut = new BufferedOutputStream(Files.newOutputStream(headersFile.toPath(), new OpenOption[0]));
        }
        catch (IOException fnfe) {
            this._log.fatal("Unable to store message headers to: {}", (Object)headersFile.getAbsolutePath());
        }
        HashMap<String, String> result = new HashMap<String, String>();
        String originalFilename = this._xpMessage.getProcessingDirective("OriginalFilename");
        if (StringUtils.isNotBlank((CharSequence)originalFilename)) {
            String encoded = "";
            try {
                encoded = MimeUtility.encodeText((String)originalFilename);
            }
            catch (UnsupportedEncodingException ex) {
                this._log.error(ex.getMessage());
                encoded = originalFilename;
            }
            result.put("X-Original-Filename", encoded);
        }
        Enumeration headersEnum = headers.getAllHeaders();
        while (headersEnum.hasMoreElements()) {
            Header header = (Header)headersEnum.nextElement();
            String[] values = headers.getHeader(header.getName());
            StringBuilder line = new StringBuilder();
            if (values.length == 1) {
                line.append(header.getValue());
            } else {
                for (int i = 0; i < values.length; ++i) {
                    if (i != 0) {
                        line.append(',');
                    }
                    line.append(values[i]);
                }
            }
            if (headersOut != null) {
                try {
                    ((OutputStream)headersOut).write((header.getName() + ": " + line.toString() + "\r\n").getBytes());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            result.put(header.getName(), line.toString());
        }
        if (headersOut != null) {
            try {
                ((OutputStream)headersOut).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    protected InternetHeaders convertHashMapToInternetHeaders(Map<String, String> headers) {
        InternetHeaders result = new InternetHeaders();
        Set<String> keys = headers.keySet();
        for (String headerName : keys) {
            String headerValue = headers.get(headerName);
            result.addHeader(headerName, headerValue.trim());
        }
        return result;
    }

    @Override
    public String getPackagingEncryptionPath() {
        return ENCRYPT_MESSAGE;
    }

    @Override
    public String getPackagingSignPath() {
        return SIGN_MESSAGE;
    }

    @Override
    public XpMessage createAsyncAck(List<ProcessingResult> result, XpMessage xpResponse, boolean signed) throws PackagingException {
        return null;
    }

    @Override
    public XpMessage createErrorResponse(List<ProcessingResult> result, XpMessage xpResponse, boolean signed) throws PackagingException {
        return null;
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put(MD5_SIGNED, "MD5withRSA");
        tempMap.put(SHA1_SIGNED, "SHA1withRSA");
        tempMap.put(SHA_224_SIGNED, "SHA224withRSA");
        tempMap.put(SHA_256_SIGNED, "SHA256withRSA");
        tempMap.put(SHA_384_SIGNED, "SHA384withRSA");
        tempMap.put(SHA_512_SIGNED, "SHA512withRSA");
        tempMap.put(SHA1_PSS_SIGNED, "SHA1withRSAandMGF1");
        tempMap.put(SHA_224_PSS_SIGNED, "SHA224withRSAandMGF1");
        tempMap.put(SHA_256_PSS_SIGNED, "SHA256withRSAandMGF1");
        tempMap.put(SHA_384_PSS_SIGNED, "SHA384withRSAandMGF1");
        tempMap.put(SHA_512_PSS_SIGNED, "SHA512withRSAandMGF1");
        tempMap.put(SHA_256_ECDSA_SIGNED, "SHA256withECDSA");
        tempMap.put(SHA_384_ECDSA_SIGNED, "SHA384withECDSA");
        tempMap.put(SHA_512_ECDSA_SIGNED, "SHA512withECDSA");
        OPTION_TO_SIGN_ALG = Collections.unmodifiableMap(tempMap);
        UIOPTION_SIGN = new UIOption("packagingOption.as.sign.message", SIGN_MESSAGE, "list", "SHA-1 signed,SHA-224 signed,SHA-256 signed,SHA-384 signed,SHA-512 signed,SHA-1/PSS signed,SHA-224/PSS signed,SHA-256/PSS signed,SHA-384/PSS signed,SHA-512/PSS signed,SHA-256/ECDSA signed,SHA-384/ECDSA signed,SHA-512/ECDSA signed,MD5 signed", "hilfe_header_sign", "packagingOption.as.sign.message", "packagingOption.agreement.help.as.sign.message", "packagingOption.profile.help.as.sign.message", UIOption.BOTH_PARTNERS, SHA1_SIGNED, "senderCertificate");
        UIOPTION_REQUEST_MDN = new UIOption("packagingOption.as.request.mdn", REQUEST_MDN, "list", "SHA-1 signed,SHA-224 signed,SHA-256 signed,SHA-384 signed,SHA-512 signed,MD5 signed,unsigned", "hilfe_header_requestmdn", "packagingOption.as.request.mdn", "packagingOption.agreement.help.as.request.mdn", "packagingOption.profile.help.as.request.mdn", UIOption.BOTH_PARTNERS, SHA1_SIGNED);
        UIOPTION_REQUEST_MDN.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        UIOPTION_COMPRESS = new UIOption("packagingOption.as.compress.message", COMPRESS_MESSAGE, "boolean", "true", "hilfe_header_compress", "packagingOption.as.compress.message", "packagingOption.agreement.help.as.compress.message", "packagingOption.profile.help.as.compress.message", UIOption.BOTH_PARTNERS, FALSE);
        UIOPTION_ENCRYPT = new UIOption("packagingOption.as.encrypt.message", ENCRYPT_MESSAGE, "boolean", "true", "hilfe_header_encrypt", "packagingOption.as.encrypt.message", "packagingOption.agreement.help.as.encrypt.message", "packagingOption.profile.help.as.encrypt.message", UIOption.BOTH_PARTNERS, "true", "receiverCertificate");
        UIOPTION_EXTENDED_ENCRYPTION_ALGORITHM = new UIOption("packagingOption.as.extended_encryption_algorithm", EXTENDED_ENCRYPTION_ALGORITHM, "list", "DES_EDE3_CBC,AES128_CBC,AES192_CBC,AES256_CBC,AES128_GCM,AES192_GCM,AES256_GCM,DES_EDE3_CBC/OAEP_SHA1,AES128_CBC/OAEP_SHA1,AES128_CBC/OAEP_SHA256,AES128_CBC/OAEP_SHA512,AES192_CBC/OAEP_SHA1,AES192_CBC/OAEP_SHA256,AES192_CBC/OAEP_SHA512,AES256_CBC/OAEP_SHA1,AES256_CBC/OAEP_SHA256,AES256_CBC/OAEP_SHA512,AES128_GCM/OAEP_SHA256,AES192_GCM/OAEP_SHA256,AES256_GCM/OAEP_SHA256,AES128_GCM/OAEP_SHA512,AES192_GCM/OAEP_SHA512,AES256_GCM/OAEP_SHA512,AES128_GCM/ECDH_SHA224,AES192_GCM/ECDH_SHA224,AES256_GCM/ECDH_SHA224,AES128_GCM/ECDH_SHA256,AES192_GCM/ECDH_SHA256,AES256_GCM/ECDH_SHA256,AES128_GCM/ECDH_SHA512,AES192_GCM/ECDH_SHA512,AES256_GCM/ECDH_SHA512", "hilfe_header_extended_encryption_algorithm", "packagingOption.as.extended_encryption_algorithm", "packagingOption.agreement.help.as.extended_encryption_algorithm", "packagingOption.profile.help.as.extended_encryption_algorithm", UIOption.NONE, OPTION_VALUE_DES_EDE3_CBC);
        UIOPTION_DUPLICATE_ELIMINATION = new UIOption("packagingOption.as.duplicateelimination", DUPLICATE_ELIMINATION, "boolean", "true", "hilfe_header_duplicateelimination", "packagingOption.as.duplicateelimination", "packagingOption.agreement.help.as.duplicateelimination", "packagingOption.profile.help.as.duplicateelimination", UIOption.SENDER, "true");
        UIOPTION_DUPLICATE_ELIMINATION.setVisibility(UIOption.VISIBILITY.INBOUND);
    }
}

