/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.packaging;

import de.pontonconsulting.xmlpipe.jaxb.as4.Body;
import de.pontonconsulting.xmlpipe.jaxb.as4.Envelope;
import de.pontonconsulting.xmlpipe.jaxb.as4.Header;
import de.pontonconsulting.xmlpipe.jaxb.as4.MessageInfo;
import de.pontonconsulting.xmlpipe.jaxb.as4.MessagePartNRInformation;
import de.pontonconsulting.xmlpipe.jaxb.as4.Messaging;
import de.pontonconsulting.xmlpipe.jaxb.as4.NonRepudiationInformation;
import de.pontonconsulting.xmlpipe.jaxb.as4.ObjectFactory;
import de.pontonconsulting.xmlpipe.jaxb.as4.Receipt;
import de.pontonconsulting.xmlpipe.jaxb.as4.Reference;
import de.pontonconsulting.xmlpipe.jaxb.as4.SignalMessage;
import de.pontonconsulting.xmlpipe.jaxb.as4.UserMessage;
import de.pontonconsulting.xmlpipe.listener.AS4ProcessorHelper;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.packaging.JAXBToSOAPConverter;
import de.pontonconsulting.xmlpipe.messenger.packaging.PackagingException;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.util.Date;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AS4ReceiptGenerator {
    private final IdGenerator _idGenerator;
    private final ReferenceDateTask referenceDateTask;
    private final AS4ProcessorHelper _as4ProcessorHelper;
    private final ObjectFactory _as4ObjectFactory;
    private final JAXBContext _as4JAXBContext;
    private final JAXBToSOAPConverter _jaxbToSOAPConverter;

    public AS4ReceiptGenerator(IdGenerator idGenerator, ReferenceDateTask referenceDateTask, AS4ProcessorHelper as4ProcessorHelper, ObjectFactory as4ObjectFactory, JAXBContext as4JAXBContext, JAXBToSOAPConverter jaxbToSOAPConverter) {
        this._idGenerator = idGenerator;
        this.referenceDateTask = referenceDateTask;
        this._as4ProcessorHelper = as4ProcessorHelper;
        this._as4ObjectFactory = as4ObjectFactory;
        this._as4JAXBContext = as4JAXBContext;
        this._jaxbToSOAPConverter = jaxbToSOAPConverter;
    }

    public SOAPMessage generateReceipt(Source refMessageEnvelope) throws JAXBException, PackagingException, XPathExpressionException {
        NodeList signatureDsigReferences = this._as4ProcessorHelper.evalXPathToNodeList(refMessageEnvelope, AS4ProcessorHelper.SIGNATURE_DSIG_REFERENCE);
        Receipt receipt = null;
        String refMessageId = this._as4ProcessorHelper.evalXPath(refMessageEnvelope, AS4ProcessorHelper.USER_MESSAGE_MSGID);
        String receiptMessageId = this._idGenerator.generateMessageId();
        Date timestamp = this.referenceDateTask.getReferenceDate();
        if (signatureDsigReferences != null && signatureDsigReferences.getLength() > 0) {
            receipt = this.createNRReceipt(signatureDsigReferences);
        } else {
            Node userMessageNode = this._as4ProcessorHelper.evalXPathToNode(refMessageEnvelope, AS4ProcessorHelper.USER_MESSAGE);
            receipt = this.createUserMessageReceipt(userMessageNode);
        }
        Envelope receiptEnvelope = this.createReceiptEnvelope(receipt, refMessageId, receiptMessageId, timestamp);
        SOAPMessage soapMessage = this._jaxbToSOAPConverter.convertEnvelope(receiptEnvelope, false);
        return soapMessage;
    }

    private Envelope createReceiptEnvelope(Receipt receipt, String refMessageId, String receiptMessageId, Date timestamp) throws PackagingException {
        MessageInfo messageInfo = this._as4ObjectFactory.createMessageInfo();
        messageInfo.setMessageId(receiptMessageId);
        messageInfo.setTimestamp(timestamp);
        messageInfo.setRefToMessageId(refMessageId);
        SignalMessage signalMessage = this._as4ObjectFactory.createSignalMessage();
        signalMessage.setMessageInfo(messageInfo);
        signalMessage.setReceipt(receipt);
        Messaging messaging = this._as4ObjectFactory.createMessaging();
        messaging.setMustUnderstand(true);
        messaging.setId(this._idGenerator.getSoapId());
        messaging.getAny().add(signalMessage);
        Header header = this._as4ObjectFactory.createHeader();
        header.getAny().add(messaging);
        Body body = this._as4ObjectFactory.createBody();
        Envelope envelope = this._as4ObjectFactory.createEnvelope();
        envelope.setHeader(header);
        envelope.setBody(body);
        return envelope;
    }

    private Receipt createNRReceipt(NodeList signatureDsigReferences) throws JAXBException {
        NonRepudiationInformation nonRepudiationInformation = this._as4ObjectFactory.createNonRepudiationInformation();
        for (int i = 0; i < signatureDsigReferences.getLength(); ++i) {
            Node referenceNode = signatureDsigReferences.item(i);
            Reference reference = (Reference)this.getUnmarshaller().unmarshal(referenceNode);
            MessagePartNRInformation messagePartNRInformation = this._as4ObjectFactory.createMessagePartNRInformation();
            messagePartNRInformation.setReference(reference);
            nonRepudiationInformation.getMessagePartNRInformation().add(messagePartNRInformation);
        }
        Receipt receipt = this._as4ObjectFactory.createReceipt();
        receipt.getAny().add(nonRepudiationInformation);
        return receipt;
    }

    private Receipt createUserMessageReceipt(Node userMessageNode) throws JAXBException {
        UserMessage userMessage = (UserMessage)this.getUnmarshaller().unmarshal(userMessageNode);
        Receipt receipt = this._as4ObjectFactory.createReceipt();
        receipt.getAny().add(userMessage);
        return receipt;
    }

    private Unmarshaller getUnmarshaller() throws JAXBException {
        return this._as4JAXBContext.createUnmarshaller();
    }
}

