/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.packaging;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPOutputStream;
import javax.activation.DataSource;

public class AS4GZIPDataSource
implements DataSource {
    public static final String CONTENT_TYPE = "application/gzip";
    public static final String NAME_SUFFIX = ".gz";
    private final DataSource _dataSource;
    private final File _compressedData;

    public AS4GZIPDataSource(DataSource dataSource, File source) throws FileNotFoundException, IOException {
        this._dataSource = dataSource;
        this._compressedData = new File(source.getParentFile(), source.getName() + NAME_SUFFIX);
        try (GZIPOutputStream out = new GZIPOutputStream(new BufferedOutputStream(Files.newOutputStream(this._compressedData.toPath(), new OpenOption[0])));
             BufferedInputStream in = new BufferedInputStream(dataSource.getInputStream());){
            ((InputStream)in).transferTo(out);
        }
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(Files.newInputStream(this._compressedData.toPath(), new OpenOption[0]));
    }

    public String getName() {
        return this._dataSource.getName() + NAME_SUFFIX;
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    public long getCompressedSize() {
        return this._compressedData.length();
    }

    protected void finalize() throws Throwable {
        this._compressedData.delete();
        super.finalize();
    }
}

