/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.packaging;

import de.pontonconsulting.xmlpipe.adapter.as4certificateupdate.AS4CertUpdateExceptionTuple;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AS4CertificateUpdateUtility {
    private static final Logger LOGGER = LogManager.getLogger((String)("Messenger." + String.valueOf(AS4CertificateUpdateUtility.class)));
    public static final String AS4_AGREEMENT_UPDATE_NS = "http://docs.oasis-open.org/ebcore/ns/AgreementUpdate/v1.0";
    public static final String AS4_CERT_UPDATE_NS = "http://docs.oasis-open.org/ebcore/ns/CertificateUpdate/v1.0";
    public static final String AS4_AGREEMENT_UPDATE = "AgreementUpdate";
    public static final String AS4_AGREEMENT_UPDATE_REQUEST = "AgreementUpdateRequest";
    public static final String AS4_AGREEMENT_UPDATE_RESPONSE = "AgreementUpdateResponse";
    public static final String AS4_AGREEMENT_UPDATE_EXCEPTION = "AgreementUpdateException";
    public static final String AS4_UPDATE_CERT_ACTION = "UpdateCertificate";
    public static final String AS4_CONFIRM_CERT_ACTION = "ConfirmCertificateUpdate";
    public static final String AS4_REJECT_CERT_ACTION = "RejectCertificateUpdate";
    public static final String AS4_CERT_UPDATE_ROLE_FROM = "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/initiator";
    public static final String AS4_CERT_UPDATE_ROLE_TO = "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/responder";
    public static final String AS4_CERT_UPDATE_SCHEMA_LOCATION = "ebcore-cu-v1.0.xsd";
    private static final DateTimeFormatter formatter = DateTimeFormatter.ISO_ZONED_DATE_TIME;
    private static final String SEVEN_DAYS_IN_SECONDS = "604800";
    private final Transformer transformer;
    private final IMessengerProperties messengerProperties;
    private int activateByIntervalInSeconds;
    private final DocumentBuilderFactory documentBuilderFactory;
    private final Profiles profiles;

    public AS4CertificateUpdateUtility(IMessengerProperties messengerProperties, TransformerFactory transformerFactory, Profiles profiles) throws ParserConfigurationException, TransformerConfigurationException {
        this.messengerProperties = messengerProperties;
        this.profiles = profiles;
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(true);
        this.documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        this.documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        this.documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        this.transformer = transformerFactory.newTransformer();
    }

    @PostConstruct
    void init() {
        String activateByString = this.messengerProperties.getProperty("ponton.messenger.cert_update_activate_by_in_seconds", SEVEN_DAYS_IN_SECONDS);
        this.activateByIntervalInSeconds = 86400;
        try {
            this.activateByIntervalInSeconds = Integer.parseInt(activateByString);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("invalid value {} for {}, using default {}", (Object)activateByString, (Object)"ponton.messenger.cert_update_activate_by_in_seconds", (Object)this.activateByIntervalInSeconds);
        }
    }

    public void setMessageTypeToCertificateUpdateRequest(XpMessage xpMessage) {
        xpMessage.setStoreMessageInQueue(true);
        xpMessage.setSchemaSet(AS4_AGREEMENT_UPDATE);
        xpMessage.setMessageVersion("2.1");
        xpMessage.setMessageType("CertUpdateRequest");
        xpMessage.setSchemaLocation(AS4_CERT_UPDATE_SCHEMA_LOCATION);
        xpMessage.setSchemaNamespace(AS4_CERT_UPDATE_NS);
        xpMessage.setAdapterId("AS4CertificateUpdateAdapter");
        xpMessage.setPayloadNamespaceUri(AS4_AGREEMENT_UPDATE_NS);
        xpMessage.setPayloadRootElement(AS4_AGREEMENT_UPDATE_REQUEST);
    }

    public void setMessageTypeToCertificateUpdateResponse(XpMessage xpMessage) {
        xpMessage.setStoreMessageInQueue(true);
        xpMessage.setSchemaSet(AS4_AGREEMENT_UPDATE);
        xpMessage.setMessageVersion("2.1");
        xpMessage.setMessageType("CertUpdateResponse");
        xpMessage.setSchemaLocation(AS4_CERT_UPDATE_SCHEMA_LOCATION);
        xpMessage.setSchemaNamespace(AS4_CERT_UPDATE_NS);
        xpMessage.setAdapterId("AS4CertificateUpdateAdapter");
        xpMessage.setPayloadNamespaceUri(AS4_AGREEMENT_UPDATE_NS);
        xpMessage.setPayloadRootElement(AS4_AGREEMENT_UPDATE_RESPONSE);
    }

    public void setMessageTypeToCertificateUpdateException(XpMessage xpMessage) {
        xpMessage.setStoreMessageInQueue(true);
        xpMessage.setSchemaSet(AS4_AGREEMENT_UPDATE);
        xpMessage.setMessageVersion("2.1");
        xpMessage.setMessageType("CertUpdateException");
        xpMessage.setSchemaLocation(AS4_CERT_UPDATE_SCHEMA_LOCATION);
        xpMessage.setSchemaNamespace(AS4_CERT_UPDATE_NS);
        xpMessage.setAdapterId("AS4CertificateUpdateAdapter");
        xpMessage.setPayloadNamespaceUri(AS4_AGREEMENT_UPDATE_NS);
        xpMessage.setPayloadRootElement(AS4_AGREEMENT_UPDATE_EXCEPTION);
    }

    public File createCertificateUpdateResponse(String idString, String referenceIdString, String currentAgreementRef, Optional<String> currentAgreementRefType, String updatedAgreementRef, File currentContentReferenceFolder) throws TransformerException, ParserConfigurationException {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element agreementUpdateResponse = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:AgreementUpdateResponse");
        agreementUpdateResponse.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://docs.oasis-open.org/ebcore/ns/AgreementUpdate/v1.0 http://docs.oasis-open.org/ebcore/ebcore-au/v1.0/schema/ebcore-au-v1.0.xsd");
        Element id = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:ID");
        id.appendChild(document.createTextNode(idString));
        agreementUpdateResponse.appendChild(id);
        Element referenceId = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:ReferenceID");
        referenceId.appendChild(document.createTextNode(referenceIdString));
        agreementUpdateResponse.appendChild(referenceId);
        Element createdAt = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:CreatedAt");
        String createAtTimestamp = OffsetDateTime.now(ZoneOffset.UTC).format(formatter);
        createdAt.appendChild(document.createTextNode(createAtTimestamp));
        agreementUpdateResponse.appendChild(createdAt);
        Element currentAgreementIdentifier = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:CurrentAgreementIdentifier");
        currentAgreementRefType.ifPresent(currentAgreementRefTypeString -> currentAgreementIdentifier.setAttribute("type", (String)currentAgreementRefTypeString));
        currentAgreementIdentifier.appendChild(document.createTextNode(currentAgreementRef));
        agreementUpdateResponse.appendChild(currentAgreementIdentifier);
        Element updatedAgreementIdentifier = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:UpdatedAgreementIdentifier");
        updatedAgreementIdentifier.appendChild(document.createTextNode(updatedAgreementRef));
        currentAgreementRefType.ifPresent(currentAgreementRefTypeString -> updatedAgreementIdentifier.setAttribute("type", (String)currentAgreementRefTypeString));
        agreementUpdateResponse.appendChild(updatedAgreementIdentifier);
        document.appendChild(agreementUpdateResponse);
        File file = new File(currentContentReferenceFolder, "as4certupdateresponse.xml");
        DOMSource domSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(file);
        this.transformer.transform(domSource, streamResult);
        return file;
    }

    public File createCertificateUpdateRequest(Communication communication, String certId, String messageId, File currentContentReferenceFolder) throws GeneralSecurityException, TransformerException, ProfileException, ParserConfigurationException {
        CppPartner cppPartner = this.profiles.getProfileForLocalId(communication.getSender().getId(), false);
        String currentCertificateId = cppPartner.getDefaultCertRefId();
        X509Certificate currentCertificate = cppPartner.getX509Certificate(currentCertificateId);
        X509Certificate certificate = cppPartner.getX509Certificate(certId);
        Agreement agreement = communication.getAgreement();
        String updatedAgreementRef = agreement.getAS4UpdatedAgreementRef();
        String currentAgreementRef = "null";
        String currentAgreementRefType = null;
        try {
            currentAgreementRef = communication.getPackagingOptionValue("/AgreementRef");
            currentAgreementRefType = communication.getPackagingOptionValue("/AgreementRef/Type");
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element agreementUpdateRequest = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:AgreementUpdateRequest");
        agreementUpdateRequest.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://docs.oasis-open.org/ebcore/ebcore-au/v1.0/schema/ebcore-cu-v1.0.xsd");
        Element id = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:ID");
        id.appendChild(document.createTextNode(messageId));
        agreementUpdateRequest.appendChild(id);
        Element createdAt = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:CreatedAt");
        String createAtTimestamp = OffsetDateTime.now(ZoneOffset.UTC).format(formatter);
        createdAt.appendChild(document.createTextNode(createAtTimestamp));
        agreementUpdateRequest.appendChild(createdAt);
        Element respondBy = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:RespondBy");
        String respondByTimestamp = OffsetDateTime.now(ZoneOffset.UTC).plusSeconds(this.activateByIntervalInSeconds).format(formatter);
        respondBy.appendChild(document.createTextNode(respondByTimestamp));
        agreementUpdateRequest.appendChild(respondBy);
        Element activateBy = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:ActivateBy");
        String activateByTimestamp = OffsetDateTime.now(ZoneOffset.UTC).plusSeconds(this.activateByIntervalInSeconds).format(formatter);
        activateBy.appendChild(document.createTextNode(activateByTimestamp));
        agreementUpdateRequest.appendChild(activateBy);
        agreement.setAS4CertUpdateActivateBy(activateByTimestamp);
        Element currentAgreementIdentifier = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:CurrentAgreementIdentifier");
        if (currentAgreementRefType != null) {
            currentAgreementIdentifier.setAttribute("type", currentAgreementRefType);
        }
        currentAgreementIdentifier.appendChild(document.createTextNode(currentAgreementRef));
        agreementUpdateRequest.appendChild(currentAgreementIdentifier);
        Element updatedAgreementIdentifier = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:UpdatedAgreementIdentifier");
        updatedAgreementIdentifier.appendChild(document.createTextNode(updatedAgreementRef));
        if (currentAgreementRefType != null) {
            updatedAgreementIdentifier.setAttribute("type", currentAgreementRefType);
        }
        agreementUpdateRequest.appendChild(updatedAgreementIdentifier);
        Element certUpdate = document.createElementNS(AS4_CERT_UPDATE_NS, "cu:CertificateUpdateRequest");
        certUpdate.setAttribute("id", "certUpdate");
        Element currentCertificateIdentifier = document.createElementNS(AS4_CERT_UPDATE_NS, "cu:CurrentCertificateIdentifier");
        Element currentX509Digest = document.createElementNS("http://www.w3.org/2009/xmldsig11#", "dsig11:X509Digest");
        currentX509Digest.setAttribute("Algorithm", "http://www.w3.org/2001/04/xmlenc#sha256");
        currentX509Digest.appendChild(document.createTextNode(this.getDigestOfCertificateBase64Encoded(currentCertificate)));
        currentCertificateIdentifier.appendChild(currentX509Digest);
        Element keyInfo = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
        Element keyName = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyName");
        keyName.appendChild(document.createTextNode(certificate.getIssuerX500Principal().getName()));
        keyInfo.appendChild(keyName);
        Element keyValue = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyValue");
        if (certificate.getPublicKey() instanceof RSAPublicKey) {
            Element keyValueRSA = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:RSAKeyValue");
            Element modulus = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Modulus");
            byte[] modulusBytes = ((RSAPublicKey)certificate.getPublicKey()).getModulus().toByteArray();
            String modulusBase64 = Base64.getEncoder().encodeToString(modulusBytes);
            modulus.appendChild(document.createTextNode(modulusBase64));
            keyValueRSA.appendChild(modulus);
            Element exponent = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Exponent");
            byte[] exponentBytes = ((RSAPublicKey)certificate.getPublicKey()).getPublicExponent().toByteArray();
            String exponentBase64 = Base64.getEncoder().encodeToString(exponentBytes);
            exponent.appendChild(document.createTextNode(exponentBase64));
            keyValueRSA.appendChild(exponent);
            keyValue.appendChild(keyValueRSA);
            keyInfo.appendChild(keyValue);
        }
        Element x509Data = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509Data");
        Element x509Digest = document.createElementNS("http://www.w3.org/2009/xmldsig11#", "dsig11:X509Digest");
        x509Digest.setAttribute("Algorithm", "http://www.w3.org/2001/04/xmlenc#sha256");
        x509Digest.appendChild(document.createTextNode(this.getDigestOfCertificateBase64Encoded(certificate)));
        Element x509SubjectName = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509SubjectName");
        x509SubjectName.appendChild(document.createTextNode(certificate.getSubjectX500Principal().getName()));
        Element x509Cert = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:X509Certificate");
        x509Cert.appendChild(document.createTextNode(Base64.getEncoder().encodeToString(certificate.getEncoded())));
        x509Data.appendChild(x509Digest);
        x509Data.appendChild(x509SubjectName);
        x509Data.appendChild(x509Cert);
        keyInfo.appendChild(x509Data);
        certUpdate.appendChild(currentCertificateIdentifier);
        certUpdate.appendChild(keyInfo);
        agreementUpdateRequest.appendChild(certUpdate);
        document.appendChild(agreementUpdateRequest);
        File certUpdateRequestPayload = new File(currentContentReferenceFolder, "as4certupdaterequest.xml");
        DOMSource domSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(certUpdateRequestPayload);
        this.transformer.transform(domSource, streamResult);
        return certUpdateRequestPayload;
    }

    public Optional<String> receiveTextContentFromBackendMessage(Document as4CertUpdateMessageDoc, String nameSpace, String localName) {
        NodeList referenceIdList = as4CertUpdateMessageDoc.getElementsByTagNameNS(nameSpace, localName);
        if (referenceIdList.getLength() > 0 && referenceIdList.item(0).getTextContent() != null) {
            return Optional.of(referenceIdList.item(0).getTextContent());
        }
        return Optional.empty();
    }

    public Optional<String> receiveAttributeFromBackendMessage(Document as4CertUpdateMessageDoc, String nameSpace, String localName, String attributeName) {
        NodeList referenceIdList = as4CertUpdateMessageDoc.getElementsByTagNameNS(nameSpace, localName);
        if (referenceIdList.getLength() > 0 && referenceIdList.item(0).getAttributes().getNamedItem(attributeName) != null) {
            return Optional.of(referenceIdList.item(0).getAttributes().getNamedItem(attributeName).getTextContent());
        }
        return Optional.empty();
    }

    public Document parseDocumentFromBackendMessage(InputStream messageDocumentInputStream) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(new InputSource(messageDocumentInputStream));
    }

    public String getDigestOfCertificateBase64Encoded(X509Certificate certificate) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return Base64.getEncoder().encodeToString(digest.digest(certificate.getEncoded()));
        }
        catch (GeneralSecurityException e) {
            LOGGER.warn("could not create hash of certificate: {}", (Object)e.toString());
            return "";
        }
    }

    public File createCertificateUpdateException(String messageId, String referenceIdString, String currentAgreementRef, Optional<String> currentAgreementRefType, String updatedAgreementRef, File currentContentReferenceFolder, AS4CertUpdateExceptionTuple as4ExceptionTuple) throws TransformerException, ParserConfigurationException {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element agreementUpdateException = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:AgreementUpdateException");
        agreementUpdateException.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://docs.oasis-open.org/ebcore/ns/AgreementUpdate/v1.0 http://docs.oasis-open.org/ebcore/ebcore-au/v1.0/schema/ebcore-au-v1.0.xsd");
        Element id = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:ID");
        id.appendChild(document.createTextNode(messageId));
        agreementUpdateException.appendChild(id);
        Element referenceId = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:ReferenceID");
        referenceId.appendChild(document.createTextNode(referenceIdString));
        agreementUpdateException.appendChild(referenceId);
        Element createdAt = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:CreatedAt");
        String createAtTimestamp = OffsetDateTime.now(ZoneOffset.UTC).format(formatter);
        createdAt.appendChild(document.createTextNode(createAtTimestamp));
        agreementUpdateException.appendChild(createdAt);
        Element currentAgreementIdentifier = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:CurrentAgreementIdentifier");
        currentAgreementRefType.ifPresent(currentAgreementRefTypeString -> currentAgreementIdentifier.setAttribute("type", (String)currentAgreementRefTypeString));
        currentAgreementIdentifier.appendChild(document.createTextNode(currentAgreementRef));
        agreementUpdateException.appendChild(currentAgreementIdentifier);
        Element updatedAgreementIdentifier = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:UpdatedAgreementIdentifier");
        updatedAgreementIdentifier.appendChild(document.createTextNode(updatedAgreementRef));
        currentAgreementRefType.ifPresent(currentAgreementRefTypeString -> updatedAgreementIdentifier.setAttribute("type", (String)currentAgreementRefTypeString));
        agreementUpdateException.appendChild(updatedAgreementIdentifier);
        Element error = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:Error");
        error.setAttribute("errorCode", as4ExceptionTuple.getAs4CertUpdateException().getErrorCode());
        error.setAttribute("severity", "Failure");
        error.setAttribute("shortDescription", as4ExceptionTuple.getAs4CertUpdateException().getShortDescription());
        error.setAttribute("refToUpdateInError", referenceIdString);
        Element errorDescription = document.createElementNS(AS4_AGREEMENT_UPDATE_NS, "au:Description");
        errorDescription.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", "en");
        errorDescription.appendChild(document.createTextNode(as4ExceptionTuple.getDescription()));
        error.appendChild(errorDescription);
        agreementUpdateException.appendChild(error);
        document.appendChild(agreementUpdateException);
        File file = new File(currentContentReferenceFolder, "as4certupdateexception.xml");
        DOMSource domSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(file);
        this.transformer.transform(domSource, streamResult);
        return file;
    }

    public String getCurrentAgreementRefType(Communication communication) {
        try {
            return communication.getPackagingOptionValue("/AgreementRef/Type");
        }
        catch (OptionNotFoundException e) {
            return null;
        }
    }

    public String getCurrentAgreementRef(Communication communication) {
        try {
            return communication.getPackagingOptionValue("/AgreementRef");
        }
        catch (OptionNotFoundException e) {
            return "null";
        }
    }

    public boolean isCertificateUpdateEnabledForCommunication(Communication communication) {
        try {
            return Boolean.parseBoolean(communication.getPackagingOptionValue("/CertificateUpdate"));
        }
        catch (OptionNotFoundException e) {
            return false;
        }
    }
}

