/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.packaging;

import de.pontonconsulting.common.security.IPasswordCrypt;
import de.pontonconsulting.xmlpipe.as.AS1ObjectFactory;
import de.pontonconsulting.xmlpipe.as.AS2ObjectFactory;
import de.pontonconsulting.xmlpipe.as.AS3ObjectFactory;
import de.pontonconsulting.xmlpipe.as.ASException;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.listener.ListenerManager;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.ReceiveFromListener;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MDNDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.packaging.AS4UIOptions;
import de.pontonconsulting.xmlpipe.messenger.packaging.ASPackager;
import de.pontonconsulting.xmlpipe.messenger.packaging.EbXml20UIOptions;
import de.pontonconsulting.xmlpipe.messenger.packaging.PackagingException;
import de.pontonconsulting.xmlpipe.messenger.transport.ProviderResponse;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.MessageDigestCalculator;
import de.pontonconsulting.xmlpipe.security.SecurityException;
import de.pontonconsulting.xmlpipe.security.smime.SMIMECompressor;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEEncrypter;
import de.pontonconsulting.xmlpipe.security.smime.SMIMESigner;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import de.pontonconsulting.xmlpipe.util.IOUtil;
import jakarta.mail.internet.InternetHeaders;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AS3
extends ASPackager {
    private static final String BINARY = "binary";
    public static final String PACKAGERNAME = "AS3";
    public static final String REPLY_URL = "/ReplyURL";
    public static final String DEFAULT_URL = "ftp://";
    private static final UIOption[] OPTIONS;
    public static final Logger _log;

    public AS3(MessengerConfig messengerConfig, ListenerManager listenerManager, MessengerLog messengerLog, MDNDataDAO mdnDataDAO, IPasswordCrypt passwordCrypt, KeystoreBean keystore, Profiles profiles, Agreements agreements, IdGenerator idGenerator, MessageDAO messageDAO, ReferenceDateTask referenceDate, IFolders folders, ReceiveFromListener receiveFromListener, SchemataConfig schemataConfig, IMessengerProperties messengerProperties, CertificateUtility certificateUtility, AS1ObjectFactory as1ObjectFactory, AS2ObjectFactory as2ObjectFactory, AS3ObjectFactory as3ObjectFactory, EbXml20UIOptions ebXml20UIOptions, AS4UIOptions as4UIOptions, SMIMECompressor smimeCompressor, SMIMEEncrypter smimeEncrypter, SMIMESigner smimeSigner, MessageWorkDataDAO messageWorkDataDAO) {
        super(messengerConfig, listenerManager, messengerLog, mdnDataDAO, passwordCrypt, keystore, profiles, agreements, idGenerator, messageDAO, referenceDate, folders, receiveFromListener, schemataConfig, messengerProperties, certificateUtility, as1ObjectFactory, as2ObjectFactory, as3ObjectFactory, ebXml20UIOptions, as4UIOptions, smimeCompressor, smimeEncrypter, smimeSigner, messageWorkDataDAO);
        this.setLogger(_log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storePrequeueingFormat(XpMessage message, File messageFile, File messageHeaderFile) throws PackagingException {
        this._xpMessage = message;
        this.checkMessageType();
        this.checkTransportValidity();
        try {
            this.createAS3Message();
            if (_log.isTraceEnabled()) {
                _log.trace("AS3 Message created.");
            }
            InternetHeaders headers = this._asMessage.getInternetHeaders();
            Optional.ofNullable(message.getProcessingDirective("X-CopyOf")).ifPresent(value -> headers.setHeader("X-CopyOf", value));
            Optional.ofNullable(message.getProcessingDirective("X-OriginalReceiver")).ifPresent(value -> headers.setHeader("X-OriginalReceiver", value));
            if (this._asMessage.getMimePart().getHeader("Content-Disposition") != null && this._asMessage.getMimePart().getHeader("Content-Disposition").length > 0) {
                headers.setHeader("Content-Disposition", this._asMessage.getMimePart().getHeader("Content-Disposition")[0]);
            }
            headers.setHeader("Content-Transfer-Encoding", BINARY);
            try (BufferedOutputStream messageOut = new BufferedOutputStream(Files.newOutputStream(messageFile.toPath(), new OpenOption[0]));
                 InputStream in = this._asMessage.getMimePart().getInputStream();){
                if (_log.isTraceEnabled()) {
                    _log.trace("Storing message.");
                }
                byte[] buffer = null;
                buffer = message.getCurrentContentReference().length() >= 0x100000L ? new byte[0x100000] : new byte[65536];
                int length = -1;
                while ((length = in.read(buffer)) != -1) {
                    ((OutputStream)messageOut).write(buffer, 0, length);
                }
            }
            headers.addHeader("Content-Length", "" + messageFile.length());
            Map<String, String> headerMap = this.convertInternetHeadersToHashMap(headers);
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(new BufferedOutputStream(Files.newOutputStream(messageHeaderFile.toPath(), new OpenOption[0])));
                oos.writeObject(headerMap);
            }
            catch (Throwable throwable) {
                IOUtil.closeStreamQuietly(oos);
                throw throwable;
            }
            IOUtil.closeStreamQuietly(oos);
            if (_log.isTraceEnabled()) {
                _log.trace("Message successfully stored.");
            }
        }
        catch (ASException ase) {
            throw new PackagingException(24002, ase.getMessage(), ase);
        }
        catch (DbException dbe) {
            throw new PackagingException(24002, dbe.getMessage(), dbe);
        }
        catch (Exception e) {
            throw new PackagingException(24002, (Throwable)e);
        }
        finally {
            if (this._asMessage != null) {
                this._asMessage.closeAllAttachmentDataSources();
            }
        }
    }

    private void createAS3Message() throws ASException, DbException {
        this._asMessage = this.getAs3ObjectFactory().createAS3Message(this._xpMessage);
        try {
            this.prepareMessage(this._xpMessage.getCommunication().getPackagingOptionValue(REPLY_URL));
        }
        catch (OptionNotFoundException e) {
            _log.warn("could not get option '/ReplyURL': {}", (Object)e.getMessage());
            this.prepareMessage(DEFAULT_URL);
        }
    }

    @Override
    protected MessageDigestCalculator createMessageDigestCalculator(String digestAlgorithm) throws SecurityException {
        return new MessageDigestCalculator(this._asMessage.getMimePart(), this._includeHeaderInDigestCalculation, digestAlgorithm, false);
    }

    @Override
    public UIOption[] getUIOptions() {
        return OPTIONS;
    }

    @Override
    protected boolean preHandleTransmissionResponse(long messageId, ProviderResponse response) {
        return true;
    }

    private void checkTransportValidity() throws PackagingException {
        String url = this._xpMessage.getCommunication().getTransportURL().toLowerCase();
        if (!url.startsWith("ftp:") && !url.startsWith("ftps:")) {
            throw new PackagingException(24002, "AS3 packager only supports http(s) transport.");
        }
    }

    private void checkMessageType() throws PackagingException {
        if ("PING".equals(this._xpMessage.getMessageType()) && "ponton".equals(this._xpMessage.getSchemaSet()) && "2.1".equals(this._xpMessage.getMessageVersion())) {
            throw new PackagingException(24001, "AS3 packager doesn't support pings");
        }
    }

    static {
        _log = LogManager.getLogger((String)"Messenger.AS3Packager");
        UIOption replyUrl = new UIOption("packagingOption.as3.replyurl", REPLY_URL, "string", DEFAULT_URL, "hilfe_header_replyurl", "packagingOption.as3.replyurl", "packagingOption.agreement.help.as3.replyurl", "packagingOption.profile.help.as3.replyurl", UIOption.BOTH_PARTNERS);
        replyUrl.setVisibility(UIOption.VISIBILITY.OUTBOUND);
        OPTIONS = new UIOption[]{UIOPTION_REQUEST_MDN, replyUrl, UIOPTION_SIGN, UIOPTION_COMPRESS, UIOPTION_ENCRYPT, UIOPTION_EXTENDED_ENCRYPTION_ALGORITHM, UIOPTION_DUPLICATE_ELIMINATION};
    }
}

