/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.validate;

import de.pontonconsulting.xmlpipe.messenger.filter.validate.ValidationResult;
import java.util.ArrayList;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidationErrorHandler
extends DefaultHandler {
    private static final int MAX_ERROR_COUNT = 10;
    ArrayList<ValidationResult> _result = new ArrayList();
    private int _defaultMaxErrorCount = 10;
    private int _errorCount = 0;

    public ValidationResult[] getResult() {
        return this._result.toArray(new ValidationResult[this._result.size()]);
    }

    @Override
    public void warning(SAXParseException ex) {
        this.add(0, ex);
    }

    @Override
    public void error(SAXParseException ex) {
        this.add(1, ex);
    }

    @Override
    public void fatalError(SAXParseException ex) {
        this.add(2, ex);
    }

    public int getErrorCount() {
        return this._errorCount;
    }

    public int getDefaultMaxErrorCount() {
        return this._defaultMaxErrorCount;
    }

    public void setDefaultMaxErrorCount(int defaultMaxErrorCount) {
        this._defaultMaxErrorCount = defaultMaxErrorCount;
    }

    public void reset() {
        this._result.clear();
        this._errorCount = 0;
    }

    private void add(int validationResult, SAXParseException ex) {
        if (this._errorCount < this._defaultMaxErrorCount) {
            this._result.add(new ValidationResult(validationResult, ex.getLineNumber(), ex.getColumnNumber(), this.escapeChars(ex.getMessage())));
        }
        ++this._errorCount;
    }

    private String escapeChars(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
    }
}

