/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.sign;

import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.ISigner;
import de.pontonconsulting.xmlpipe.messenger.filter.sign.Signer;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.CryptoUtil;

public class SHA1Signer
extends Signer
implements ISigner {
    public static final String OPTION_VALUE_SHA1 = "SHA1withRSA";
    public static final String PROCESSING_VALUE_HASH_ALGORITHM_SHA1 = "sha1";

    public SHA1Signer(CertificateUtility certificateUtility, MessengerLog messengerLog) throws BaseFilterException {
        super("SHA1Signer", certificateUtility, messengerLog);
        this.setSignatureAlgorithm(OPTION_VALUE_SHA1, PROCESSING_VALUE_HASH_ALGORITHM_SHA1, CryptoUtil.SHA1_WITH_RSA);
    }

    @Override
    public String getOptionValue() {
        return OPTION_VALUE_SHA1;
    }

    @Override
    public String getProcessingValueHashAlgorithm() {
        return PROCESSING_VALUE_HASH_ALGORITHM_SHA1;
    }
}

