/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.eda;

import de.pontonconsulting.xmlpipe.LocalizedException;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.IFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.eda.AbstractXMLSecFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.eda.XmlCryptException;
import de.pontonconsulting.xmlpipe.messenger.filter.eda.XmlSignatureException;
import de.pontonconsulting.xmlpipe.messenger.util.XmlDecryptionResult;
import de.pontonconsulting.xmlpipe.messenger.util.XmlEncryptionUtil;
import de.pontonconsulting.xmlpipe.messenger.util.XmlSignatureUtil;
import de.pontonconsulting.xmlpipe.messenger.util.XmlSignatureValidationResult;
import de.pontonconsulting.xmlpipe.messenger.util.XmlUtil;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import de.pontonconsulting.xmlpipe.uiconfig.UIConfig;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Document;

public class XMLSecInboundFilter
extends AbstractXMLSecFilter {
    private final XmlSignatureUtil xmlSignatureUtil;
    private final CertificateUtility certificateUtility;
    private final XmlEncryptionUtil xmlEncryptionUtil;
    private final Profiles profiles;

    public XMLSecInboundFilter(XmlSignatureUtil xmlSignatureUtil, CertificateUtility certificateUtility, XmlEncryptionUtil xmlEncryptionUtil, Profiles profiles, MessengerLog messengerLog, UIConfig uiConfig, ApplicationContext applicationContext) {
        super("XMLSecInboundFilter", messengerLog, uiConfig, applicationContext);
        this.xmlSignatureUtil = xmlSignatureUtil;
        this.certificateUtility = certificateUtility;
        this.xmlEncryptionUtil = xmlEncryptionUtil;
        this.profiles = profiles;
    }

    @Override
    protected Class<IFilterPlugin> getFilterPluginClass() {
        return null;
    }

    @Override
    public void doFilter(XpMessage xpMessage) throws BaseFilterException {
        Document document;
        if (!this.isEnabled(xpMessage)) {
            return;
        }
        String endSenderId = xpMessage.getProcessingDirective("EdaSender");
        if (endSenderId == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The filter is skipped: EdaSender is not set.");
            }
            return;
        }
        this.getLogger().info("Upack message '{}' from the xmlSec (EDA) using the partner '{}'.", (Object)xpMessage.getMessageId(), (Object)endSenderId);
        File xmlSecFile = xpMessage.getCurrentContentReference();
        try {
            String usingPrefix;
            Collection<X509Certificate> endSenderValidCerts = this.getSenderCertificates(endSenderId, xpMessage);
            if (endSenderValidCerts == null || endSenderValidCerts.size() == 0) {
                throw new XmlSignatureException(-1, "No certificate installed for sender: " + endSenderId);
            }
            document = XmlUtil.getDocument(xmlSecFile);
            XmlSignatureValidationResult validationResult = this.xmlSignatureUtil.isSignatureValid(document, endSenderValidCerts);
            if (validationResult.isValid()) {
                usingPrefix = "(partner '" + endSenderId + "') ";
                String usingInfoText = this.certificateUtility.toUsingInfoText(validationResult.getCertificate(), usingPrefix + "used certificate");
                this.messageLog(72, xpMessage.getDatabaseId(), xpMessage.getMessageId(), usingInfoText);
                this.messageLog(72, xpMessage.getDatabaseId(), xpMessage.getMessageId(), validationResult.toString());
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("XML Signature: {}", (Object)usingInfoText);
                }
            } else {
                this.messageLog(521, xpMessage.getDatabaseId(), xpMessage.getMessageId(), validationResult.getErrorMessage());
                this.messageLog(521, xpMessage.getDatabaseId(), xpMessage.getMessageId(), validationResult.toString());
                this.getLogger().error("XML Signature: {}", (Object)validationResult.getErrorMessage());
                this.getLogger().error("XML Signature: {}", (Object)validationResult.toString());
                throw new XmlSignatureException(-1, validationResult.getErrorMessage());
            }
            this.getLogger().info("XML Signature: {}. Message Signature successfully verified.", (Object)usingPrefix);
            this.getLogger().info("XML Signature: {}. {}", (Object)usingPrefix, (Object)validationResult.toString());
            this.xmlSignatureUtil.deleteSignatureTag(document);
        }
        catch (Exception e) {
            Object errorMSG = "Error while verifying signature: ";
            errorMSG = e instanceof LocalizedException ? (String)errorMSG + e.getMessage() : (String)errorMSG + e.toString();
            this.messageLog(521, xpMessage.getDatabaseId(), xpMessage.getMessageId(), (String)errorMSG);
            throw new XmlSignatureException(-1, (String)errorMSG);
        }
        try {
            List<SignCertInfo> receiverSignCertInfos = this.getReceiverSignCertInfos(xpMessage);
            if (receiverSignCertInfos == null || receiverSignCertInfos.size() == 0) {
                throw new XmlCryptException(-1, "No Certificate installed for receiver: " + xpMessage.getReceiverInternalId());
            }
            XmlDecryptionResult decryptionResult = this.xmlEncryptionUtil.decrypt(document, receiverSignCertInfos);
            if (!decryptionResult.isDecrypted()) {
                this.messageLog(542, xpMessage.getDatabaseId(), xpMessage.getMessageId(), decryptionResult.getErrorMessage());
                this.messageLog(542, xpMessage.getDatabaseId(), xpMessage.getMessageId(), decryptionResult.toString());
                this.getLogger().error("XML Encryption: {}", (Object)decryptionResult.getErrorMessage());
                this.getLogger().error("XML Encryption: {}", (Object)decryptionResult.toString());
                throw new XmlCryptException(-1, "Error while decrypting: " + decryptionResult.getErrorMessage());
            }
            String usingInfoText = this.certificateUtility.toUsingInfoText(decryptionResult.getCertificate());
            this.messageLog(91, xpMessage.getDatabaseId(), xpMessage.getMessageId(), usingInfoText);
            this.messageLog(91, xpMessage.getDatabaseId(), xpMessage.getMessageId(), decryptionResult.toString());
            this.getLogger().debug("XML Encryption: {}", (Object)usingInfoText);
            this.getLogger().info("XML Encryption: message is successfully decrypted.");
            this.getLogger().info("XML Encryption: {}", (Object)decryptionResult.toString());
            String payloadFilename = this.updateCurrentPayloadFilename(xpMessage, true);
            File xmlFile = new File(xmlSecFile.getParent(), payloadFilename);
            XmlUtil.writeDocument(xmlFile, document);
            xpMessage.setCurrentContentReference(xmlFile);
            this.updateProcessedOriginalFilename(xpMessage, true);
        }
        catch (Exception e) {
            Object errorMSG = "Error while decrypting: ";
            errorMSG = e instanceof LocalizedException ? (String)errorMSG + e.getMessage() : (String)errorMSG + e.toString();
            this.messageLog(542, xpMessage.getDatabaseId(), xpMessage.getMessageId(), (String)errorMSG);
            throw new XmlCryptException(-1, (String)errorMSG);
        }
    }

    private List<SignCertInfo> getReceiverSignCertInfos(XpMessage xpMessage) throws ProfileNotFoundException, ProfileException {
        String receiverLocalId = xpMessage.getCommunication().getReceiverLocalId();
        CppPartner receiver = this.profiles.getProfileForLocalId(receiverLocalId, true);
        return receiver.getAllKeys();
    }

    private Collection<X509Certificate> getSenderCertificates(String endSenderInternalId, XpMessage xpMessage) throws ProfileNotFoundException, ProfileException {
        CppPartner endSender = this.profiles.getProfileForInternalId(endSenderInternalId, true);
        Set<X509Certificate> endSenderCerts = endSender.getAllCertificates();
        return endSenderCerts;
    }

    @Override
    public UIOption[] getUIOptions() {
        return new UIOption[0];
    }
}

