/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.eda;

import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.IFilterPlugin;
import de.pontonconsulting.xmlpipe.uiconfig.UIConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;

public abstract class AbstractXMLSecFilter
extends BaseFilter<IFilterPlugin> {
    public static final String FILE_EXTENSION = ".xmlsec";
    public static final String OPTION_PATH = "/edaXmlSec";
    protected static final String PROCESSING_DIRECTIVE_EDA_SENDER = "EdaSender";
    protected static final String PROCESSING_DIRECTIVE_EDA_RECEIVER = "EdaReceiver";

    AbstractXMLSecFilter(String filterName, MessengerLog messengerLog, UIConfig uiConfig, ApplicationContext applicationContext) {
        super(filterName, messengerLog, uiConfig, applicationContext);
    }

    protected boolean isEnabled(XpMessage xpMessage) {
        if (xpMessage == null) {
            return false;
        }
        try {
            String optionValue = xpMessage.getCommunication().getPipelineOptionValueForMessage(OPTION_PATH, xpMessage.getSchemaLocation());
            if (StringUtils.isBlank((CharSequence)optionValue)) {
                return false;
            }
            if (Boolean.valueOf(optionValue).booleanValue()) {
                if (xpMessage.getCurrentContentReference() == null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("No XML payload found.");
                    }
                    return false;
                }
                return true;
            }
            return false;
        }
        catch (OptionNotFoundException ex) {
            return false;
        }
    }

    @Override
    protected String getDefaultExtension() {
        return FILE_EXTENSION;
    }
}

