/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.crypt;

import de.pontonconsulting.common.activation.SimpleFileDataSource;
import de.pontonconsulting.xmlpipe.LocalizedException;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.crypt.CryptException;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.mail.smime.SMIMEException;

public abstract class SMIMEEncrypter
extends BaseFilterPlugin {
    protected static final String PROVIDER = "BC";
    private String _smimeAlgorithm;
    private String _usedAlgorithm;
    private String _usedCryptAlgorithm;
    private final CertificateUtility _certificateUtility;
    private final de.pontonconsulting.xmlpipe.security.smime.SMIMEEncrypter _smimeEncrypter;

    public SMIMEEncrypter(String pluginName, CertificateUtility certificateUtility, de.pontonconsulting.xmlpipe.security.smime.SMIMEEncrypter smimeEncrypter, MessengerLog messengerLog) {
        super(pluginName, messengerLog);
        this._certificateUtility = certificateUtility;
        this._smimeEncrypter = smimeEncrypter;
    }

    protected void setEncryptionAlgorithm(String usedAlgorithm, String usedCryptAlgorithm, String smimeAlgorithm) {
        this._usedAlgorithm = usedAlgorithm;
        this._usedCryptAlgorithm = usedCryptAlgorithm;
        this._smimeAlgorithm = smimeAlgorithm;
    }

    public void doFilter(XpMessage message) throws CryptException {
        this._log.debug("Message {} will be encrypted", (Object)message.getMessageId());
        try {
            this.updateProcessedOriginalFilename(message, false);
            File fileIn = message.getCurrentContentReference();
            File fileOut = new File(message.getCurrentContentReferenceFolder(), fileIn.getName() + this.getDefaultExtension());
            X509Certificate cert = message.getCommunication().getProcessingEncryptionCertificate();
            String contentType = this.encryptFile(cert, fileIn, fileOut, message.getCurrentContentType());
            this.messageLog(64, message.getDatabaseId(), message.getMessageId(), this._certificateUtility.toUsingInfoText(cert, "using " + this._usedCryptAlgorithm + " and certificate"));
            if (this._log.isInfoEnabled()) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug(this._certificateUtility.toUsingInfoText(cert));
                }
                this._log.info("Message successfully encrypted");
            }
            message.setCurrentContentReference(fileOut);
            message.setCurrentContentType(contentType);
            message.setProcessingDirective("CryptoAlgorithm", this._usedAlgorithm);
        }
        catch (Exception e) {
            if (e instanceof LocalizedException) {
                this._log.fatal("Error while encrypting: {}", (Object)e.getMessage());
                this.messageLog(507, message.getDatabaseId(), message.getMessageId(), e.getMessage());
                throw new CryptException(17001, "Error while encrypting: " + e.getMessage());
            }
            this._log.fatal("Error while encrypting: {}", (Object)e.toString());
            this.messageLog(507, message.getDatabaseId(), message.getMessageId(), e.toString());
            throw new CryptException(17001, "Error while encrypting: " + e.toString());
        }
    }

    protected String encryptFile(X509Certificate receiverCert, File fileIn, File fileOut, String currentContentType) throws IOException, GeneralSecurityException, MessagingException, SMIMEException, CMSException {
        String contentType = null;
        try (SimpleFileDataSource dataSource = new SimpleFileDataSource(currentContentType, fileIn);
             BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(fileOut.toPath(), new OpenOption[0]));){
            MimeBodyPart bp = new MimeBodyPart();
            bp.setDataHandler(new DataHandler((DataSource)dataSource));
            bp.setHeader("Content-Type", currentContentType);
            bp.setHeader("Content-Transfer-Encoding", "binary");
            MimeBodyPart encBp = this._smimeEncrypter.createEncryptedMimePart(bp, this._smimeAlgorithm, receiverCert, "base64");
            encBp.getDataHandler().writeTo((OutputStream)fos);
            contentType = encBp.getContentType();
        }
        return contentType;
    }

    @Override
    protected String getDefaultExtension() {
        return ".p7m";
    }
}

