/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.compress;

import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.ICompressor;
import de.pontonconsulting.xmlpipe.messenger.filter.compress.CompressionException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.DeflaterOutputStream;

public class ZLibCompressor
extends BaseFilterPlugin
implements ICompressor {
    public static final String PROCESSING_VALUE_ZLIB = "Zlib";

    public ZLibCompressor(MessengerLog messengerLog) {
        super("ZLibCompressor", messengerLog);
    }

    @Override
    public void doFilter(XpMessage message) throws CompressionException {
        File temp = new File(message.getCurrentContentReferenceFolder(), message.getCurrentContentReference().getName() + this.getDefaultExtension());
        int before = 0;
        int after = 0;
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(message.getCurrentContentReference().toPath(), new OpenOption[0]));
             BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(temp.toPath(), new OpenOption[0]));){
            before = ((InputStream)in).available();
            try (DeflaterOutputStream comp = new DeflaterOutputStream(out);){
                ((InputStream)in).transferTo(comp);
            }
            this.updateProcessedOriginalFilename(message, false);
            message.setCurrentContentReference(temp);
            message.setCurrentContentType("application/octet-stream");
            message.setProcessingDirective("CompressionAlgorithm", PROCESSING_VALUE_ZLIB);
            after = (int)temp.length();
        }
        catch (IOException ioe) {
            this._log.fatal("Error while compressing message: {}", (Object)ioe.toString());
            this.messageLog(502, message.getDatabaseId(), message.getMessageId(), ioe.toString());
            throw new CompressionException(16001, "Error while compressing message: " + ioe.toString());
        }
        this._log.info("Message successfully compressed");
        this.messageLog(62, message.getDatabaseId(), message.getMessageId(), before + " bytes -> " + after + " bytes (" + this.getOptionValue() + ")");
    }

    @Override
    protected String getDefaultExtension() {
        return ".zlib";
    }

    @Override
    public String getOptionValue() {
        return PROCESSING_VALUE_ZLIB;
    }
}

