/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.compress;

import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.IDecompressor;
import de.pontonconsulting.xmlpipe.messenger.filter.compress.CompressionException;
import de.pontonconsulting.xmlpipe.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPInputStream;

public class GZIPDecompressor
extends BaseFilterPlugin
implements IDecompressor {
    public GZIPDecompressor(MessengerLog messengerLog) {
        super("GZIPDecompressor", messengerLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(XpMessage message) throws CompressionException {
        byte[] _buffer = new byte[8192];
        long before = message.getCurrentContentReference().length();
        long after = 0L;
        this._log.debug("Message is compressed: {} bytes", (Object)before);
        BufferedInputStream in = null;
        try {
            String payloadFilename = this.updateCurrentPayloadFilename(message, true);
            in = new BufferedInputStream(Files.newInputStream(message.getCurrentContentReference().toPath(), new OpenOption[0]));
            File outFile = new File(message.getCurrentContentReferenceFolder(), payloadFilename);
            this._log.debug("writing to:{}", (Object)outFile);
            BufferedOutputStream out = null;
            GZIPInputStream decomp = null;
            try {
                int length;
                out = new BufferedOutputStream(Files.newOutputStream(outFile.toPath(), new OpenOption[0]));
                decomp = new GZIPInputStream(in);
                while ((length = decomp.read(_buffer)) != -1) {
                    ((OutputStream)out).write(_buffer, 0, length);
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeStreamQuietly(decomp);
                IOUtil.closeStreamQuietly(out);
                throw throwable;
            }
            IOUtil.closeStreamQuietly(decomp);
            IOUtil.closeStreamQuietly(out);
            after = outFile.length();
            this._log.debug("Message is decompressed: {} bytes", (Object)after);
            message.setCurrentContentReference(outFile);
            this.updateProcessedOriginalFilename(message, true);
            this.messageLog(69, message.getDatabaseId(), message.getMessageId(), before + " bytes -> " + after + " bytes (" + this.getOptionValue() + ")");
            this._log.info("Message successfully decompressed ({})", (Object)this.getOptionValue());
        }
        catch (IOException e) {
            try {
                this._log.fatal("Error while decompressing Message: {}", (Object)e.toString());
                this.messageLog(503, message.getDatabaseId(), message.getMessageId(), "decompression problem: " + e.toString());
                throw new CompressionException(16003, "Error while decompressing Message: " + e.toString());
            }
            catch (Throwable throwable) {
                IOUtil.closeStreamQuietly(in);
                throw throwable;
            }
        }
        IOUtil.closeStreamQuietly(in);
    }

    @Override
    protected String getDefaultExtension() {
        return ".gz";
    }

    @Override
    public String getOptionValue() {
        return "GZIP";
    }
}

