/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter.compress;

import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.ICompressor;
import de.pontonconsulting.xmlpipe.messenger.filter.compress.CompressionException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class DeflateCompressor
extends BaseFilterPlugin
implements ICompressor {
    public static final String PROCESSING_VALUE_DEFLATE = "Deflate";

    public DeflateCompressor(MessengerLog messengerLog) {
        super("DeflateCompressor", messengerLog);
    }

    @Override
    public void doFilter(XpMessage message) throws CompressionException {
        byte[] buffer = new byte[8192];
        Deflater zipper = new Deflater(9, true);
        File temp = new File(message.getCurrentContentReferenceFolder(), message.getCurrentContentReference().getName() + this.getDefaultExtension());
        InputStream in = null;
        OutputStream out = null;
        try {
            int length;
            in = new BufferedInputStream(Files.newInputStream(message.getCurrentContentReference().toPath(), new OpenOption[0]));
            out = new BufferedOutputStream(Files.newOutputStream(temp.toPath(), new OpenOption[0]));
            DeflaterOutputStream comp = new DeflaterOutputStream(out, zipper);
            while ((length = in.read(buffer)) != -1) {
                comp.write(buffer, 0, length);
            }
            comp.close();
            this.updateProcessedOriginalFilename(message, false);
            message.setCurrentContentReference(temp);
            message.setCurrentContentType("application/octet-stream");
            message.setProcessingDirective("CompressionAlgorithm", PROCESSING_VALUE_DEFLATE);
        }
        catch (IOException ioe) {
            this._log.fatal("Error while compressing message:{}", (Object)ioe.toString());
            this.messageLog(502, message.getDatabaseId(), message.getMessageId(), ioe.toString());
            throw new CompressionException(16001, "Error while compressing message:" + ioe.toString());
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
        this._log.info("Message successfully compressed");
        this.messageLog(62, message.getDatabaseId(), message.getMessageId(), zipper.getTotalIn() + " bytes -> " + zipper.getTotalOut() + " bytes (Deflate)");
    }

    @Override
    protected String getDefaultExtension() {
        return ".zlib";
    }

    @Override
    public String getOptionValue() {
        return PROCESSING_VALUE_DEFLATE;
    }
}

