/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter;

import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.ISigner;
import de.pontonconsulting.xmlpipe.messenger.filter.sign.SignatureException;
import de.pontonconsulting.xmlpipe.uiconfig.UIConfig;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import java.util.Iterator;
import org.springframework.context.ApplicationContext;

public class SignatureCreationFilter
extends BaseFilter<ISigner> {
    public static final String EBXML_ATTACHMENT_TYPE = "Signature";
    public static final String OLD_SIGNATURE_FILE_EXTENSION = ".sig";
    public static final String PKCS7_FILE_EXTENSION = ".p7s";
    public static final String RSA_FILE_EXTENSION = ".rsa";
    public static final String ECDSA_FILE_EXTENSION = ".ecdsa";
    public static final String SMIME_FILE_EXTENSION = ".p7smime";
    public static final String PROCESSING_VALUE_SIGN_ALGORITHM_RSA = "rsa";
    public static final String PROCESSING_VALUE_SIGN_ALGORITHM_ECDSA = "ecdsa";
    public static final String OPTION_KEY_SIGN = "/sign";
    public static final String OPTION_KEY_PKCS7 = "/sign/PKCS7-signed-data";
    public static final String OPTION_KEY_PKCS7_CERTS = "/sign/PKCS7-signed-data/includeCerts";

    public SignatureCreationFilter(MessengerLog messengerLog, UIConfig uiConfig, ApplicationContext applicationContext) {
        super("SignatureCreationFilter", messengerLog, uiConfig, applicationContext);
    }

    @Override
    protected Class<ISigner> getFilterPluginClass() {
        return ISigner.class;
    }

    @Override
    public void doFilter(XpMessage message) throws SignatureException, BaseFilterException {
        if (message.getCurrentContentReference() == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("No XML payload to be compressed");
            }
            return;
        }
        String signStr = null;
        try {
            signStr = message.getCommunication().getPipelineOptionValueForMessage(OPTION_KEY_SIGN, message.getSchemaLocation());
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        if (signStr == null || signStr.length() == 0) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("No payload signing defined in agreement");
            }
            return;
        }
        boolean pluginFound = false;
        for (ISigner plugin : this._plugins) {
            if (!plugin.getOptionValue().equals(signStr)) continue;
            pluginFound = true;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Going to create the signature");
            }
            plugin.doFilter(message);
            break;
        }
        if (!pluginFound) {
            this.getLogger().fatal("Unknown signature algorithm: '{}'", (Object)signStr);
            this.messageLog(502, message.getDatabaseId(), message.getMessageId(), "Unknown signature algorithm: '" + signStr + "'");
            throw new BaseFilterException(19009, new String[]{signStr}, "Unknown signature algorithm: '" + signStr + "'");
        }
    }

    @Override
    public UIOption[] getUIOptions() {
        StringBuilder optionValues = new StringBuilder();
        Iterator it = this._plugins.iterator();
        while (it.hasNext()) {
            ISigner plugin = (ISigner)it.next();
            optionValues.append(plugin.getOptionValue());
            if (!it.hasNext()) continue;
            optionValues.append(",");
        }
        return new UIOption[]{new UIOption("pipelineOption.filter.sign", OPTION_KEY_SIGN, "list", optionValues.toString(), "help_header_sign", "pipelineOption.filter.sign", "pipelineOption.agreement.help.filter.sign", "pipelineOption.profile.help.filter.sign", UIOption.BOTH_PARTNERS, this.getDefaultValueFromUIConfig(OPTION_KEY_SIGN, "SHA1withRSA"), "senderCertificate"), new UIOption("pipelineOption.filter.sign.pkcs7", OPTION_KEY_PKCS7, "boolean", Boolean.TRUE.toString(), "help_header_sign_pkcs7", "pipelineOption.filter.sign.pkcs7", "pipelineOption.agreement.help.filter.sign.pkcs7", "pipelineOption.profile.help.filter.sign.pkcs7", UIOption.NONE, Boolean.parseBoolean(this.getDefaultValueFromUIConfig(OPTION_KEY_PKCS7, "false"))), new UIOption("pipelineOption.filter.sign.pkcs7.includeCerts", OPTION_KEY_PKCS7_CERTS, "boolean", Boolean.TRUE.toString(), "help_header_sign_pkcs7_includeCerts", "pipelineOption.filter.sign.pkcs7.includeCerts", "pipelineOption.agreement.help.filter.sign.pkcs7.includeCerts", "pipelineOption.profile.help.filter.sign.pkcs7.includeCerts", UIOption.NONE, Boolean.parseBoolean(this.getDefaultValueFromUIConfig(OPTION_KEY_PKCS7_CERTS, "false")))};
    }
}

