/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter;

import de.ponton.xmlpipe.rest.messagemulticastrule.MessageMulticastRule;
import de.ponton.xmlpipe.rest.messagemulticastrule.MessageMulticastRuleService;
import de.pontonconsulting.xmlpipe.adapter.messagemulticast.MessageMulticastAdapter;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.IFilterPlugin;
import de.pontonconsulting.xmlpipe.uiconfig.UIConfig;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;

public class MessageMulticastOutboundFilter
extends BaseFilter<IFilterPlugin> {
    private static final Logger log = LogManager.getLogger((String)("Messenger." + MessageMulticastOutboundFilter.class.getName()));
    private final MessageMulticastAdapter messageMulticastAdapter;
    private final MessageMulticastRuleService messageMulticastRuleService;

    public MessageMulticastOutboundFilter(MessengerLog messengerLog, UIConfig uiConfig, ApplicationContext applicationContext, MessageMulticastRuleService messageMulticastRuleService, MessageMulticastAdapter messageMulticastAdapter) {
        super(MessageMulticastOutboundFilter.class.getSimpleName(), messengerLog, uiConfig, applicationContext);
        this.messageMulticastRuleService = messageMulticastRuleService;
        this.messageMulticastAdapter = messageMulticastAdapter;
    }

    @Override
    protected Class<IFilterPlugin> getFilterPluginClass() {
        return null;
    }

    @Override
    public void doFilter(XpMessage xpMessage) throws BaseFilterException {
        if (xpMessage.getProcessingDirective("X-CopyOf") != null) {
            log.debug("Multicast message will not be multicasted.");
            return;
        }
        Optional<MessageMulticastRule> messageMulticastRule = this.getMatchingRule(xpMessage);
        messageMulticastRule.ifPresent(rule -> this.messageMulticastAdapter.sendCopies(xpMessage, rule.getCopyReceiverBackendIds()));
    }

    private Optional<MessageMulticastRule> getMatchingRule(XpMessage xpMessage) {
        String senderInternalId = xpMessage.getSenderInternalId();
        String receiverInternalId = xpMessage.getReceiverInternalId();
        String messageType = xpMessage.getMessageType();
        String messageVersion = xpMessage.getMessageVersion();
        String schemaSet = xpMessage.getSchemaSet();
        for (int i = 0; i < this.messageMulticastRuleService.getMessageMulticastOutboundRules().size(); ++i) {
            MessageMulticastRule rule = this.messageMulticastRuleService.getMessageMulticastOutboundRules().get(i);
            boolean messageTypeMatches = rule.getMessageTypes().stream().anyMatch(messageTypeModel -> messageTypeModel.getMessageType().equals(messageType) && messageTypeModel.getMessageVersion().equals(messageVersion) && messageTypeModel.getSchemaSet().equals(schemaSet));
            if (!messageTypeMatches || !rule.getSenderBackendIds().contains(senderInternalId) || !rule.getReceiverBackendIds().contains(receiverInternalId)) continue;
            log.debug("Message matched multicast rule no. {}", (Object)i);
            return Optional.of(rule);
        }
        return Optional.empty();
    }

    @Override
    public UIOption[] getUIOptions() {
        return new UIOption[0];
    }
}

