/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter;

import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.AgreementNotFoundException;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.ICrypter;
import de.pontonconsulting.xmlpipe.messenger.filter.crypt.CryptException;
import de.pontonconsulting.xmlpipe.uiconfig.UIConfig;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import java.util.Iterator;
import org.springframework.context.ApplicationContext;

public class EncryptionFilter
extends BaseFilter<ICrypter> {
    public static final String ASN1_FILE_EXTENSION = ".asn1";
    public static final String SMIME_FILE_EXTENSION = ".p7m";
    public static final String CRYPTED_CONTENT_TYPE = "application/pkcs7-mime";
    public static final String OPTION_ID = "/Encryption";
    public static final String X_509 = "X.509";
    private final Agreements _agreements;
    private final Profiles _profiles;

    public EncryptionFilter(Agreements agreements, Profiles profiles, MessengerLog messengerLog, UIConfig uiConfig, ApplicationContext applicationContext) {
        super("EncryptionFilter", messengerLog, uiConfig, applicationContext);
        this._agreements = agreements;
        this._profiles = profiles;
    }

    @Override
    protected Class<ICrypter> getFilterPluginClass() {
        return ICrypter.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(XpMessage message) throws CryptException, BaseFilterException {
        if (message.getCurrentContentReference() == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("No payload to be crypted");
            }
            return;
        }
        Communication originalCommunication = message.getCommunication();
        try {
            String contentReceiverId = message.getProcessingDirective("ContentReceiverID");
            if (contentReceiverId != null) {
                message.removeProcessingDirective("ContentReceiverID");
                this.getLogger().info("overriding content receiver with id '{}'.", (Object)contentReceiverId);
                String receiverId = null;
                try {
                    receiverId = this._profiles.getProfileForInternalId(contentReceiverId, true).getLocalId();
                    Agreement agreement = this._agreements.getAgreement(message.getSenderLocalId(), receiverId, true);
                    this.getLogger().debug("Using the agreement between  '{}' and '{}' for encryption only.", (Object)message.getSenderLocalId(), (Object)receiverId);
                    Communication newCommunication = agreement.getCommunication(message.getSenderLocalId(), receiverId);
                    this.getLogger().debug("Using the communcation with sender '{}' and receiver '{}' for encryption only.", (Object)message.getSenderLocalId(), (Object)receiverId);
                    message.setCommunication(newCommunication);
                }
                catch (AgreementNotFoundException e) {
                    String error = "Agreement between '" + message.getSenderLocalId() + "' and '" + receiverId + "' was not found.";
                    this.messageLog(507, message.getDatabaseId(), message.getMessageId(), error);
                    throw new CryptException(-1, error);
                }
                catch (AgreementException e) {
                    String error = "Communcation with sender '" + message.getSenderLocalId() + "' and receiver '" + receiverId + "' was not found.";
                    this.messageLog(507, message.getDatabaseId(), message.getMessageId(), error);
                    throw new CryptException(-1, error);
                }
                catch (ProfileException e) {
                    String error = "no profile for content receiver '" + contentReceiverId + "' found.";
                    this.messageLog(507, message.getDatabaseId(), message.getMessageId(), error);
                    throw new CryptException(-1, error);
                }
            }
            String cryptOption = null;
            try {
                cryptOption = message.getCommunication().getPipelineOptionValueForMessage(OPTION_ID, message.getSchemaLocation());
            }
            catch (OptionNotFoundException e) {
                // empty catch block
            }
            if (cryptOption != null && cryptOption.length() > 0) {
                boolean pluginFound = false;
                for (ICrypter plugin : this._plugins) {
                    if (!plugin.getOptionValue().equals(cryptOption)) continue;
                    try {
                        pluginFound = true;
                        plugin.doFilter(message);
                        break;
                    }
                    catch (BaseFilterException bfe) {
                        if (bfe instanceof CryptException) {
                            throw (CryptException)bfe;
                        }
                        throw bfe;
                    }
                }
                if (!pluginFound) {
                    this.getLogger().fatal("Unknown encryption option: '{}'", (Object)cryptOption);
                    this.messageLog(507, message.getDatabaseId(), message.getMessageId(), "Unknown encryption option: '" + cryptOption + "'");
                    throw new BaseFilterException(15014, new String[]{cryptOption}, "Unknown encryption option: '" + cryptOption + "'");
                }
            } else if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("No encryption selected in agreement");
            }
        }
        finally {
            message.setCommunication(originalCommunication);
        }
    }

    @Override
    public UIOption[] getUIOptions() {
        StringBuilder optionValues = new StringBuilder();
        Iterator it = this._plugins.iterator();
        while (it.hasNext()) {
            ICrypter plugin = (ICrypter)it.next();
            optionValues.append(plugin.getOptionValue());
            if (!it.hasNext()) continue;
            optionValues.append(",");
        }
        return new UIOption[]{new UIOption("pipelineOption.filter.crypt", OPTION_ID, "list", optionValues.toString(), "hilfe_header_crypt", "pipelineOption.filter.crypt", "pipelineOption.agreement.help.filter.crypt", "pipelineOption.profile.help.filter.crypt", UIOption.BOTH_PARTNERS, this.getDefaultValueFromUIConfig(OPTION_ID, "DES_EDE3_CBC"), "receiverCertificate")};
    }
}

