/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.filter;

import de.pontonconsulting.xmlpipe.cpp.OptionNotFoundException;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilter;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.ICompressor;
import de.pontonconsulting.xmlpipe.messenger.filter.IFilterPlugin;
import de.pontonconsulting.xmlpipe.messenger.filter.compress.CompressionException;
import de.pontonconsulting.xmlpipe.uiconfig.UIConfig;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import java.util.Iterator;
import org.springframework.context.ApplicationContext;

public class CompressionFilter
extends BaseFilter<ICompressor> {
    public static final String DEFLATE_FILE_EXTENSION = ".zlib";
    public static final String ZLIB_FILE_EXTENSION = ".zlib";
    public static final String ZIP_FILE_EXTENSION = ".zip";
    public static final String GZIP_FILE_EXTENSION = ".gz";
    public static final String OPTION_KEY = "/Compression";

    public CompressionFilter(MessengerLog messengerLog, UIConfig uiConfig, ApplicationContext applicationContext) {
        super("CompressionFilter", messengerLog, uiConfig, applicationContext);
    }

    @Override
    protected Class<ICompressor> getFilterPluginClass() {
        return ICompressor.class;
    }

    @Override
    public void doFilter(XpMessage message) throws CompressionException, BaseFilterException {
        if (message.getCurrentContentReference() == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("No XML payload to be compressed");
            }
            return;
        }
        String compressStr = null;
        try {
            compressStr = message.getCommunication().getPipelineOptionValueForMessage(OPTION_KEY, message.getSchemaLocation());
        }
        catch (OptionNotFoundException optionNotFoundException) {
            // empty catch block
        }
        if (compressStr == null || compressStr.length() == 0) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("No payload compression defined in agreement");
            }
            return;
        }
        boolean pluginFound = false;
        for (IFilterPlugin plugin : this._plugins) {
            if (!plugin.getOptionValue().equals(compressStr)) continue;
            try {
                pluginFound = true;
                plugin.doFilter(message);
                break;
            }
            catch (BaseFilterException bfe) {
                if (bfe instanceof CompressionException) {
                    throw (CompressionException)bfe;
                }
                throw bfe;
            }
        }
        if (!pluginFound) {
            this.getLogger().fatal("Unknown compression option: '{}'", (Object)compressStr);
            this.messageLog(502, message.getDatabaseId(), message.getMessageId(), "Unknown compression option: '" + compressStr + "'");
            throw new BaseFilterException(15014, new String[]{compressStr}, "Unknown compression option: '" + compressStr + "'");
        }
    }

    @Override
    public UIOption[] getUIOptions() {
        StringBuilder optionValues = new StringBuilder();
        Iterator it = this._plugins.iterator();
        while (it.hasNext()) {
            IFilterPlugin plugin = (IFilterPlugin)it.next();
            optionValues.append(plugin.getOptionValue());
            if (!it.hasNext()) continue;
            optionValues.append(",");
        }
        return new UIOption[]{new UIOption("pipelineOption.filter.compression", OPTION_KEY, "list", optionValues.toString(), "help_header_compression", "pipelineOption.filter.compression", "pipelineOption.agreement.help.filter.compression", "pipelineOption.profile.help.filter.compression", UIOption.BOTH_PARTNERS, this.getDefaultValueFromUIConfig(OPTION_KEY, "Zlib"))};
    }
}

