/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.emailnotification;

import de.pontonconsulting.xmlpipe.config.EMailSendSetting;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.events.ReloadConfiguration;
import de.pontonconsulting.xmlpipe.messenger.emailnotification.EMailNotification;
import de.pontonconsulting.xmlpipe.messenger.emailnotification.EMailNotificationJob;
import de.pontonconsulting.xmlpipe.messenger.emailnotification.INotificationService;
import de.pontonconsulting.xmlpipe.messenger.emailnotification.SystemEmailNotification;
import de.pontonconsulting.xmlpipe.messenger.emailnotification.SystemEmailNotificationJob;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.xml.bind.JAXBException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.springframework.context.ApplicationListener;

public class EmailNotificationScheduler
implements ApplicationListener<ReloadConfiguration> {
    private static final String DEFAULT_CRON_EXPRESSION = "0/5 * * * * ?";
    private static final int DEFAULT_EMAIL_MAX_COUNT = 1;
    private static final EMailSendSetting DEFAULT_EMAIL_SEND_SETTING = new EMailSendSetting("0/5 * * * * ?", 1);
    protected static final String QUARTZ_PARAM_EMAIL_MAX_COUNT = "EmailMaxCount";
    private static Log LOG = LogFactory.getFactory().getInstance("Messenger.EmailNotificationScheduler");
    private final Scheduler scheduler;
    private final MessengerConfig messengerConfig;
    private final Map<TriggerKey, JobKey> quartzJobs;
    private final EMailNotification messagingEmailNotification;
    private final SystemEmailNotification systemEmailNotification;

    public EmailNotificationScheduler(Scheduler scheduler, MessengerConfig messengerConfig, EMailNotification messagingEmailNotification, SystemEmailNotification systemEmailNotification) throws SchedulerException {
        this.scheduler = scheduler;
        this.messengerConfig = messengerConfig;
        this.quartzJobs = new HashMap<TriggerKey, JobKey>();
        this.messagingEmailNotification = messagingEmailNotification;
        this.systemEmailNotification = systemEmailNotification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void startQuartz() {
        Map<TriggerKey, JobKey> map = this.quartzJobs;
        synchronized (map) {
            try {
                ArrayList<EMailSendSetting> emailSendSettings = new ArrayList<EMailSendSetting>(this.messengerConfig.getEMailSendSettings());
                if (emailSendSettings.isEmpty()) {
                    this.createCronJobFor("MessagingEmailNotification", "_default", this.messagingEmailNotification, EMailNotificationJob.class, DEFAULT_EMAIL_SEND_SETTING);
                    this.createCronJobFor("SystemEmailNotification", "_default", this.systemEmailNotification, SystemEmailNotificationJob.class, DEFAULT_EMAIL_SEND_SETTING);
                } else {
                    for (int i = 0; i < emailSendSettings.size(); ++i) {
                        EMailSendSetting emailSendSetting = (EMailSendSetting)emailSendSettings.get(i);
                        this.createCronJobFor("MessagingEmailNotification", "_" + i, this.messagingEmailNotification, EMailNotificationJob.class, emailSendSetting);
                        this.createCronJobFor("SystemEmailNotification", "_" + i, this.systemEmailNotification, SystemEmailNotificationJob.class, emailSendSetting);
                    }
                }
            }
            catch (JAXBException e) {
                LOG.fatal((Object)"Could not read messenger.xml: ", (Throwable)e);
            }
        }
    }

    private void createCronJobFor(String namePrefix, String nameSuffix, INotificationService notificationService, Class<? extends Job> jobClass, EMailSendSetting emailSendSetting) {
        JobKey jobKey = new JobKey(namePrefix + "Job" + nameSuffix);
        TriggerKey triggerKey = new TriggerKey(namePrefix + "WorkCronTrigger" + nameSuffix);
        JobDetail jobDetail = null;
        try {
            jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobKey).usingJobData(QUARTZ_PARAM_EMAIL_MAX_COUNT, Integer.valueOf(emailSendSetting.getEmailMaxCount())).build();
            CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronScheduleNonvalidatedExpression((String)emailSendSetting.getCronExpression())).startNow().build();
            this.scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
            this.quartzJobs.put(triggerKey, jobKey);
            LOG.debug((Object)("Added cron job '" + jobKey.getName() + "' with expression '" + emailSendSetting.getCronExpression() + "'."));
            LOG.debug((Object)("Next execution time: " + String.valueOf(cronTrigger.getNextFireTime())));
        }
        catch (Exception e) {
            if (jobDetail != null) {
                try {
                    this.scheduler.deleteJob(jobKey);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LOG.error((Object)("Could not add cron job '" + jobDetail.getKey().getName() + "' with expression '" + emailSendSetting.getCronExpression() + "': " + e.toString()));
            }
            LOG.error((Object)("Could not add cron job with expression '" + emailSendSetting.getCronExpression() + "': " + e.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void stopQuartz() {
        Map<TriggerKey, JobKey> map = this.quartzJobs;
        synchronized (map) {
            for (Map.Entry<TriggerKey, JobKey> triggerWithJob : this.quartzJobs.entrySet()) {
                TriggerKey quartzTrigger = triggerWithJob.getKey();
                try {
                    this.scheduler.unscheduleJob(quartzTrigger);
                    LOG.debug((Object)("Deleted quartz Trigger '" + quartzTrigger.getName() + "'."));
                }
                catch (SchedulerException e) {
                    LOG.fatal((Object)("Could not delete quartz trigger '" + String.valueOf(quartzTrigger) + "': " + e.toString()));
                }
                JobKey quartzJob = triggerWithJob.getValue();
                try {
                    this.scheduler.deleteJob(quartzJob);
                    LOG.debug((Object)("Deleted quartz job '" + quartzJob.getName() + "'."));
                }
                catch (SchedulerException e) {
                    LOG.fatal((Object)("Could not delete quartz job '" + quartzJob.getName() + "': " + e.toString()));
                }
            }
            this.quartzJobs.clear();
        }
    }

    public void onApplicationEvent(ReloadConfiguration reloadConfig) {
        this.stopQuartz();
        this.startQuartz();
    }
}

