/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessengerConfigDAO
extends BaseDAO {
    private static final Logger _log = LogManager.getLogger((String)"Messenger.MessengerConfigDAO");
    public static final String MESSENGER_CONFIG = "messenger.xml";
    public static final String LISTENER_CONFIG = "listener.properties";
    public static final String SERVER_CONFIG = "server.xml";
    public static final String HOTFOLDER = "hotfolder.xml";
    public static final String MULTICAST_RULES = "messageMulticastRule.json";
    public static final String CLIENT_ROLES = "clientRoles.json";
    public static final String SCHEMATA = "schemata";
    public static final String ENVELOPES = "envelopes";
    public static final String AGREEMENT_TEMPLATES = "agreement_templates";
    public static final String KEYSTORE = "keystore";
    public static final String KEYSTORE_SSL = "keystore-ssl";
    public static final String TRUST_KEYSTORE_SSL = "trust-keystore-ssl";
    public static final String KEYSTORE_SSL_TEMP = "keystore-ssl-temp";
    public static final String SYSTEM_USER = "SYSTEM";

    public MessengerConfigDAO(HibernateSessionFactory hibernateSessionFactory) {
        super(hibernateSessionFactory);
    }

    public MessengerConfig loadMessengerConfig(String configType) {
        MessengerConfig messengerConfig;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("FROM MessengerConfig WHERE type = :configType", MessengerConfig.class);
                query.setParameter("configType", (Object)configType);
                messengerConfig = (MessengerConfig)query.getSingleResult();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return null;
                }
            }
            entityManager.close();
        }
        return messengerConfig;
    }

    public long storeMessengerConfig(byte[] data, String configType, String username) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            OffsetDateTime timestamp = OffsetDateTime.now(ZoneOffset.UTC);
            if (this.doesMessengerConfigExist(configType)) {
                entityManager.getTransaction().begin();
                entityManager.createQuery("UPDATE MessengerConfig SET data = :data, username = :username, timestamp = :timestamp WHERE type = :type").setParameter("data", (Object)data).setParameter("username", (Object)username).setParameter("timestamp", (Object)timestamp).setParameter("type", (Object)configType).executeUpdate();
                entityManager.getTransaction().commit();
                _log.debug("Updated MessengerConfig '{}' in database, changed by {}", (Object)configType, (Object)username);
            } else {
                entityManager.getTransaction().begin();
                entityManager.createQuery("INSERT INTO MessengerConfig (type, data, username, timestamp) VALUES (:type, :data, :username, :timestamp)").setParameter("type", (Object)configType).setParameter("data", (Object)data).setParameter("username", (Object)username).setParameter("timestamp", (Object)timestamp).executeUpdate();
                entityManager.getTransaction().commit();
                _log.debug("Inserted new MessengerConfig '{}' to database, changed by {}", (Object)configType, (Object)username);
            }
            long l = timestamp.toInstant().toEpochMilli();
            return l;
        }
    }

    public Optional<OffsetDateTime> getTimestampByConfigType(String configType) {
        Optional<OffsetDateTime> optional;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("SELECT mc.timestamp FROM MessengerConfig mc WHERE mc.type = :configType", OffsetDateTime.class);
                query.setParameter("configType", (Object)configType);
                optional = Optional.of((OffsetDateTime)query.getSingleResult());
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return Optional.empty();
                }
            }
            entityManager.close();
        }
        return optional;
    }

    public long getTimestampAsLongByConfigType(String configType) {
        return this.getTimestampByConfigType(configType).map(offsetDateTime -> offsetDateTime.toInstant().toEpochMilli()).orElse(0L);
    }

    public String getUserByConfigType(String configType) {
        String string;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("SELECT mc.username FROM MessengerConfig mc WHERE mc.type = :configType", String.class);
                query.setParameter("configType", (Object)configType);
                string = String.valueOf(query.getSingleResult());
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return "";
                }
            }
            entityManager.close();
        }
        return string;
    }

    public boolean doesMessengerConfigExist(String configType) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            TypedQuery query = entityManager.createQuery("SELECT COUNT(mc) FROM MessengerConfig mc WHERE mc.type = :configType", Long.class);
            query.setParameter("configType", (Object)configType);
            boolean bl = (Long)query.getSingleResult() > 0L;
            return bl;
        }
    }

    public List<MessengerConfig> loadAllMessengerConfigs() {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                TypedQuery query = entityManager.createQuery("FROM MessengerConfig ORDER BY type", MessengerConfig.class);
                list = query.getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoResultException e) {
                    return Collections.emptyList();
                }
            }
            entityManager.close();
        }
        return list;
    }

    public void importMessengerConfig(MessengerConfig messengerConfig) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            entityManager.merge((Object)messengerConfig);
            entityManager.getTransaction().commit();
        }
    }
}

