/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.Mdndata;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.transport.MDNData;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.NoResultException;
import java.util.Collection;

public class MDNDataDAO
extends BaseDAO {
    private static final char SPACE = ' ';
    private static final char GT = '>';
    private static final char LT = '<';
    private static final String TEST_VALUE_DIGEST = "my.digest_1234567890";
    private static final String TEST_VALUE_DIGEST_ALGORITHM = "my.digest.algorithm_1234567890";
    private static final String SQL_DELETE_MDNDATA_BY_ID = "DELETE de.pontonconsulting.xmlpipe.messenger.database.hibernate.Mdndata md WHERE md.messageId = :messageId";
    private static final String SQL_DELETE_MDNDATA_BY_IDS = "DELETE de.pontonconsulting.xmlpipe.messenger.database.hibernate.Mdndata md WHERE md.messageId IN (:messageIds)";
    private final MessageDAO _messageDAO;

    public MDNDataDAO(HibernateSessionFactory hibernateSessionFactory, MessageDAO messageDAO) {
        super(hibernateSessionFactory);
        this._messageDAO = messageDAO;
    }

    public void insertMDNData(String messageId, String messageDigest, String messageDigestAlgorithm) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            String fixedMessageId = messageId.replace('<', ' ').replace('>', ' ').trim();
            Message message = this._messageDAO.getMessage(entityManager, fixedMessageId, 0);
            Mdndata mdndata = new Mdndata();
            mdndata.setMessage(message);
            mdndata.setDigest(messageDigest);
            mdndata.setDigestAlgorithm(messageDigestAlgorithm);
            entityManager.persist((Object)mdndata);
            entityManager.getTransaction().commit();
        }
        catch (RuntimeException e) {
            _log.error("MDNData of message " + messageId + " could not be saved in database:" + e.getMessage(), (Throwable)e);
            throw new DbException(13039, "Could not store new MDN data to Database: " + e.getMessage(), e);
        }
    }

    public int deleteMDNData(long messageDatatID) throws DbException {
        int n;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                int result = this.deleteMDNData(messageDatatID, entityManager);
                entityManager.getTransaction().commit();
                n = result;
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DbException e) {
                    _log.error("Can't delete MDNData " + messageDatatID + " from DB: " + e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
            entityManager.close();
        }
        return n;
    }

    public int deleteMDNData(long messageDataId, EntityManager entityManager) throws DbException {
        try {
            return entityManager.createQuery(SQL_DELETE_MDNDATA_BY_ID).setParameter("messageId", (Object)messageDataId).executeUpdate();
        }
        catch (NoResultException e) {
            _log.debug("MdnData with messageId {} not found", (Object)messageDataId);
            return 0;
        }
        catch (RuntimeException e) {
            throw new DbException(13039, "Could not get MDNDATA reference from Database: " + e.getMessage(), e);
        }
    }

    public int deleteByMessageDataIds(Collection<Long> messageDataIds, EntityManager entityManager) throws DbException {
        try {
            return entityManager.createQuery(SQL_DELETE_MDNDATA_BY_IDS).setParameter("messageIds", messageDataIds).executeUpdate();
        }
        catch (RuntimeException e) {
            throw new DbException(13039, "Could not delete MDNDATA reference from Database: " + e.getMessage(), e);
        }
    }

    public MDNData getMDNDataById(long messageDataID) throws DbException {
        MDNData data;
        block11: {
            data = null;
            try (EntityManager entityManager = this.createNewEntityManager();){
                Message message = this._messageDAO.getMessage(entityManager, messageDataID);
                if (message == null) break block11;
                Mdndata mdndata = message.getMdndata();
                try {
                    mdndata.getDigestAlgorithm();
                }
                catch (EntityNotFoundException enf) {
                    mdndata = null;
                }
                if (mdndata != null) {
                    data = new MDNData(message.getMessageId(), mdndata.getDigest(), mdndata.getDigestAlgorithm(), message.getSenderId(), message.getReceiverId(), message.getConversation() != null ? message.getConversation().getConversationId() : null);
                }
            }
            catch (RuntimeException e) {
                throw new DbException(13050, "Could not get MDNData from Database:" + e.getMessage(), e);
            }
        }
        return data;
    }

    public void dbConsistencyCheck(Message testMessage) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            Mdndata mdndata = new Mdndata();
            mdndata.setMessage(testMessage);
            mdndata.setDigest(TEST_VALUE_DIGEST);
            mdndata.setDigestAlgorithm(TEST_VALUE_DIGEST_ALGORITHM);
            entityManager.persist((Object)mdndata);
            entityManager.getTransaction().commit();
        }
        catch (RuntimeException e) {
            throw new DbException(13069, "DB Consistency check for table 'MDNDATA' failed. Reason: " + e.getMessage(), e);
        }
    }

    public void dbCleanup(long testMessageDatabaseId) throws DbException {
        this.deleteMDNData(testMessageDatabaseId);
    }
}

