/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.tables;

import de.ponton.xmlpipe.queue.InboundQueueMessage;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.HibernateSessionFactory;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.InboundQueue;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message;
import de.pontonconsulting.xmlpipe.messenger.database.tables.BaseDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.NoResultException;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InboundQueueingDAO
extends BaseDAO {
    public static int ACK_SENT = 1;
    public static int ACK_NOT_SENT = 0;
    public static final int STATUS_ENQUEUED = 0;
    public static final int STATUS_IN_TRANSFER = 1;
    private static final Logger _log = LogManager.getLogger((String)"Messenger.InboundQueueingDAO");
    private static final String SQL_DELETE_INBOUND_QUEUE_BY_ID = "DELETE de.pontonconsulting.xmlpipe.messenger.database.hibernate.InboundQueue iq WHERE iq.messageId =  :messageId";
    private static final String SQL_GET_NEXT_PENDING_MESSAGE_ID = "SELECT messageId\nFROM InboundQueue\nWHERE status = 0 AND adapterId = :adapterId\nORDER BY priority DESC, messageId ASC\n";
    private static final String SQL_UPDATE_NEXT_MESSAGE = "UPDATE InboundQueue\nSET status = 1, nextTransmission = :now, messengerId = :messengerId\nWHERE messageId = :messageId AND status = 0\n";
    private static final String QUERY_SELECT_MESSAGE_COUNT_FOR_IDS = "SELECT COUNT(*)\nFROM InboundQueue\nWHERE messageId in :messageIds\n";
    private static final String SQL_SELECT_MESSAGE_COUNT = "SELECT COUNT(*)\nFROM InboundQueue\nWHERE adapterId = :adapterId AND messengerId = :messengerId\n";
    private static final String SQL_SELECT_ADAPTERS_WITH_PENDING_MESSAGES = "SELECT DISTINCT adapterId\nFROM InboundQueue\n";
    private static final String SQL_UPDATE_NEXT_TRANSMISSION = "UPDATE InboundQueue\nSET nextTransmission = :nextTransmission\nWHERE messageId = :messageId AND status = 1 AND messengerId = :messengerId\n";
    private static final String QUERY_GET_ADAPTER_TIME_OUT_MESSAGES = "SELECT messageId\nFROM InboundQueue\nWHERE adapterId = :adapterId AND status = 1 AND nextTransmission <= :timeout\n";
    private static final String SQL_UPDATE_RESET_TRANSMISSION = "UPDATE InboundQueue\nSET nextTransmission = 0, status = 0\nWHERE messageId = :messageId AND status = 1\n";
    private final MessengerLog _messengerLog;
    private final MessageDAO _messageDAO;
    private final MessengerConfig _messengerConfig;
    private final ReferenceDateTask referenceDateTask;
    private static final String PARAM_MESSAGE_IDS = "messageIds";
    private static final String PARAM_MESSAGE_ID = "messageId";
    private static final String PARAM_MESSENGER_ID = "messengerId";
    private static final String PARAM_ADAPTER_ID = "adapterId";
    private static final String ERROR_ADD_INBOUND = "Error while adding inbound message to Database: ";
    private static final String ERROR_REMOVE_INBOUND = "Error while removing from inbound message queue: ";
    private static final String ERROR_GET_INBOUND = "Error while getting inbound message queue: ";
    static final long TEST_VALUE_TIMESECONDS = 123456789012345678L;
    static final String TEST_VALUE_ADAPTER_ID = "hotfolder-1";
    static final long TEST_VALUE_NEXT_TRANSMISSION = 123456789012345678L;
    static final int TEST_VALUE_MESSENGER_ID = 123;

    public InboundQueueingDAO(HibernateSessionFactory hibernateSessionFactory, MessengerLog messengerLog, MessageDAO messageDAO, MessengerConfig messengerConfig, ReferenceDateTask referenceDateTask) {
        super(hibernateSessionFactory);
        this._messengerLog = messengerLog;
        this._messageDAO = messageDAO;
        this._messengerConfig = messengerConfig;
        this.referenceDateTask = referenceDateTask;
    }

    public void addToInboundQueue(InboundQueueMessage inboundQueueMessage) throws DbException {
        try {
            try (EntityManager entityManager = this.createNewEntityManager();){
                entityManager.getTransaction().begin();
                InboundQueue iq = new InboundQueue(inboundQueueMessage.getUniqueId());
                iq.setTimeseconds(inboundQueueMessage.getQueuedTimestamp());
                iq.setAdapterId(inboundQueueMessage.getAdapterId());
                iq.setNextTransmission(0L);
                iq.setMessengerId(this._messengerConfig.getMessengerId());
                iq.setStatus(0);
                iq.setPriority(inboundQueueMessage.getPriority());
                iq.setAckSent(ACK_SENT);
                entityManager.persist((Object)iq);
                this._messageDAO.updateMessageStatusInSameTransaction(inboundQueueMessage.getUniqueId(), 2, entityManager);
                entityManager.getTransaction().commit();
            }
            this._messengerLog.log2db(6, inboundQueueMessage.getUniqueId(), inboundQueueMessage.getAdapterId());
        }
        catch (RuntimeException e) {
            throw new DbException(13006, ERROR_ADD_INBOUND + e.getMessage(), e);
        }
    }

    public void loadMessagesInTransferFromDatabase(Consumer<InboundQueue> callback) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            CriteriaBuilder cb = entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = cb.createQuery(InboundQueue.class);
            Root inboundQeueRoot = criteriaQuery.from(InboundQueue.class);
            criteriaQuery.select((Selection)inboundQeueRoot);
            criteriaQuery.where((Expression)cb.equal((Expression)inboundQeueRoot.get(PARAM_MESSENGER_ID), (Object)this._messengerConfig.getMessengerId()));
            criteriaQuery.where((Expression)cb.equal((Expression)inboundQeueRoot.get("status"), (Object)1));
            criteriaQuery.orderBy(new Order[]{cb.asc((Expression)inboundQeueRoot.get("timeseconds"))});
            entityManager.createQuery(criteriaQuery).getResultStream().forEach(dbInbound -> {
                try {
                    callback.accept((InboundQueue)dbInbound);
                }
                catch (Throwable e) {
                    _log.error(e.getMessage(), e);
                }
                entityManager.detach(dbInbound);
            });
        }
        catch (RuntimeException e) {
            throw new DbException(13007, ERROR_GET_INBOUND + e.getMessage(), e);
        }
    }

    public List<String> getAdaptersWithPendingMessages() throws DbException {
        List list;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                list = entityManager.createQuery(SQL_SELECT_ADAPTERS_WITH_PENDING_MESSAGES, String.class).getResultList();
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13007, ERROR_GET_INBOUND + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Long> startTransferOfNextPendingMessage(String adapterId) {
        _log.trace("Getting next pending message for adapterId={}", (Object)adapterId);
        try (EntityManager entityManager = this.createNewEntityManager();){
            Long messageId = (Long)entityManager.createQuery(SQL_GET_NEXT_PENDING_MESSAGE_ID, Long.class).setParameter(PARAM_ADAPTER_ID, (Object)adapterId).setMaxResults(1).getSingleResult();
            _log.trace("Found next pending message for adapterId={} with ID={}", (Object)adapterId, (Object)messageId);
            entityManager.getTransaction().begin();
            int updateCount = entityManager.createQuery(SQL_UPDATE_NEXT_MESSAGE).setParameter(PARAM_MESSAGE_ID, (Object)messageId).setParameter(PARAM_MESSENGER_ID, (Object)this._messengerConfig.getMessengerId()).setParameter("now", (Object)this.referenceDateTask.getReferenceCurrentTimeMillis()).executeUpdate();
            if (updateCount == 1) {
                _log.trace("Changed status of message with ID={} to IN TRANSFER", (Object)messageId);
                entityManager.getTransaction().commit();
                Optional<Long> optional2 = Optional.of(messageId);
                return optional2;
            }
            _log.trace("Message with ID={} is already IN TRANSFER", (Object)messageId);
            entityManager.getTransaction().rollback();
            Optional<Long> optional = Optional.empty();
            return optional;
        }
        catch (NoResultException e) {
            _log.debug("No pending InboundQueue message found for adapterId={}", (Object)adapterId);
            return Optional.empty();
        }
        catch (Exception e) {
            _log.fatal("Can't select next pending InboundQueue message for adapterId={}", (Object)adapterId, (Object)e);
        }
        return Optional.empty();
    }

    public boolean setNextTransmission(long messageId, Long nextTransmission) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            int updateCount = entityManager.createQuery(SQL_UPDATE_NEXT_TRANSMISSION).setParameter(PARAM_MESSAGE_ID, (Object)messageId).setParameter(PARAM_MESSENGER_ID, (Object)this._messengerConfig.getMessengerId()).setParameter("nextTransmission", (Object)(Objects.nonNull(nextTransmission) ? nextTransmission.longValue() : this.referenceDateTask.getReferenceCurrentTimeMillis())).executeUpdate();
            if (updateCount == 0) {
                _log.warn("No InboundQueue message found to update NextTransmission (messageId={} / messengerId={} / status=1)", (Object)messageId, (Object)this._messengerConfig.getMessengerId());
            } else {
                _log.trace("Updated NextTransmission InboundQueue message (messageId={})", (Object)messageId);
            }
            entityManager.getTransaction().commit();
            boolean bl = updateCount == 1;
            return bl;
        }
    }

    public List<Long> getTimedOutMessagesOfAdapter(String adapterId, int adapterProcessTimeout) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            long timeout = this.referenceDateTask.getReferenceCurrentTimeMillis() - (long)((adapterProcessTimeout <= 0 ? 30 : adapterProcessTimeout) * 2) * 1000L;
            List list = entityManager.createQuery(QUERY_GET_ADAPTER_TIME_OUT_MESSAGES, Long.class).setParameter(PARAM_ADAPTER_ID, (Object)adapterId).setParameter("timeout", (Object)timeout).getResultList();
            return list;
        }
    }

    public boolean resetTransmissionState(long messageId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            int updateCount = entityManager.createQuery(SQL_UPDATE_RESET_TRANSMISSION).setParameter(PARAM_MESSAGE_ID, (Object)messageId).executeUpdate();
            if (updateCount == 0) {
                _log.warn("No InboundQueue message found to reset (messageId={} / status=1)", (Object)messageId);
            } else {
                _log.trace("TransmissionState of InboundQueue message (messageId={}) reset", (Object)messageId);
            }
            entityManager.getTransaction().commit();
            boolean bl = updateCount == 1;
            return bl;
        }
    }

    public boolean deleteFromInboundQueue(long messageDataId) throws DbException {
        boolean bl;
        block8: {
            EntityManager entityManager = this.createNewEntityManager();
            try {
                entityManager.getTransaction().begin();
                boolean result = this.deleteFromInboundQueue(messageDataId, entityManager);
                entityManager.getTransaction().commit();
                bl = result;
                if (entityManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entityManager != null) {
                        try {
                            entityManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new DbException(13007, ERROR_REMOVE_INBOUND + e.getMessage(), e);
                }
            }
            entityManager.close();
        }
        return bl;
    }

    public boolean deleteFromInboundQueue(long messageDataId, EntityManager entityManager) throws DbException {
        try {
            int result = entityManager.createQuery(SQL_DELETE_INBOUND_QUEUE_BY_ID).setParameter(PARAM_MESSAGE_ID, (Object)messageDataId).executeUpdate();
            return result > 0;
        }
        catch (EntityNotFoundException e) {
            return false;
        }
        catch (RuntimeException e) {
            throw new DbException(13010, ERROR_REMOVE_INBOUND + e.getMessage(), e);
        }
    }

    public void dbConsistencyCheck(Message testMessage) throws DbException {
        try (EntityManager entityManager = this.createNewEntityManager();){
            entityManager.getTransaction().begin();
            InboundQueue iq = new InboundQueue();
            iq.setMessageId(testMessage.getId());
            iq.setStatus(-1);
            iq.setPriority(-1);
            iq.setTimeseconds(123456789012345678L);
            iq.setAdapterId(TEST_VALUE_ADAPTER_ID);
            iq.setNextTransmission(123456789012345678L);
            iq.setMessengerId(123);
            entityManager.persist((Object)iq);
            entityManager.getTransaction().commit();
        }
        catch (RuntimeException e) {
            throw new DbException(13043, "DB Consistency check for table 'INBOUND_QUEUE' failed. Reason: " + e.getMessage(), e);
        }
    }

    public int getQueueSize(String adapterId) {
        try (EntityManager entityManager = this.createNewEntityManager();){
            int count;
            int n = count = ((Long)entityManager.createQuery(SQL_SELECT_MESSAGE_COUNT, Long.class).setParameter(PARAM_MESSENGER_ID, (Object)this._messengerConfig.getMessengerId()).setParameter(PARAM_ADAPTER_ID, (Object)adapterId).getSingleResult()).intValue();
            return n;
        }
    }

    public boolean containsMessages(Collection<Long> messageDataIds, EntityManager entityManager) {
        return ((Long)entityManager.createQuery(QUERY_SELECT_MESSAGE_COUNT_FOR_IDS, Long.class).setParameter(PARAM_MESSAGE_IDS, messageDataIds).getSingleResult()).intValue() > 0;
    }
}

