/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.hibernate;

import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpBaseMessage;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.io.File;
import java.io.Serializable;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="FILE_REF")
public class XpMessageAttachment
implements Serializable {
    private static final long serialVersionUID = 7307188059297936025L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="fileRefIdSeq")
    @GenericGenerator(name="fileRefIdSeq", strategy="native", parameters={@Parameter(name="sequence", value="ID_SEQUENCE_FILE_REF")})
    @Column(name="ID", nullable=false)
    private Long id;
    @Column(name="FILENAME", nullable=false)
    private String fileName;
    @Column(name="FILE_TYPE", nullable=false)
    private Integer fileType;
    @Column(name="MIME_TYPE", length=30)
    private String mimeType;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="LANGUAGE", length=30)
    private String language;
    @Column(name="ROLE", length=30)
    private String role;
    @ManyToOne
    @JoinColumn(name="MESSAGE_ID", nullable=false)
    private XpBaseMessage message;

    public Long getId() {
        return this.id;
    }

    public XpMessageAttachment setId(Long id) {
        this.id = id;
        return this;
    }

    public long getMessageId() {
        return this.message.getDatabaseId();
    }

    public String getFileName() {
        return this.fileName;
    }

    public XpMessageAttachment setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public Integer getFileType() {
        return this.fileType;
    }

    public XpMessageAttachment setFileType(Integer fileType) {
        this.fileType = fileType;
        return this;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public XpMessageAttachment setMimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public XpMessageAttachment setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public XpMessageAttachment setLanguage(String language) {
        this.language = language;
        return this;
    }

    public String getRole() {
        return this.role;
    }

    public XpMessageAttachment setRole(String role) {
        this.role = role;
        return this;
    }

    public File resolveAttachmentFile(File workDir) {
        return workDir.toPath().resolve("attachments").resolve(this.fileName).toFile();
    }

    public XpMessageAttachment setMessage(XpBaseMessage message) {
        this.message = message;
        return this;
    }
}

