/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database.hibernate;

import de.pontonconsulting.xmlpipe.messenger.database.hibernate.MessageProcessingDirectiveId;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpBaseMessage;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapsId;
import jakarta.persistence.Table;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Entity
@Table(name="MESSAGE_PROCESSING_DIRECTIVE")
public class MessageProcessingDirective
implements Serializable {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.MessageProcessingDirective");
    private static final long serialVersionUID = -985620285544001583L;
    @EmbeddedId
    private MessageProcessingDirectiveId id;
    @Column(name="VALUE")
    private String value;
    @ManyToOne
    @MapsId(value="messageId")
    @JoinColumn(name="MESSAGE_ID", referencedColumnName="ID")
    private XpBaseMessage message;

    public MessageProcessingDirective(long messageID, String type, String value) {
        this.setId(new MessageProcessingDirectiveId(messageID, type));
        this.setValue(value);
    }

    public MessageProcessingDirective() {
    }

    public MessageProcessingDirectiveId getId() {
        return this.id;
    }

    public MessageProcessingDirective setId(MessageProcessingDirectiveId id) {
        this.id = id;
        return this;
    }

    public MessageProcessingDirective setId(Long messageID, String type) {
        this.setId(new MessageProcessingDirectiveId(messageID, type));
        return this;
    }

    public String getType() {
        return this.id.type();
    }

    public String getValue() {
        return this.value;
    }

    public MessageProcessingDirective setValue(String value) {
        if (StringUtils.length((CharSequence)value) < 512) {
            this.value = value;
        } else {
            LOG.warn("Value of MessageProcessingDirective of {} exceeds 512 characters and will be truncated: {}", (Object)this.id, (Object)value);
            this.value = StringUtils.substring((String)value, (int)0, (int)512);
        }
        return this;
    }

    public MessageProcessingDirective setMessage(XpBaseMessage message) {
        this.message = message;
        return this;
    }
}

