/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.util.Arrays;
import java.util.List;

@Converter
public class StringListConverter
implements AttributeConverter<List<String>, String> {
    private static final String SEPARATOR = ",";

    public String convertToDatabaseColumn(List<String> attribute) {
        if (attribute == null || attribute.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)SEPARATOR, attribute);
    }

    public List<String> convertToEntityAttribute(String dbData) {
        if (dbData == null || dbData.isEmpty()) {
            return List.of();
        }
        return Arrays.asList(dbData.split(SEPARATOR));
    }
}

