/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database;

import de.pontonconsulting.xmlpipe.config.DatabaseConfig;
import de.pontonconsulting.xmlpipe.config.SupportedDatabases;
import de.pontonconsulting.xmlpipe.messenger.database.AutoCloseableEntityManager;
import de.pontonconsulting.xmlpipe.messenger.database.ConnectionPool;
import de.pontonconsulting.xmlpipe.messenger.database.DBUpdateTools;
import de.pontonconsulting.xmlpipe.messenger.database.MessengerPersistenceUnitInfo;
import de.pontonconsulting.xmlpipe.util.IOUtil;
import jakarta.annotation.PostConstruct;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.annotations.TimeZoneStorageType;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.jpa.HibernatePersistenceProvider;

public class HibernateSessionFactory {
    private static final Logger _log = LogManager.getLogger((String)"Messenger.HibernateSessionFactory");
    private EntityManagerFactory _entityManagerFactory;
    public static final String CUSTOM_HIBERNATE_PROPERTIES_FILE = "hibernate.properties";
    private static SessionFactory _sessionFactory;
    private final DatabaseConfig databaseConfig;

    public HibernateSessionFactory(DatabaseConfig databaseConfig) {
        this.databaseConfig = databaseConfig;
    }

    @PostConstruct
    public void initSessionFactory() throws HibernateException {
        if (_sessionFactory == null || _sessionFactory.isClosed()) {
            this.initEntityManager();
        }
    }

    public void close() throws HibernateException {
        if (this._entityManagerFactory != null) {
            this._entityManagerFactory.close();
            this._entityManagerFactory = null;
        }
        if (_sessionFactory != null) {
            _sessionFactory.close();
            _sessionFactory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEntityManager() {
        try {
            DatabaseConnectionCheck databaseConnectionCheck;
            HashMap<String, Object> properties = new HashMap<String, Object>();
            String url = this.databaseConfig.getUrl();
            properties.put("hibernate.connection.url", url);
            String user = this.databaseConfig.getUsername();
            properties.put("hibernate.connection.username", user);
            String pass = this.databaseConfig.getPassword();
            properties.put("hibernate.connection.password", pass);
            properties.put("hibernate.id.sequence.increment_size_mismatch_strategy", "FIX");
            new DBUpdateTools(false, url, user, pass).updateDB();
            int timeout = 60000;
            DatabaseConnectionCheck databaseConnectionCheck2 = databaseConnectionCheck = new DatabaseConnectionCheck(url, user, pass);
            synchronized (databaseConnectionCheck2) {
                databaseConnectionCheck.start();
                databaseConnectionCheck.wait(60000L);
            }
            databaseConnectionCheck2 = databaseConnectionCheck;
            synchronized (databaseConnectionCheck2) {
                if (!databaseConnectionCheck.isClosed()) {
                    databaseConnectionCheck.interrupt();
                    _log.error("Could not open a database connection within 60 seconds.");
                    throw new IOException("Could not open a database connection within 60 seconds.");
                }
                if (!databaseConnectionCheck.getResult()) {
                    Exception exception = databaseConnectionCheck.getException();
                    if (exception != null) {
                        throw exception;
                    }
                } else if (databaseConnectionCheck.changeTransactionIsolationLevel()) {
                    properties.put("hibernate.connection.isolation", String.valueOf(2));
                    _log.info("Changed transaction isolation level to TRANSACTION_READ_COMMITTED.");
                }
            }
            properties.put("hibernate.connection.provider_class", ConnectionPool.class.getName());
            properties.put("hibernate.hikari.poolName", "XP_DB_ConnectionPool_" + String.valueOf(UUID.randomUUID()));
            properties.put("hibernate.hikari.idleTimeout", String.valueOf(this.databaseConfig.getConnectionTimeout() * 1000L));
            properties.put("hibernate.hikari.keepaliveTime", String.valueOf(60000));
            properties.put("hibernate.hikari.minimumIdle", String.valueOf(this.databaseConfig.getMinConnections()));
            properties.put("hibernate.hikari.maximumPoolSize", String.valueOf(this.databaseConfig.getMaxConnections()));
            properties.put("hibernate.id.new_generator_mappings", "true");
            properties.put("hibernate.timezone.default_storage", TimeZoneStorageType.NORMALIZE_UTC);
            this.setCustomHibernateProperties(properties);
            this._entityManagerFactory = new HibernatePersistenceProvider().createContainerEntityManagerFactory((PersistenceUnitInfo)new MessengerPersistenceUnitInfo(), properties);
            _sessionFactory = (SessionFactory)this._entityManagerFactory.unwrap(SessionFactory.class);
            Dialect dialect = ((SessionFactoryImpl)_sessionFactory).getJdbcServices().getDialect();
            _log.info("Database dialect used is: {}", (Object)dialect);
        }
        catch (Exception e) {
            throw new HibernateException("could not initialize database access: ", (Throwable)e);
        }
    }

    private void setCustomHibernateProperties(Map<String, Object> propertiesMap) {
        try {
            Properties properties = this.getCustomHibernateProperties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                propertiesMap.put(key, value);
                _log.warn("Overwritten the hibernate property '{}' with the value '{}'.", (Object)key, (Object)value);
            }
        }
        catch (IOException e) {
            _log.warn("Could not set custom hibernate properties: {}", (Object)e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getCustomHibernateProperties() throws IOException {
        Properties properties = new Properties();
        InputStream in = null;
        URL url = null;
        try {
            try {
                url = IOUtil.getResourceURL(CUSTOM_HIBERNATE_PROPERTIES_FILE, null);
            }
            catch (IOException e) {
                _log.debug(e.getMessage());
            }
            if (url != null) {
                _log.info("Found hibernate configuration file 'hibernate.properties': {}", (Object)url);
                in = url.openStream();
                properties.load(in);
            }
        }
        finally {
            IOUtil.closeStreamQuietly(in);
        }
        return properties;
    }

    public EntityManager createNewEntityManager() {
        return this.wrap(this._entityManagerFactory.createEntityManager());
    }

    private EntityManager wrap(EntityManager entityManager) {
        return new AutoCloseableEntityManager(entityManager);
    }

    private static class DatabaseConnectionCheck
    extends Thread {
        private Exception _exception;
        private volatile boolean _result = false;
        private volatile boolean _changeTransactionIsolationLevel = false;
        private volatile boolean _isClosed = false;
        private final String _url;
        private final String _user;
        private final String _pass;

        private DatabaseConnectionCheck(String url, String user, String pass) {
            this._url = url;
            this._user = user;
            this._pass = pass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DatabaseConnectionCheck databaseConnectionCheck = this;
            synchronized (databaseConnectionCheck) {
                _log.debug("try to connect to {} with user: {}", (Object)this._url, (Object)this._user);
                try (Connection conn = DriverManager.getConnection(this._url, this._user, this._pass);){
                    int usedTransactionIsolationLevel = conn.getTransactionIsolation();
                    if (2 != usedTransactionIsolationLevel && conn.getMetaData().supportsTransactionIsolationLevel(2)) {
                        this._changeTransactionIsolationLevel = true;
                    }
                    DatabaseMetaData meta = conn.getMetaData();
                    _log.info("connected to database: {}:{} {}:{}", (Object)meta.getDatabaseProductName(), (Object)meta.getDatabaseProductVersion(), (Object)meta.getDatabaseMajorVersion(), (Object)meta.getDatabaseMinorVersion());
                    _log.info("database driver: {}:{} {}:{}", (Object)meta.getDriverName(), (Object)meta.getDriverVersion(), (Object)meta.getDriverMajorVersion(), (Object)meta.getDriverMinorVersion());
                    SupportedDatabases.valueOf(meta.getDatabaseProductName(), meta.getDatabaseMajorVersion(), meta.getDatabaseMinorVersion());
                    this._result = true;
                }
                catch (IllegalArgumentException e) {
                    _log.warn("UNSUPPORTED DATABASE in use");
                    this._result = true;
                }
                catch (Exception e) {
                    _log.error("database connection test failed due to {}:{}", (Object)e.getClass().getName(), (Object)e.getMessage(), (Object)e);
                    this._exception = e;
                }
                this._isClosed = true;
                this.notifyAll();
            }
        }

        private Exception getException() {
            return this._exception;
        }

        private boolean isClosed() {
            return this._isClosed;
        }

        private boolean getResult() {
            return this._result;
        }

        public boolean changeTransactionIsolationLevel() {
            return this._changeTransactionIsolationLevel;
        }
    }
}

