/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database;

import de.pontonconsulting.xmlpipe.messenger.database.LogException;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.LogMessage;
import jakarta.persistence.EntityManager;
import java.util.Objects;
import java.util.function.Supplier;

public abstract class GenericLogChannel {
    private Supplier<EntityManager> _entityManagerSupplier;

    protected String getLogMessageText(int id) throws LogException {
        String result;
        block9: {
            result = "";
            try (EntityManager entityManager = this._entityManagerSupplier.get();){
                LogMessage lMessage = (LogMessage)entityManager.find(LogMessage.class, (Object)id);
                if (Objects.nonNull(lMessage)) {
                    result = lMessage.getText();
                    break block9;
                }
                throw new Exception("Could not find Log Message with the ID=" + id);
            }
            catch (Exception e) {
                Object msg = e.getMessage();
                msg = msg == null || ((String)msg).isEmpty() ? "." : ": " + (String)msg;
                msg = "Could not retrieve log messages from database" + (String)msg;
                LogException le = new LogException(14001, (String)msg);
                le.setStackTrace(e.getStackTrace());
                throw le;
            }
        }
        return result;
    }

    public void setEntityManagerSupplier(Supplier<EntityManager> _entityManagerSupplier) {
        this._entityManagerSupplier = _entityManagerSupplier;
    }
}

