/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database;

import de.pontonconsulting.xmlpipe.messenger.IMessageResources;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

public class EventLogEntry
implements Comparable<EventLogEntry> {
    private String _id;
    private long _timestamp;
    private String _component;
    private String _descriptionKey;
    private String[] _descriptionArgs;
    private String _description;
    private int _status;
    private String _location;
    private final SimpleDateFormat _dateFormatter;
    private IMessageResources _mr;
    private Locale _locale;

    public EventLogEntry(String id, long timestamp, String component, String descriptionKey, String description, int status) {
        this(id, timestamp, component, descriptionKey, new String[0], description, status, "");
    }

    public EventLogEntry(String id, long timestamp, String component, String descriptionKey, String description, int status, String location) {
        this(id, timestamp, component, descriptionKey, new String[0], description, status, location);
    }

    public EventLogEntry(String id, long timestamp, String component, String descriptionKey, String[] descArgs, String description, int status) {
        this(id, timestamp, component, descriptionKey, descArgs, description, status, "");
    }

    public EventLogEntry(String id, long timestamp, String component, String descriptionKey, String[] descArgs, String description, int status, String location) {
        this._id = id;
        this._timestamp = timestamp;
        this._component = component;
        this._descriptionKey = descriptionKey;
        this._descriptionArgs = descArgs;
        this._description = description;
        this._status = status;
        this._location = location;
        this._dateFormatter = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss'&nbsp;'z");
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public void setTimestamp(long timestamp) {
        this._timestamp = timestamp;
    }

    public String getFormattedTimestamp() {
        return this._dateFormatter.format(new Date(this._timestamp));
    }

    public String getComponent() {
        return this._component;
    }

    public void setComponent(String component) {
        this._component = component;
    }

    public String getI18NComponent() {
        String i18nComponent = this._mr.getMessage(this._locale, this._component);
        if (i18nComponent == null || i18nComponent.length() == 0) {
            i18nComponent = this._component;
        }
        return i18nComponent;
    }

    public String getDescriptionKey() {
        return this._descriptionKey;
    }

    public void setDescriptionKey(String descriptionKey) {
        this._descriptionKey = descriptionKey;
    }

    public String[] getDescriptionArgs() {
        return this._descriptionArgs;
    }

    public void getDescriptionArgs(String[] descArgs) {
        this._descriptionArgs = descArgs;
    }

    public String getI18NDescription() {
        Object[] args = new String[this._descriptionArgs.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this._mr.getMessage(this._locale, this._descriptionArgs[i]);
            if (args[i] != null) continue;
            args[i] = this._descriptionArgs[i];
        }
        Object i18nDesc = this._mr.getMessage(this._locale, this._descriptionKey, args);
        if (i18nDesc != null && this._description != null && this._description.length() > 0) {
            i18nDesc = (String)i18nDesc + " : " + this._description;
        } else if ((i18nDesc == null || ((String)i18nDesc).length() == 0) && this._description != null && this._description.length() > 0) {
            i18nDesc = this._description;
        }
        return i18nDesc;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public int getStatus() {
        return this._status;
    }

    public void setStatus(int status) {
        this._status = status;
    }

    public String getLocation() {
        return this._location;
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public void setPmrAndLocale(IMessageResources mr, Locale locale) {
        this._mr = mr;
        this._locale = locale;
    }

    @Override
    public int compareTo(EventLogEntry eventLogEntry) {
        return (int)(this.getTimestamp() - eventLogEntry.getTimestamp());
    }

    public boolean equals(Object object) {
        if (object instanceof EventLogEntry) {
            return this._id.equals(((EventLogEntry)object).getId());
        }
        return false;
    }

    public String toString() {
        return "EventLogEntry [_id=" + this._id + ", _timestamp=" + this._timestamp + ", _component=" + this._component + ", _descriptionKey=" + this._descriptionKey + ", _descriptionArgs=" + Arrays.toString(this._descriptionArgs) + ", _description=" + this._description + ", _status=" + this._status + ", _location=" + this._location + ", _dateFormatter=" + String.valueOf(this._dateFormatter) + ", _mr=" + String.valueOf(this._mr) + ", _locale=" + String.valueOf(this._locale) + "]";
    }
}

