/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.hikaricp.internal.HikariConfigurationUtil;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;

public class ConnectionPool
implements ConnectionProvider,
Stoppable,
Configurable {
    private static Log log;
    private static HikariDataSource pooled;
    private int isolationLevel;

    public ConnectionPool() {
        if (log == null) {
            log = LogFactory.getFactory().getInstance("JDBC.ConnectionPool");
        }
        if (pooled != null) {
            pooled.close();
            pooled = null;
        }
    }

    public static int getNumConnections() throws SQLException {
        if (pooled == null) {
            throw new SQLException("Connection pool is not initialized.");
        }
        return pooled.getHikariPoolMXBean().getTotalConnections();
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return ConnectionProvider.class.equals((Object)unwrapType) || ConnectionPool.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || ConnectionPool.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public static int getNumBusyConnections() throws SQLException {
        if (pooled == null) {
            throw new SQLException("Connection pool is not initialized.");
        }
        return pooled.getHikariPoolMXBean().getActiveConnections();
    }

    public static DataSource getDataSource() {
        return pooled;
    }

    public static int getNumIdleConnections() throws SQLException {
        if (pooled == null) {
            throw new SQLException("Connection pool is not initialized.");
        }
        return pooled.getHikariPoolMXBean().getIdleConnections();
    }

    public static int getNumUnclosedOrphanedConnections() throws SQLException {
        if (pooled == null) {
            throw new SQLException("Connection pool is not initialized.");
        }
        return 0;
    }

    public Connection getConnection() throws SQLException {
        if (pooled == null) {
            throw new SQLException("Connection pool is not initialized.");
        }
        Connection connection = pooled.getConnection();
        int actualTransactionIsolationLevel = connection.getTransactionIsolation();
        if (actualTransactionIsolationLevel != this.isolationLevel) {
            connection.setTransactionIsolation(this.isolationLevel);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Changed transaction isolation level from " + ConnectionProviderInitiator.toIsolationNiceName((Integer)actualTransactionIsolationLevel) + " to " + ConnectionProviderInitiator.toIsolationNiceName((Integer)this.isolationLevel) + "."));
            }
        }
        return connection;
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public void configure(Map configurationValues) {
        String jdbcUrl = ConfigurationHelper.extractPropertyValue((String)"hibernate.connection.url", (Map)configurationValues);
        log.info((Object)("HikariCP connecting to URL: " + jdbcUrl));
        Properties connectionProps = ConnectionProviderInitiator.getConnectionProperties((Map)configurationValues);
        log.info((Object)ConfigurationHelper.maskOut((Properties)connectionProps, (String)"password"));
        boolean autocommit = ConfigurationHelper.getBoolean((String)"hibernate.connection.autocommit", (Map)configurationValues);
        log.info((Object)("autocommit mode: " + autocommit));
        try {
            HikariConfig hikariConfig = HikariConfigurationUtil.loadConfiguration((Map)configurationValues);
            pooled = new HikariDataSource(hikariConfig);
            Connection con = pooled.getConnection();
            this.isolationLevel = con.getTransactionIsolation();
            log.info((Object)("Default transaction isolation level is " + ConnectionProviderInitiator.toIsolationNiceName((Integer)this.isolationLevel)));
            con.close();
        }
        catch (Exception e) {
            log.fatal((Object)"could not instantiate Hikari connection pool", (Throwable)e);
            throw new HibernateException("Could not instantiate Hikari connection pool", (Throwable)e);
        }
        Integer isolation = ConfigurationHelper.getInteger((String)"hibernate.connection.isolation", (Map)configurationValues);
        if (isolation != null) {
            this.isolationLevel = isolation;
            log.info((Object)("Set transaction isolation level to " + ConnectionProviderInitiator.toIsolationNiceName((Integer)this.isolationLevel)));
        }
    }

    public void stop() {
        pooled.close();
    }
}

