/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.database;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Query;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.metamodel.Metamodel;
import java.util.List;
import java.util.Map;

public class AutoCloseableEntityManager
implements EntityManager {
    private final EntityManager entityManager;

    public AutoCloseableEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void persist(Object entity) {
        this.entityManager.persist(entity);
    }

    public <T> T merge(T entity) {
        return (T)this.entityManager.merge(entity);
    }

    public void remove(Object entity) {
        this.entityManager.remove(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)this.entityManager.find(entityClass, primaryKey);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return (T)this.entityManager.find(entityClass, primaryKey, properties);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        return (T)this.entityManager.find(entityClass, primaryKey, lockMode);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        return (T)this.entityManager.find(entityClass, primaryKey, lockMode, properties);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return (T)this.entityManager.getReference(entityClass, primaryKey);
    }

    public void flush() {
        this.entityManager.flush();
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.entityManager.setFlushMode(flushMode);
    }

    public FlushModeType getFlushMode() {
        return this.entityManager.getFlushMode();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.entityManager.lock(entity, lockMode);
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.entityManager.lock(entity, lockMode, properties);
    }

    public void refresh(Object entity) {
        this.entityManager.refresh(entity);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.entityManager.refresh(entity, properties);
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.entityManager.refresh(entity, lockMode);
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.entityManager.refresh(entity, lockMode, properties);
    }

    public void clear() {
        this.entityManager.clear();
    }

    public void detach(Object entity) {
        this.entityManager.detach(entity);
    }

    public boolean contains(Object entity) {
        return this.entityManager.contains(entity);
    }

    public LockModeType getLockMode(Object entity) {
        return this.entityManager.getLockMode(entity);
    }

    public void setProperty(String propertyName, Object value) {
        this.entityManager.setProperty(propertyName, value);
    }

    public Map<String, Object> getProperties() {
        return this.entityManager.getProperties();
    }

    public Query createQuery(String qlString) {
        return this.entityManager.createQuery(qlString);
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        return this.entityManager.createQuery(criteriaQuery);
    }

    public Query createQuery(CriteriaUpdate updateQuery) {
        return this.entityManager.createQuery(updateQuery);
    }

    public Query createQuery(CriteriaDelete deleteQuery) {
        return this.entityManager.createQuery(deleteQuery);
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        return this.entityManager.createQuery(qlString, resultClass);
    }

    public Query createNamedQuery(String name) {
        return this.entityManager.createNamedQuery(name);
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        return this.entityManager.createNamedQuery(name, resultClass);
    }

    public Query createNativeQuery(String sqlString) {
        return this.entityManager.createNativeQuery(sqlString);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        return this.entityManager.createNativeQuery(sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        return this.entityManager.createNativeQuery(sqlString, resultSetMapping);
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        return this.entityManager.createNamedStoredProcedureQuery(name);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        return this.entityManager.createStoredProcedureQuery(procedureName);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        return this.entityManager.createStoredProcedureQuery(procedureName, resultClasses);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        return this.entityManager.createStoredProcedureQuery(procedureName, resultSetMappings);
    }

    public void joinTransaction() {
        this.entityManager.joinTransaction();
    }

    public boolean isJoinedToTransaction() {
        return this.entityManager.isJoinedToTransaction();
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.entityManager.unwrap(cls);
    }

    public Object getDelegate() {
        return this.entityManager.getDelegate();
    }

    public void close() {
        try {
            EntityTransaction transaction = this.entityManager.getTransaction();
            if (transaction.isActive()) {
                transaction.rollback();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.entityManager.close();
    }

    public boolean isOpen() {
        return this.entityManager.isOpen();
    }

    public EntityTransaction getTransaction() {
        return this.entityManager.getTransaction();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManager.getEntityManagerFactory();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.entityManager.getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.entityManager.getMetamodel();
    }

    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        return this.entityManager.createEntityGraph(rootType);
    }

    public EntityGraph<?> createEntityGraph(String graphName) {
        return this.entityManager.createEntityGraph(graphName);
    }

    public EntityGraph<?> getEntityGraph(String graphName) {
        return this.entityManager.getEntityGraph(graphName);
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        return this.entityManager.getEntityGraphs(entityClass);
    }
}

