/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.archive;

import de.pontonconsulting.xmlpipe.messenger.archive.ArchiverException;
import de.pontonconsulting.xmlpipe.messenger.archive.IArchiver;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageArchiveDataDAO;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DeflaterInputStream;
import java.util.zip.InflaterOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatabaseArchiver
implements IArchiver {
    private static final Logger log = LogManager.getLogger((String)"Messenger.DatabaseArchiver");
    private final MessageArchiveDataDAO messageArchiveDataDAO;

    public DatabaseArchiver(MessageArchiveDataDAO messageArchiveDataDAO) {
        this.messageArchiveDataDAO = messageArchiveDataDAO;
    }

    @Override
    public List<IArchiver.ArchiveResponse> sendFilesToArchive(MessageInfo messageInfo, boolean isFailedMessage, List<IArchiver.File2Archive> files2archive) throws ArchiverException {
        ArrayList<IArchiver.ArchiveResponse> responses = new ArrayList<IArchiver.ArchiveResponse>();
        for (IArchiver.File2Archive file2Archive : files2archive) {
            try {
                String referenceID = this.messageArchiveDataDAO.storeMessageArchiveData(new DeflaterInputStream(file2Archive.inputStream()), messageInfo.getTimestamp());
                responses.add(new IArchiver.ArchiveResponse(referenceID, file2Archive.fileName(), file2Archive.fileType()));
            }
            catch (Exception e) {
                throw new ArchiverException(e.getMessage(), e);
            }
        }
        return responses;
    }

    @Override
    public void readFileFromArchive(String archiveReference, OutputStream outputStream) throws ArchiverException {
        try {
            log.debug("Reading archive file: {}", (Object)archiveReference);
            this.messageArchiveDataDAO.readMessageArchiveFromDB(archiveReference, new InflaterOutputStream(outputStream));
        }
        catch (Exception e) {
            throw new ArchiverException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteFileFromArchive(List<String> archiveReferences2delete) throws ArchiverException {
        try {
            for (String archiveReference : archiveReferences2delete) {
                this.messageArchiveDataDAO.deleteMessageArchiveDataById(archiveReference);
            }
        }
        catch (Exception e) {
            throw new ArchiverException(e.getMessage(), e);
        }
    }
}

