/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger.adapter;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;

public class HttpResponseListener
implements Response.CompleteListener,
Response.ContentListener {
    private static final Log _log = LogFactory.getFactory().getInstance("Messenger.HttpResponseListener");
    private final AtomicReference<Response> responseRef = new AtomicReference();
    private final CountDownLatch latch = new CountDownLatch(1);
    private final long timeout;
    private final TimeUnit timeUnit;
    private String contentAsString;

    public HttpResponseListener(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    public String getContentAsString() throws InterruptedException {
        if (!this.latch.await(this.timeout, this.timeUnit)) {
            _log.error((Object)"did not get a response within timeout");
        }
        return this.contentAsString;
    }

    public Response getResponse() throws InterruptedException {
        if (!this.latch.await(this.timeout, this.timeUnit)) {
            _log.error((Object)"did not get a response within timeout");
        }
        return this.responseRef.get();
    }

    public void onComplete(Result result) {
        if (result.isSucceeded()) {
            this.responseRef.set(result.getResponse());
            this.latch.countDown();
        }
    }

    public void onContent(Response response, ByteBuffer content) {
        Charset encoding = this.getEncoding(response);
        this.contentAsString = encoding.decode(content).toString();
    }

    private Charset getEncoding(Response response) {
        String encodingString = null;
        HttpFields headers = response.getHeaders();
        String contentType = headers.get(HttpHeader.CONTENT_TYPE);
        if (contentType != null) {
            String charset = "charset=";
            int index = contentType.toLowerCase(Locale.ENGLISH).indexOf(charset);
            if (index > 0) {
                encodingString = contentType.substring(index + charset.length());
                int semicolon = encodingString.indexOf(59);
                if (semicolon > 0) {
                    encodingString = encodingString.substring(0, semicolon).trim();
                }
                int lastIndex = encodingString.length() - 1;
                if (encodingString.charAt(0) == '\"' && encodingString.charAt(lastIndex) == '\"') {
                    encodingString = encodingString.substring(1, lastIndex).trim();
                }
            }
        }
        Charset encoding = StandardCharsets.UTF_8;
        if (encodingString != null) {
            try {
                encoding = Charset.forName(encodingString);
            }
            catch (Exception e) {
                _log.warn((Object)("Invalid encoding '" + encodingString + "' -> using UTF-8"));
            }
        }
        return encoding;
    }
}

