/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger;

import de.pontonconsulting.common.io.UTF8BOMSkippingInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax2.XMLStreamReader2;

public class XmlMetaData {
    private static final String XMLSCHEMA_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String SCHEMALOCATION = "schemaLocation";
    private static final String NO_NAMESPACE_SCHEMALOCATION = "noNamespaceSchemaLocation";
    private final File _file;
    private String _namespaceUri;
    private String _systemId;
    private String _schemaLocation;
    private String _rootElementName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlMetaData(File xmlFile) throws XMLStreamException, IOException {
        this._file = xmlFile;
        XMLStreamReader reader = null;
        UTF8BOMSkippingInputStream in = null;
        try {
            in = new UTF8BOMSkippingInputStream(new BufferedInputStream(Files.newInputStream(this._file.toPath(), new OpenOption[0])));
            XMLInputFactory f = XMLInputFactory.newInstance();
            f.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
            f.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
            f.setProperty("javax.xml.stream.reporter", null);
            reader = f.createXMLStreamReader(in);
            boolean rootFound = false;
            while (reader.hasNext() && !rootFound) {
                block5 : switch (reader.getEventType()) {
                    case 1: {
                        if (!rootFound) {
                            rootFound = true;
                        }
                        this._rootElementName = reader.getLocalName();
                        if (reader.getNamespaceURI() != null && !"".equals(reader.getNamespaceURI())) {
                            this._namespaceUri = reader.getNamespaceURI();
                        }
                        for (int i = 0; i < reader.getAttributeCount(); ++i) {
                            if (XMLSCHEMA_NAMESPACE_URI.equals(reader.getAttributeNamespace(i)) && NO_NAMESPACE_SCHEMALOCATION.equals(reader.getAttributeLocalName(i))) {
                                this._schemaLocation = reader.getAttributeValue(i);
                                break block5;
                            }
                            if (!XMLSCHEMA_NAMESPACE_URI.equals(reader.getAttributeNamespace(i)) || !SCHEMALOCATION.equals(reader.getAttributeLocalName(i))) continue;
                            this._schemaLocation = reader.getAttributeValue(i);
                            break block5;
                        }
                        break;
                    }
                    case 11: {
                        String doctype = reader.getText();
                        if (reader instanceof XMLStreamReader2) {
                            this._systemId = ((XMLStreamReader2)reader).getDTDInfo().getDTDSystemId();
                            break;
                        }
                        Pattern pattern = Pattern.compile("[\\\"\\'].*[dD][tT][dD]");
                        Matcher matcher = pattern.matcher(doctype);
                        if (matcher.find()) {
                            this._systemId = matcher.group().substring(1);
                            break;
                        }
                        this._systemId = null;
                        break;
                    }
                }
                reader.next();
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    public String getNamespaceUri() {
        return this._namespaceUri;
    }

    public String getRootElementName() {
        return this._rootElementName;
    }

    public String getSchemaLocation() {
        return this._schemaLocation;
    }

    public String getSystemId() {
        return this._systemId;
    }

    public File getFile() {
        return this._file;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this._namespaceUri != null) {
            str.append("'");
            str.append(this._namespaceUri);
            str.append("' - ");
        }
        if (this._schemaLocation != null) {
            str.append("'");
            str.append(this._schemaLocation);
            str.append("' - ");
        }
        if (this._systemId != null) {
            str.append("'");
            str.append(this._systemId);
            str.append("' - ");
        }
        if (this._rootElementName != null) {
            str.append("'");
            str.append(this._rootElementName);
            str.append("' - ");
        }
        return str.toString();
    }
}

