/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger;

import com.codahale.metrics.Timer;
import de.ponton.xmlpipe.metrics.MetricsService;
import de.ponton.xmlpipe.metrics.XPMetrics;
import de.ponton.xmlpipe.queue.OutboundQueue;
import de.pontonconsulting.common.activation.MimeTypeMapper;
import de.pontonconsulting.xmlpipe.adapter.TransportURLType;
import de.pontonconsulting.xmlpipe.config.IFolders;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpa.CommunicationNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.ProfileNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.PayloadDataExtractor;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.messenger.IPipelineFactory;
import de.pontonconsulting.xmlpipe.messenger.IdGenerator;
import de.pontonconsulting.xmlpipe.messenger.Pipeline;
import de.pontonconsulting.xmlpipe.messenger.SendToListenerResult;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import de.pontonconsulting.xmlpipe.messenger.database.tables.FileRefDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MDNDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.MessageRecognitionException;
import de.pontonconsulting.xmlpipe.messenger.filter.compress.CompressionException;
import de.pontonconsulting.xmlpipe.messenger.filter.crypt.CryptException;
import de.pontonconsulting.xmlpipe.messenger.filter.sign.SignatureException;
import de.pontonconsulting.xmlpipe.messenger.filter.validate.ValidationException;
import de.pontonconsulting.xmlpipe.messenger.filter.validate.ValidationResult;
import de.pontonconsulting.xmlpipe.messenger.transport.BaseTransportProvider;
import de.pontonconsulting.xmlpipe.messenger.transport.TransportProviderFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.FileSystemUtils;

public class SendToListener {
    public static final String OVERWRITE_MESSAGE_ID = "OverwriteMessageId";
    private static final String PROPERTY_RFC2822_CONFORM_MESSAGE_ID = "ponton.rfc2822.conform.message.id";
    private static final String DEFAULT_RFC2822_CONFORM_MESSAGE_ID = "true";
    private static final String UNKNOWN = "unknown";
    private static final Logger _log = LogManager.getLogger((String)"Messenger.SendToListener");
    private final Agreements _agreements;
    private final Profiles _profiles;
    private final MessengerLog _messengerLog;
    private final IPipelineFactory _pipelineFactory;
    private final ArchiveProcessor _archiveProcessor;
    private final TransportProviderFactory _transportProviderFactory;
    private final MessageDAO _messageDAO;
    private final FileRefDAO _fileRefDAO;
    private final MDNDataDAO _mdnDataDAO;
    private final OutboundQueue _outboundMessageQueue;
    private final MessengerConfig _messengerConfig;
    private final IFolders _folders;
    private final IdGenerator _idGenerator;
    private final PayloadDataExtractor payloadDataExtractor;
    private final IMessengerProperties messengerProperties;
    private final MetricsService metricsService;
    private final MessageWorkDataDAO messageWorkDataDAO;

    public SendToListener(Agreements agreements, Profiles profiles, MessengerLog messengerLog, IPipelineFactory pipelineFactory, ArchiveProcessor archiveProcessor, TransportProviderFactory transportProviderFactory, MessageDAO messageDAO, FileRefDAO fileRefDAO, MDNDataDAO mdnDataDAO, OutboundQueue outboundMessageQueue, MessengerConfig messengerConfig, IFolders folders, IdGenerator idGenerator, PayloadDataExtractor payloadDataExtractor, IMessengerProperties messengerProperties, MetricsService metricsService, MessageWorkDataDAO messageWorkDataDAO) {
        this._agreements = agreements;
        this._profiles = profiles;
        this._messengerLog = messengerLog;
        this._pipelineFactory = pipelineFactory;
        this._archiveProcessor = archiveProcessor;
        this._transportProviderFactory = transportProviderFactory;
        this._messageDAO = messageDAO;
        this._fileRefDAO = fileRefDAO;
        this._mdnDataDAO = mdnDataDAO;
        this._outboundMessageQueue = outboundMessageQueue;
        this._messengerConfig = messengerConfig;
        this._folders = folders;
        this._idGenerator = idGenerator;
        this.payloadDataExtractor = payloadDataExtractor;
        this.messengerProperties = messengerProperties;
        this.metricsService = metricsService;
        this.messageWorkDataDAO = messageWorkDataDAO;
        if (_log.isDebugEnabled()) {
            _log.debug("new instance of SendToListener created.");
        }
    }

    public SendToListenerResult handleMessage(XpMessage xpMessage) throws MessageRecognitionException {
        SendToListenerResult sendToListenerResult;
        try (Timer.Context adapterQueueTimer = this.metricsService.getTimer(XPMetrics.MESSAGES_OUTBOUND_ADAPTER_QUEUE_TIME).time();){
            sendToListenerResult = this.handleMessage(xpMessage, -1L);
        }
        return sendToListenerResult;
    }

    public SendToListenerResult handleMessage(XpMessage xpMessage, long oldDatabaseId) throws MessageRecognitionException {
        SendToListenerResult errorResultFromPipeline;
        String localReceiver;
        String localSender;
        String internalReceiver;
        block62: {
            xpMessage.setMessengerId(this._messengerConfig.getMessengerId());
            if (!"ponton".equals(xpMessage.getSchemaSet())) {
                this.payloadDataExtractor.extractData(xpMessage);
                if (Objects.isNull(xpMessage.getCurrentContentType()) && Objects.nonNull(xpMessage.getCurrentContentReference())) {
                    xpMessage.setCurrentContentType(MimeTypeMapper.getMimeType(xpMessage.getCurrentContentReference().getName()));
                }
            }
            this.generateMessageIdIfNotDefined(xpMessage);
            if (this.isRFC2822MessageId()) {
                xpMessage.setMessageId(this._idGenerator.getStandardMessageId(xpMessage.getMessageId()));
            }
            if (xpMessage.getConversationId() == null || xpMessage.getConversationId().isEmpty()) {
                xpMessage.setConversationId(xpMessage.getMessageId());
            }
            try {
                boolean sequenceDuplicate;
                int messageStatus;
                this._messageDAO.updateOrCreateConversation(xpMessage);
                boolean isNewMessage = this._messageDAO.updateMessageAndStatus(xpMessage, 0, 1);
                if (isNewMessage) {
                    messageStatus = 0;
                    if (oldDatabaseId == -1L) {
                        _log.info("New message from adapter registered with Message ID: '{}' database id: '{}'", (Object)xpMessage.getMessageId(), (Object)xpMessage.getDatabaseId());
                    } else {
                        _log.info("Message [{}] was resent.", (Object)oldDatabaseId);
                        try {
                            MessageInfo originalMSG = this._messageDAO.getMessageInfo(oldDatabaseId);
                            if (originalMSG != null) {
                                this._messengerLog.log2dbWithHref(214, xpMessage.getDatabaseId(), originalMSG.getMessageId(), originalMSG.getMessageId(), originalMSG.getDatabaseId(), originalMSG.isInbound());
                                this._messengerLog.log2dbWithHref(214, originalMSG.getDatabaseId(), xpMessage.getMessageId(), xpMessage.getMessageId(), xpMessage.getDatabaseId(), xpMessage.isInbound());
                            }
                        }
                        catch (DbException e) {
                            _log.error("Could not get original message [{}] for the resent message: {}", (Object)oldDatabaseId, (Object)e.getMessage());
                        }
                    }
                } else {
                    messageStatus = this._messageDAO.getStatusOfMessage(xpMessage.getMessageId(), 0);
                }
                if (xpMessage.getInternalSequenceNumber() > -1L && (sequenceDuplicate = this._messageDAO.isSequenceDuplicated(xpMessage.getDatabaseId(), xpMessage.getInternalSequenceNumber(), xpMessage.getConversationDatabaseId(), 0))) {
                    _log.warn("Send rejected because another successful message in the same conversation already uses sequence number {}", (Object)xpMessage.getInternalSequenceNumber());
                    this._messengerLog.log2db(515, xpMessage.getDatabaseId(), "Duplicate Sequence Number");
                    this.saveFailedMessage(xpMessage);
                    return new SendToListenerResult(SendToListenerResult.Result.DUPLICATE_SEQUENCE_NUMBER, xpMessage);
                }
                if (messageStatus == 0) {
                    try {
                        this.moveWorkFolder(xpMessage);
                        break block62;
                    }
                    catch (IOException io) {
                        _log.error("Can't move work folder", (Throwable)io);
                        return new SendToListenerResult(SendToListenerResult.Result.COULD_NOT_SAVE_MESSAGE_PAYLOAD, xpMessage);
                    }
                }
                if (messageStatus == 3) {
                    String errorMsg = "Send rejected because a message with the same Message ID (" + xpMessage.getMessageId() + ") was already successfully sent";
                    _log.warn(errorMsg);
                    this._messengerLog.log2db(515, xpMessage.getDatabaseId(), errorMsg);
                    this.saveFailedMessage(xpMessage);
                    return new SendToListenerResult(SendToListenerResult.Result.DUPLICATE_MESSAGE_ID, xpMessage);
                }
                if (messageStatus == 5) {
                    if (_log.isInfoEnabled()) {
                        _log.info("Sending archived message with Message ID: {}", (Object)xpMessage.getMessageId());
                    }
                    try {
                        this.deleteArchivedFolder(xpMessage);
                        this.moveWorkFolder(xpMessage);
                        break block62;
                    }
                    catch (IOException io) {
                        _log.error("Can't delete archive- or move work folder", (Throwable)io);
                        return new SendToListenerResult(SendToListenerResult.Result.COULD_NOT_SAVE_MESSAGE_PAYLOAD, xpMessage);
                    }
                }
                if (messageStatus == 4) {
                    long existingDatabaseId;
                    boolean updated;
                    if (_log.isInfoEnabled()) {
                        _log.info("Resending failed message with Message ID: {}", (Object)xpMessage.getMessageId());
                    }
                    if (updated = this._messageDAO.updateMessageStatus(existingDatabaseId = this._messageDAO.getMessageDataID(xpMessage.getMessageId(), 0), 4, 1)) {
                        if (existingDatabaseId != xpMessage.getDatabaseId()) {
                            this._messengerLog.deleteLogs(xpMessage.getDatabaseId());
                            this._messageDAO.deleteFromMessage(xpMessage.getDatabaseId());
                            this._messengerLog.log2db(68, existingDatabaseId, xpMessage.getAdapterId());
                            xpMessage.setDatabaseId(existingDatabaseId);
                        }
                        this._messageDAO.updateMessageTimeStamp(xpMessage.getDatabaseId());
                        this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), xpMessage.getMessageId(), 1);
                        this._messageDAO.updateSequenceInfo(xpMessage);
                        try {
                            this.moveWorkFolder(xpMessage);
                        }
                        catch (IOException io) {
                            _log.error("Can't delete archive- or move work folder", (Throwable)io);
                            return new SendToListenerResult(SendToListenerResult.Result.COULD_NOT_SAVE_MESSAGE_PAYLOAD, xpMessage);
                        }
                        try {
                            int delCount = this._mdnDataDAO.deleteMDNData(xpMessage.getDatabaseId());
                            if (delCount > 0) {
                                _log.trace("Deleted old MDNData of message '{}'", (Object)xpMessage.getMessageId());
                            }
                            break block62;
                        }
                        catch (DbException e) {
                            _log.error("could not delete MDN data from database.{}", (Object)e.getMessage());
                        }
                        break block62;
                    }
                    String errorMsg = "Send rejected because a message with the same Message ID is still in transit: " + xpMessage.getMessageId();
                    _log.warn(errorMsg);
                    this._messengerLog.log2db(515, xpMessage.getDatabaseId(), errorMsg);
                    this.saveFailedMessage(xpMessage);
                    return new SendToListenerResult(SendToListenerResult.Result.PENDING_MESSAGE_ID, xpMessage);
                }
                String errorMsg = "Send rejected because a message with the same Message ID is still in transit: " + xpMessage.getMessageId();
                _log.warn(errorMsg);
                this._messengerLog.log2db(515, xpMessage.getDatabaseId(), errorMsg);
                this.saveFailedMessage(xpMessage);
                return new SendToListenerResult(SendToListenerResult.Result.PENDING_MESSAGE_ID, xpMessage);
            }
            catch (DbException de) {
                _log.fatal(de.toString(), (Throwable)de);
                if (xpMessage.getDatabaseId() != -1L) {
                    this._messengerLog.log2db(515, xpMessage.getDatabaseId(), "database problem");
                    this.saveFailedMessage(xpMessage);
                }
                return new SendToListenerResult(SendToListenerResult.Result.COULD_NOT_SAVE_MESSAGE_PAYLOAD, xpMessage, de);
            }
        }
        String internalSender = xpMessage.getSenderInternalId();
        if (internalSender == null) {
            internalSender = UNKNOWN;
        }
        if ((internalReceiver = xpMessage.getReceiverInternalId()) == null) {
            internalReceiver = UNKNOWN;
        }
        try {
            CppPartner sender = this.fetchSenderProfile(xpMessage);
            localSender = sender.getLocalId();
            xpMessage.setSenderLocalId(localSender);
            if (sender.isDisabled()) {
                this._messengerLog.log2db(527, xpMessage.getDatabaseId(), "Sender Internal-Id '" + internalSender + "' is disabled:");
                this.moveMessageFilesToDB(xpMessage);
                this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
                this.saveFailedMessage(xpMessage);
                _log.warn("Partner '{}' is disabled", (Object)internalSender);
                return new SendToListenerResult(SendToListenerResult.Result.PARTNER_IS_DISABLED, xpMessage, "Sender Internal-Id: " + internalSender);
            }
            if (sender.isRemote()) {
                this._messengerLog.log2db(527, xpMessage.getDatabaseId(), "Sender Internal-Id '" + internalSender + "' is not a local partner");
                this.moveMessageFilesToDB(xpMessage);
                this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
                this.saveFailedMessage(xpMessage);
                _log.fatal("Sender with Internal-Id '{}' is not a local partner", (Object)internalSender);
                return new SendToListenerResult(SendToListenerResult.Result.SENDER_IS_NOT_A_LOCAL_PARTNER, xpMessage, "Sender Internal-Id: " + internalSender);
            }
        }
        catch (ProfileNotFoundException pnfe) {
            this._messengerLog.log2db(527, xpMessage.getDatabaseId(), "Sender Internal-Id '" + internalSender + "' is unknown:");
            this.moveMessageFilesToDB(xpMessage);
            this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
            this.saveFailedMessage(xpMessage);
            _log.fatal("Sender is unknown. Internal-Id:{}", (Object)internalSender);
            return new SendToListenerResult(SendToListenerResult.Result.PARTNER_IS_NOT_KNOWN, xpMessage, "Sender Internal-Id: " + internalSender);
        }
        catch (ProfileException pe) {
            this._messengerLog.log2db(527, xpMessage.getDatabaseId(), "Partner config for '" + internalSender + "' could not be accessed:");
            this.moveMessageFilesToDB(xpMessage);
            this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
            this.saveFailedMessage(xpMessage);
            _log.fatal("Error while getting sender partner data:{}", (Object)pe.getMessage(), (Object)(_log.isDebugEnabled() ? pe : null));
            return new SendToListenerResult(SendToListenerResult.Result.PARTNER_STORE_COULD_NOT_BE_ACCESSED, xpMessage, pe);
        }
        try {
            CppPartner receiver = this.fetchReceiverProfile(xpMessage);
            localReceiver = receiver.getLocalId();
            xpMessage.setReceiverLocalId(localReceiver);
            if (receiver.isDisabled()) {
                this._messengerLog.log2db(527, xpMessage.getDatabaseId(), "Receiver Internal-Id '" + internalReceiver + "' is disabled");
                this.moveMessageFilesToDB(xpMessage);
                this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
                this.saveFailedMessage(xpMessage);
                _log.warn("Partner '{}' is disabled", (Object)internalReceiver);
                return new SendToListenerResult(SendToListenerResult.Result.PARTNER_IS_DISABLED, xpMessage, "Receiver Internal-Id: " + internalReceiver);
            }
            if (!this._messengerConfig.isLoopback() && !receiver.isRemote()) {
                this._messengerLog.log2db(527, xpMessage.getDatabaseId(), "Receiver Internal-Id '" + internalReceiver + "' is not a remote partner");
                this.moveMessageFilesToDB(xpMessage);
                this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
                this.saveFailedMessage(xpMessage);
                _log.fatal("Receiver with Internal-Id '{}' is not a remote partner", (Object)internalReceiver);
                return new SendToListenerResult(SendToListenerResult.Result.RECEIVER_IS_NOT_A_REMOTE_PARTNER, xpMessage, "Receiver is not a local partner: " + internalReceiver);
            }
        }
        catch (ProfileNotFoundException pnfe) {
            this._messengerLog.log2db(527, xpMessage.getDatabaseId(), "Receiver Internal-Id '" + internalReceiver + "' is unknown:");
            this.moveMessageFilesToDB(xpMessage);
            this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
            this.saveFailedMessage(xpMessage);
            _log.fatal("Receiver is unknown:{}", (Object)internalReceiver);
            return new SendToListenerResult(SendToListenerResult.Result.PARTNER_IS_NOT_KNOWN, xpMessage, "Receiver Internal-Id: " + internalReceiver);
        }
        catch (ProfileException pe) {
            this._messengerLog.log2db(527, xpMessage.getDatabaseId(), "Partner config for '" + internalReceiver + "' could not be accessed:");
            this.moveMessageFilesToDB(xpMessage);
            this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
            this.saveFailedMessage(xpMessage);
            if (_log.isDebugEnabled()) {
                _log.fatal("Error while getting receiver partner data:{}", (Object)pe.getMessage(), (Object)pe);
            } else {
                _log.fatal("Error while getting receiver partner data:{}", (Object)pe.getMessage());
            }
            return new SendToListenerResult(SendToListenerResult.Result.PARTNER_STORE_COULD_NOT_BE_ACCESSED, xpMessage, pe);
        }
        try {
            if (_log.isDebugEnabled()) {
                _log.debug("Fetching collaboration agreement for sender: {} and receiver: {}", (Object)internalSender, (Object)internalReceiver);
            }
            Agreement agreement = this._agreements.getAgreement(localSender, localReceiver, true);
            xpMessage.setAgreement(agreement);
            xpMessage.setOwnPartner(this._profiles.getProfileForLocalId(agreement.getOwnPartner().getId(), true));
            xpMessage.setCommunicationPartner(this._profiles.getProfileForLocalId(agreement.getCommunicationPartner().getId(), true));
        }
        catch (AgreementException anfe) {
            this._messengerLog.log2db(527, xpMessage.getDatabaseId(), "No collaboration agreement for sender '" + internalSender + "' and receiver '" + internalReceiver + "' found.");
            this.moveMessageFilesToDB(xpMessage);
            this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
            this.saveFailedMessage(xpMessage);
            _log.fatal("No collaboration agreement for sender '{}' and receiver '{}' found.", (Object)internalSender, (Object)internalReceiver);
            return new SendToListenerResult(SendToListenerResult.Result.NO_AGREEMENT_FOUND, xpMessage, "Sender Internal-Id: " + internalSender + " Receiver Internal-Id: " + internalReceiver);
        }
        catch (ProfileException e) {
            this._messengerLog.log2db(527, xpMessage.getDatabaseId(), "Partner Profile not found: " + e.getMessage());
            this.moveMessageFilesToDB(xpMessage);
            this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
            this.saveFailedMessage(xpMessage);
            _log.fatal("Partner Profile not found: {}", (Object)e.getMessage(), (Object)e);
            return new SendToListenerResult(SendToListenerResult.Result.PARTNER_IS_NOT_KNOWN, xpMessage, "Partner Profile not found: " + e.getMessage());
        }
        if (xpMessage.isAck()) {
            xpMessage.setAckRequested(false);
        }
        Communication communication = null;
        try {
            communication = xpMessage.getAgreement().getCommunication(localSender, localReceiver);
            xpMessage.setCommunication(communication);
        }
        catch (CommunicationNotFoundException cnfe) {
            this._messengerLog.log2db(527, xpMessage.getDatabaseId(), "No communication defined in collaboration agreement for sender '" + internalSender + "' and receiver '" + internalReceiver + "' found.");
            this.moveMessageFilesToDB(xpMessage);
            this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
            this.saveFailedMessage(xpMessage);
            _log.fatal("No communication defined in collaboration agreement for sender '{}' and receiver '{}' found.", (Object)internalSender, (Object)internalReceiver);
            return new SendToListenerResult(SendToListenerResult.Result.NO_AGREEMENT_FOUND, xpMessage, "Sender Internal-Id: " + internalSender + " Receiver Internal-Id: " + internalReceiver);
        }
        String defaultReceiverUri = communication.getTransportURL();
        this.setProtocol(xpMessage, defaultReceiverUri);
        BaseTransportProvider transport = this._transportProviderFactory.getTransportProvider(defaultReceiverUri);
        if (transport == null) {
            this._messengerLog.log2db(527, xpMessage.getDatabaseId(), "No Transport provider found for " + defaultReceiverUri);
            this.moveMessageFilesToDB(xpMessage);
            this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
            this.saveFailedMessage(xpMessage);
            _log.fatal("No Transport provider for URL '{}' defined in partner settings.", (Object)defaultReceiverUri);
            return new SendToListenerResult(SendToListenerResult.Result.TRANSPORT_PROVIDER_NOT_FOUND, xpMessage, defaultReceiverUri);
        }
        if (Objects.isNull(xpMessage.getTransportURLType())) {
            xpMessage.setTransportURLType(TransportURLType.DYNAMIC);
        }
        switch (xpMessage.getTransportURLType()) {
            case FALLBACK: {
                xpMessage.setDestinationUrl(communication.getTransportFallbackURL());
                break;
            }
            default: {
                xpMessage.setDestinationUrl(defaultReceiverUri);
            }
        }
        xpMessage.setMessagePackaging(communication.getPackagingId());
        this._messageDAO.updatePackagingId(xpMessage.getDatabaseId(), xpMessage.getMessagePackaging());
        this.saveMessageMetaData(xpMessage);
        if (xpMessage.getCurrentContentReference() != null) {
            this._fileRefDAO.insertMessageFileReference(xpMessage.getDatabaseId(), xpMessage.getCurrentContentReference().getParentFile(), xpMessage.getCurrentContentReference().getName(), xpMessage.getCurrentContentType());
        }
        if ((errorResultFromPipeline = this.startPipeline(xpMessage, communication)) != null) {
            return errorResultFromPipeline;
        }
        if (xpMessage.isAck()) {
            this._messengerLog.log2db(104, xpMessage.getDatabaseId(), null);
            this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), xpMessage.getMessageId(), 3);
        }
        return this._outboundMessageQueue.deliverMessageToPartner(xpMessage);
    }

    private void moveMessageFilesToDB(XpMessage xpMessage) {
        try {
            this.messageWorkDataDAO.uploadDirectoryToDB(xpMessage.getDatabaseId(), xpMessage.getCurrentContentReferenceFolder());
            FileSystemUtils.deleteRecursively((File)xpMessage.getCurrentContentReferenceFolder());
        }
        catch (DbException e) {
            _log.error("Error while moving message files of message {} to database.", (Object)xpMessage.getDatabaseId(), (Object)e);
        }
    }

    private void saveFailedMessage(XpMessage xpMessage) {
        try {
            this._messageDAO.updateMessageAndStatus(xpMessage, 4);
        }
        catch (DbException e) {
            _log.debug("Update of Message and status in DB failed: {}", (Object)xpMessage.getMessageId());
            try {
                MessageInfo origMessageInfo = this._messageDAO.getMessageInfo(xpMessage.getDatabaseId());
                if (Objects.nonNull(origMessageInfo) && !origMessageInfo.getMessageId().equals(xpMessage.getMessageId())) {
                    xpMessage.setMessageId(origMessageInfo.getMessageId());
                    this._messageDAO.updateMessageAndStatus(xpMessage, 4);
                } else {
                    this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), xpMessage.getMessageId(), 4);
                }
            }
            catch (DbException ex) {
                _log.warn("Saving of complete FAILED XpMessage failed due to {} ({}). Set status to FAILED only.", (Object)ex.getClass().getSimpleName(), (Object)ex.getMessage());
                this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), xpMessage.getMessageId(), 4);
            }
        }
    }

    private void generateMessageIdIfNotDefined(XpMessage xpMessage) {
        if (xpMessage.getMessageId() == null || OVERWRITE_MESSAGE_ID.equalsIgnoreCase(xpMessage.getMessageId())) {
            xpMessage.setMessageId(this._idGenerator.generateMessageId());
            _log.debug("generated new message id {}", (Object)xpMessage.getMessageId());
        }
    }

    private SendToListenerResult startPipeline(XpMessage xpMessage, Communication communication) {
        if (!"PING".equals(xpMessage.getMessageType())) {
            try {
                Pipeline pipeline = this._pipelineFactory.getOutboundPipeline(communication.getPipelineId());
                pipeline.process(xpMessage);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ie) {
                this.updateMessage(xpMessage);
                this._messengerLog.log2db(527, xpMessage.getDatabaseId(), "Process pipeline '" + communication.getPipelineId() + "' could not be initiated");
                this.moveMessageFilesToDB(xpMessage);
                this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
                this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), xpMessage.getMessageId(), 4);
                _log.fatal("Pipeline could not be initialized:" + ie.getMessage(), (Throwable)ie);
                return new SendToListenerResult(SendToListenerResult.Result.COULD_NOT_INITIALIZE_PIPELINE, xpMessage, ie);
            }
            catch (CryptException ce) {
                this.updateMessage(xpMessage);
                this.moveMessageFilesToDB(xpMessage);
                this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
                this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), xpMessage.getMessageId(), 4);
                if (_log.isDebugEnabled()) {
                    _log.fatal("Could not encrypt the message: " + ce.getMessage(), (Throwable)ce);
                } else {
                    _log.fatal("Could not encrypt the message: {}", (Object)ce.getMessage());
                }
                return new SendToListenerResult(SendToListenerResult.Result.ENCRYPTION_FAILED, xpMessage, ce);
            }
            catch (SignatureException se) {
                this.updateMessage(xpMessage);
                this.moveMessageFilesToDB(xpMessage);
                this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
                this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), xpMessage.getMessageId(), 4);
                if (_log.isDebugEnabled()) {
                    _log.fatal("Could not sign the message: " + se.getMessage(), (Throwable)se);
                } else {
                    _log.fatal("Could not sign the message: {}", (Object)se.getMessage());
                }
                return new SendToListenerResult(SendToListenerResult.Result.SIGNING_FAILED, xpMessage, se);
            }
            catch (CompressionException ce) {
                this.updateMessage(xpMessage);
                this.moveMessageFilesToDB(xpMessage);
                this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
                this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), xpMessage.getMessageId(), 4);
                if (_log.isDebugEnabled()) {
                    _log.fatal("Could not compress the message: " + ce.getMessage(), (Throwable)ce);
                } else {
                    _log.fatal("Could not compress the message: {}", (Object)ce.getMessage());
                }
                return new SendToListenerResult(SendToListenerResult.Result.COMPRESSION_FAILED, xpMessage, ce);
            }
            catch (MessageRecognitionException e) {
                this.updateMessage(xpMessage);
                this.moveMessageFilesToDB(xpMessage);
                this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
                this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), xpMessage.getMessageId(), 4);
                if (_log.isDebugEnabled()) {
                    _log.fatal("Payload could not be recognized: " + e.getMessage(), (Throwable)e);
                } else {
                    _log.fatal("Payload could not be recognized: {}", (Object)e.getMessage());
                }
                String details = "No activated XML Schema for MessageType:" + xpMessage.getMessageType() + " Version:" + xpMessage.getMessageVersion() + " found";
                return new SendToListenerResult(SendToListenerResult.Result.COULD_NOT_PROCESS_MESSAGE, xpMessage, details);
            }
            catch (ValidationException ve) {
                this.updateMessage(xpMessage);
                this.moveMessageFilesToDB(xpMessage);
                this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
                this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), xpMessage.getMessageId(), 4);
                _log.fatal("Could not validate the message: {}", (Object)ve.getMessage());
                ValidationResult[] validationResults = ve.getResult();
                String errorText = " Reason: " + ve.getMessage();
                if (validationResults != null) {
                    for (int i = 0; i < validationResults.length; ++i) {
                        if (i == 10) {
                            errorText = errorText + "\n   ...";
                            break;
                        }
                        ValidationResult validationResult = validationResults[i];
                        errorText = errorText + "\n   (Line " + validationResult.getLine() + " / Column " + validationResult.getColumn() + ") " + validationResult.getDescription();
                    }
                }
                return new SendToListenerResult(SendToListenerResult.Result.VALIDATION_FAILED, xpMessage, errorText);
            }
            catch (Exception bfe) {
                this.updateMessage(xpMessage);
                this.moveMessageFilesToDB(xpMessage);
                this._archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
                this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), xpMessage.getMessageId(), 4);
                _log.fatal("Could not process Message: {}", (Object)bfe.getMessage(), (Object)bfe);
                return new SendToListenerResult(SendToListenerResult.Result.COULD_NOT_PROCESS_MESSAGE, xpMessage, bfe.toString());
            }
            if (_log.isDebugEnabled()) {
                _log.debug("Pipeline done.");
            }
        }
        return null;
    }

    private void updateMessage(XpMessage xpMessage) {
        try {
            this._messageDAO.updateMessage(xpMessage);
        }
        catch (DbException e) {
            _log.debug(e.getMessage());
        }
    }

    private void deleteArchivedFolder(XpMessage message) {
        block3: {
            File folder = null;
            try {
                MessageInfo info = this._messageDAO.getMessageInfo(message.getDatabaseId());
                folder = info.getMessageFolder();
                if (folder != null) {
                    FileUtils.deleteDirectory((File)folder);
                }
            }
            catch (Exception e) {
                if (folder == null) break block3;
                _log.warn("No files deleted from archive " + String.valueOf(folder));
            }
        }
    }

    private void setProtocol(XpMessage message, String newUrl) {
        if (!newUrl.equals(message.getDestinationUrl())) {
            int index = newUrl.indexOf(58);
            String protocol = null;
            if (index != -1) {
                protocol = newUrl.substring(0, index);
                message.setProtocol(protocol.toUpperCase());
            }
        }
    }

    private void moveWorkFolder(XpMessage message) throws IOException {
        if (message.getCurrentContentReferenceFolder() != null) {
            if (_log.isDebugEnabled()) {
                _log.debug("updating current content folder");
            }
            File newWork = new File(this._folders.getWorkOutboundFolder(), String.valueOf(message.getDatabaseId()));
            File tempFolder = message.getCurrentContentReferenceFolder();
            if (!tempFolder.equals(newWork)) {
                if (newWork.exists()) {
                    _log.warn("removing old work directory.{}", (Object)newWork);
                    FileUtils.deleteDirectory((File)newWork);
                }
                try {
                    Files.move(tempFolder.toPath(), newWork.toPath(), new CopyOption[0]);
                }
                catch (IOException e1) {
                    _log.warn("failed to rename {} to {}, retry in 2 seconds. {}", (Object)tempFolder, (Object)newWork, (Object)e1.getMessage());
                    this.delayedMoveWorkFolder(message, newWork, tempFolder);
                }
                message.setCurrentContentReferenceFolder(newWork);
            }
            message.updateAttachments(newWork);
            this.saveMessageMetaData(message);
        }
        this._messageDAO.updateMessageFolder(message.getDatabaseId(), message.getCurrentContentReferenceFolder());
        String filename = null;
        if (message.getCurrentContentReference() != null) {
            filename = message.getCurrentContentReference().getName();
        }
        this._fileRefDAO.insertMessageFileReference(message.getDatabaseId(), message.getCurrentContentReferenceFolder(), filename, message.getCurrentContentType());
    }

    private void delayedMoveWorkFolder(XpMessage message, File newWork, File tempFolder) throws IOException {
        try {
            TimeUnit.SECONDS.sleep(2L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            Files.move(tempFolder.toPath(), newWork.toPath(), new CopyOption[0]);
        }
        catch (IOException e2) {
            _log.error("failed to rename {} to {}: {}", (Object)tempFolder, (Object)newWork, (Object)e2.getMessage());
            this._messengerLog.log2db(515, message.getDatabaseId(), "file renaming problem." + e2.getMessage());
            this._messageDAO.updateMessageStatus(message.getDatabaseId(), message.getMessageId(), 4);
            throw e2;
        }
    }

    private CppPartner fetchReceiverProfile(XpMessage message) throws ProfileException {
        String receiverLocalId = message.getReceiverLocalId();
        try {
            if (StringUtils.isNotBlank((CharSequence)receiverLocalId)) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Fetching settings for Receiver Partner local id:{}", (Object)receiverLocalId);
                }
                return this._profiles.getProfileForLocalId(receiverLocalId, true);
            }
        }
        catch (ProfileNotFoundException e) {
            _log.debug("Could not find receiver for localId '{}'.", (Object)receiverLocalId);
        }
        String receiverInternalId = message.getReceiverInternalId();
        if (receiverInternalId == null) {
            throw new ProfileNotFoundException(-1, "internalId for receiver is not set");
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Fetching settings for Receiver Partner internal id:{}", (Object)receiverInternalId);
        }
        return this._profiles.getProfileForInternalId(receiverInternalId, true);
    }

    private CppPartner fetchSenderProfile(XpMessage message) throws ProfileNotFoundException, ProfileException {
        String senderLocalId = message.getSenderLocalId();
        if (StringUtils.isNotBlank((CharSequence)senderLocalId)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Fetching settings for Sender Partner local id:{}", (Object)senderLocalId);
            }
            return this._profiles.getProfileForLocalId(senderLocalId, true);
        }
        String senderInternalId = message.getSenderInternalId();
        if (senderInternalId == null) {
            throw new ProfileNotFoundException(-1, "internalId for sender is not set");
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Fetching settings for Sender Partner internal id:{}", (Object)senderInternalId);
        }
        return this._profiles.getProfileForInternalId(senderInternalId, true);
    }

    private boolean isRFC2822MessageId() {
        String value = this.messengerProperties.getProperty(PROPERTY_RFC2822_CONFORM_MESSAGE_ID, DEFAULT_RFC2822_CONFORM_MESSAGE_ID);
        return Boolean.parseBoolean(value);
    }

    private void saveMessageMetaData(XpMessage xpMessage) {
        try {
            this._messageDAO.saveXpMessage(xpMessage);
        }
        catch (DbException e) {
            _log.error("Can't update MessageMetaData of {}: {}", (Object)xpMessage.getMessageId(), (Object)e.toString());
        }
    }
}

