/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger;

import de.ponton.xmlpipe.metrics.MetricsService;
import de.ponton.xmlpipe.metrics.XPMetrics;
import de.ponton.xmlpipe.queue.InboundQueue;
import de.ponton.xmlpipe.queue.OutboundQueue;
import de.pontonconsulting.common.activation.MimeTypeMapper;
import de.pontonconsulting.xmlpipe.adapter.AdapterInfo;
import de.pontonconsulting.xmlpipe.adapter.AdapterRegistry;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.config.SchemaData;
import de.pontonconsulting.xmlpipe.config.SchemataConfig;
import de.pontonconsulting.xmlpipe.cpa.Agreement;
import de.pontonconsulting.xmlpipe.cpa.AgreementException;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpa.Communication;
import de.pontonconsulting.xmlpipe.cpa.CommunicationNotFoundException;
import de.pontonconsulting.xmlpipe.cpp.CppPartner;
import de.pontonconsulting.xmlpipe.cpp.ProfileException;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.message.XpAcknowledgment;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.message.ack.XpAcknowledgment;
import de.pontonconsulting.xmlpipe.messenger.IPipelineFactory;
import de.pontonconsulting.xmlpipe.messenger.InboundQueueException;
import de.pontonconsulting.xmlpipe.messenger.Pipeline;
import de.pontonconsulting.xmlpipe.messenger.ProcessingResult;
import de.pontonconsulting.xmlpipe.messenger.ReferencedMessageNotFoundException;
import de.pontonconsulting.xmlpipe.messenger.UnexpectedAcknowledgementException;
import de.pontonconsulting.xmlpipe.messenger.archive.ArchiveProcessor;
import de.pontonconsulting.xmlpipe.messenger.database.DbException;
import de.pontonconsulting.xmlpipe.messenger.database.MessageInfo;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.OutboundQueueMessage;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.XpDatabaseMessage;
import de.pontonconsulting.xmlpipe.messenger.database.tables.FileRefDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageWorkDataDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerLog;
import de.pontonconsulting.xmlpipe.messenger.filter.BaseFilterException;
import de.pontonconsulting.xmlpipe.messenger.filter.MessageRecognitionException;
import de.pontonconsulting.xmlpipe.messenger.filter.validate.ValidationException;
import de.pontonconsulting.xmlpipe.messenger.filter.validate.ValidationResult;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.FileSystemUtils;

public class ReceiveFromListener {
    public static final Logger _log = LogManager.getLogger((String)"Messenger.ReceiveFromListener");
    private final AdapterRegistry _adapterRegistry;
    private final Agreements _agreements;
    private final Profiles _profiles;
    private final MessengerConfig _messengerConfig;
    private final SchemataConfig _schemataConfig;
    private final InboundQueue _inboundMessageQueue;
    private final IPipelineFactory _pipelinePoolFactory;
    private final ArchiveProcessor archiveProcessor;
    private final MessageDAO _messageDAO;
    private final MessengerLog _messengerLog;
    private final FileRefDAO _fileRefDAO;
    private final OutboundQueue outboundQueue;
    private final HashSet<String> _responseReferences;
    private final Lock _lock;
    private final Condition _processSetChanged;
    private final MetricsService metricsService;
    private final MessageWorkDataDAO messageWorkDataDAO;

    public ReceiveFromListener(AdapterRegistry adapterRegistry, Agreements agreements, Profiles profiles, MessengerConfig messengerConfig, SchemataConfig schemataConfig, InboundQueue inboundMessageQueue, IPipelineFactory pipelinePoolFactory, ArchiveProcessor archiveProcessor, MessageDAO messageDAO, MessengerLog messengerLog, FileRefDAO fileRefDAO, OutboundQueue outboundQueue, MetricsService metricsService, MessageWorkDataDAO messageWorkDataDAO) {
        this._adapterRegistry = adapterRegistry;
        this._agreements = agreements;
        this._profiles = profiles;
        this._messengerConfig = messengerConfig;
        this._schemataConfig = schemataConfig;
        this._inboundMessageQueue = inboundMessageQueue;
        this._pipelinePoolFactory = pipelinePoolFactory;
        this.archiveProcessor = archiveProcessor;
        this._messageDAO = messageDAO;
        this._messengerLog = messengerLog;
        this._fileRefDAO = fileRefDAO;
        this.outboundQueue = outboundQueue;
        this.metricsService = metricsService;
        this.messageWorkDataDAO = messageWorkDataDAO;
        if (_log.isDebugEnabled()) {
            _log.debug("new instance of ReceiveFromListener created.");
        }
        this._responseReferences = new HashSet();
        this._lock = new ReentrantLock();
        this._processSetChanged = this._lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult[] handleMessage(XpMessage xpMessage) {
        ArrayList<ProcessingResult> result = new ArrayList<ProcessingResult>();
        try {
            this.insertMessageFileReference(xpMessage);
            CppPartner sender = this._profiles.getProfileForLocalId(xpMessage.getSenderLocalId(), true);
            CppPartner receiver = this._profiles.getProfileForLocalId(xpMessage.getReceiverLocalId(), true);
            xpMessage.setSenderInternalId(sender.getInternalId());
            xpMessage.setReceiverInternalId(receiver.getInternalId());
            if (!(xpMessage.isAck() || xpMessage.isStatusResponse() || "PING".equals(xpMessage.getMessageType()))) {
                if (xpMessage.getCurrentContentReference() != null) {
                    this.startPipeline(xpMessage, result);
                } else {
                    _log.warn("No Payload found in message !");
                }
            }
            this.renameContentFile(xpMessage);
            this.insertMessageFileReference(xpMessage);
            if (xpMessage.isAck() || xpMessage.isStatusResponse()) {
                try {
                    this.lockReference(xpMessage.getReferenceId());
                    this.handleResponse(xpMessage, result);
                }
                finally {
                    this.unlockReference(xpMessage.getReferenceId());
                }
            } else if (xpMessage.isStoreMessageInQueue()) {
                this.addMessageToAdapterQueue(xpMessage, result);
            } else {
                this.moveMessageWorkFolderToDB(xpMessage);
                this.archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), false);
                this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), xpMessage.getMessageId(), 3);
            }
            result.add(new ProcessingResult(0, "Messenger", "Inbound Message successfully received"));
        }
        catch (UnexpectedAcknowledgementException e) {
            this.moveMessageWorkFolderToDB(xpMessage);
            long messageDataID = xpMessage.getDatabaseId();
            this.archiveProcessor.sendFilesToArchive(messageDataID, false);
            this._messageDAO.updateMessageStatus(messageDataID, xpMessage.getMessageId(), 3);
        }
        catch (ReferencedMessageNotFoundException e) {
            _log.error("Received acknowledgement for unknown message: {}", (Object)e.getMessage());
            this.moveMessageToFailedArchive(xpMessage);
        }
        catch (BaseFilterException e) {
            _log.error("Error while processing message: {}", (Object)e.getMessage());
            this.moveMessageToFailedArchive(xpMessage);
        }
        catch (ProfileException pnfe) {
            _log.error("Error while processing message: {}", (Object)pnfe.getMessage());
            this._messengerLog.log2db(527, xpMessage.getDatabaseId(), pnfe.getMessage());
            this.moveMessageToFailedArchive(xpMessage);
        }
        catch (Exception e) {
            _log.error("error during reception", (Throwable)e);
            this.moveMessageToFailedArchive(xpMessage);
        }
        return result.toArray(new ProcessingResult[0]);
    }

    private void moveMessageWorkFolderToDB(XpMessage xpMessage) {
        try {
            this.messageWorkDataDAO.uploadDirectoryToDB(xpMessage.getDatabaseId(), xpMessage.getCurrentContentReferenceFolder());
            FileSystemUtils.deleteRecursively((File)xpMessage.getCurrentContentReferenceFolder());
        }
        catch (DbException e) {
            _log.error("Error while uploading message folder of messenger {} to DB: {}", (Object)xpMessage.getDatabaseId(), (Object)e.toString());
        }
    }

    private void addMessageToAdapterQueue(XpMessage xpMessage, ArrayList<ProcessingResult> result) throws InboundQueueException {
        if (xpMessage.getAdapterId() == null) {
            this._messengerLog.log2db(8, xpMessage.getDatabaseId(), "No Destination Adapter was set !");
            _log.warn("No destination adapter defined. Message will not be delivered.");
            return;
        }
        try {
            this._inboundMessageQueue.deliverMessageToAdapter(xpMessage.getAdapterId(), xpMessage);
        }
        catch (InboundQueueException e) {
            this._messengerLog.log2db(525, xpMessage.getDatabaseId(), xpMessage.getAdapterId());
            _log.fatal("Message could not be delivered to Inbound MessageQueue:{}", (Object)e.getMessage());
            result.add(new ProcessingResult(6, "Message Queue", "Inbound Message could not be added to Queue"));
            throw e;
        }
    }

    private void handleResponse(XpMessage xpMessage, ArrayList<ProcessingResult> result) throws DbException, JAXBException, ReferencedMessageNotFoundException, UnexpectedAcknowledgementException, InboundQueueException, ProfileException {
        long databaseId = xpMessage.getDatabaseId();
        long referenceDatabaseId = xpMessage.getReferenceDatabaseId();
        String referenceId = xpMessage.getReferenceId();
        MessageInfo referencedMessage = this._messageDAO.getMessageInfo(referenceDatabaseId);
        if (referencedMessage == null) {
            _log.info("Referenced Message is unknown to the system: '{}' databaseId: {}", (Object)referenceId, (Object)referenceDatabaseId);
            this._messengerLog.log2db(209, databaseId, referenceId);
            throw new ReferencedMessageNotFoundException(40001, new String[]{referenceId}, "Referenced Message is unknown to the system: '" + referenceId + "'");
        }
        if (referencedMessage.getStatus() == 3) {
            this._messengerLog.log2db(66, referenceDatabaseId, " is ignored");
            _log.info("Referenced Message was already acknowledged: '{}'", (Object)referenceId);
            this._messengerLog.log2db(208, databaseId, referenceId);
            throw new UnexpectedAcknowledgementException();
        }
        int parentStatus = 3;
        if (xpMessage.isStatusResponse()) {
            this.handleStatusResponse(xpMessage);
        } else if (this.handleAckOrPong(xpMessage, referencedMessage)) {
            parentStatus = 4;
        }
        this.updateDestinationAdapter(xpMessage, referencedMessage);
        Optional<OutboundQueueMessage> deletedMessage = this.outboundQueue.removeFromOutboundQueue(referencedMessage.getDatabaseId());
        this.metricsService.getMeter(XPMetrics.MESSAGES_OUTBOUND_QUEUE_REMOVE_RATE).mark();
        if (deletedMessage.isPresent()) {
            this.archiveProcessor.sendFilesToArchive(xpMessage.getReferenceDatabaseId(), 4 == parentStatus);
            Optional<String> lastOutboundUrl = deletedMessage.get().getTransportUrl();
            if (lastOutboundUrl.isPresent()) {
                try {
                    Agreement agreement = xpMessage.getAgreement();
                    if (agreement != null) {
                        Communication communication = agreement.getCommunication(xpMessage.getReceiverLocalId(), xpMessage.getSenderLocalId());
                        boolean valid = this.isNotInternalAck(xpMessage);
                        String lastUrl = lastOutboundUrl.get();
                        communication.setURLValid(lastUrl, valid);
                        _log.debug("Set valid of URL '{}' to {}", (Object)lastUrl, (Object)valid);
                    }
                }
                catch (CommunicationNotFoundException e) {
                    _log.error("Could not get communication: {}", (Object)e.getMessage());
                }
            }
        }
        if (this.isNotInternalAck(xpMessage)) {
            this._messageDAO.setAckReceived(referenceDatabaseId);
        }
        this._messageDAO.updateMessageStatus(referenceDatabaseId, referenceId, parentStatus);
        this.addMessageToAdapterQueue(xpMessage, result);
    }

    private boolean isNotInternalAck(XpMessage xpMessage) {
        return !OutboundQueue.PROTOCOL_INTERNAL.equals(xpMessage.getProtocol());
    }

    private boolean handleAckOrPong(XpMessage xpMessage, MessageInfo referencedMessage) throws JAXBException, ProfileException, DbException {
        boolean parentFailed = false;
        XpAcknowledgment ack = new XpAcknowledgment(xpMessage.getCurrentContentReference());
        if ("Pong".equals(ack.getOverallResult())) {
            this._messengerLog.log2dbWithHref(66, xpMessage.getReferenceDatabaseId(), "PONG received", xpMessage.getMessageId(), xpMessage.getDatabaseId(), true);
            this._messengerLog.log2db(104, xpMessage.getReferenceDatabaseId(), null);
        } else if ("Success".equals(ack.getOverallResult())) {
            this._messengerLog.log2dbWithHref(66, xpMessage.getReferenceDatabaseId(), "Remote time: " + ack.getRemoteReceptionTime().toString(), xpMessage.getMessageId(), xpMessage.getDatabaseId(), true);
            this.metricsService.getMeter(XPMetrics.MESSAGES_OUTBOUND_SUCCESSFUL).mark();
            this.metricsService.getMeter(XPMetrics.MESSAGES_OUTBOUND_SENDER_SUCCESSFUL, referencedMessage.getSenderId()).mark();
            this.metricsService.getMeter(XPMetrics.MESSAGES_OUTBOUND_RECEIVER_SUCCESSFUL, referencedMessage.getReceiverId()).mark();
            this.logAckContent(xpMessage, ack);
            this._messengerLog.log2db(102, xpMessage.getReferenceDatabaseId(), null);
        } else if ("Internal".equals(xpMessage.getProtocol())) {
            this._messengerLog.log2db(532, xpMessage.getReferenceDatabaseId(), null);
            this.metricsService.getMeter(XPMetrics.MESSAGES_OUTBOUND_FAILED).mark();
            this.metricsService.getMeter(XPMetrics.MESSAGES_OUTBOUND_SENDER_FAILED, referencedMessage.getSenderId()).mark();
            this.metricsService.getMeter(XPMetrics.MESSAGES_OUTBOUND_RECEIVER_FAILED, referencedMessage.getReceiverId()).mark();
            parentFailed = true;
        } else {
            this._messengerLog.log2dbWithHref(66, xpMessage.getReferenceDatabaseId(), "Remote time: " + ack.getRemoteReceptionTime().toString(), xpMessage.getMessageId(), xpMessage.getDatabaseId(), true);
            this.logAckContent(xpMessage, ack);
            this.metricsService.getMeter(XPMetrics.MESSAGES_OUTBOUND_FAILED).mark();
            this.metricsService.getMeter(XPMetrics.MESSAGES_OUTBOUND_SENDER_FAILED, referencedMessage.getSenderId()).mark();
            this.metricsService.getMeter(XPMetrics.MESSAGES_OUTBOUND_RECEIVER_FAILED, referencedMessage.getReceiverId()).mark();
            parentFailed = true;
        }
        xpMessage.setProcessingDirective("AckResult", ack.getOverallResult());
        xpMessage.setProcessingDirective("AckResultText", this.getAckResultText(ack));
        this.setReferenceDataToAck(xpMessage, referencedMessage);
        return parentFailed;
    }

    private String getAckResultText(XpAcknowledgment ack) {
        StringBuilder resultText = new StringBuilder();
        ack.getResults().forEach(result -> {
            resultText.append(result.getDescription().replace("\r", " ").replace("\n", " "));
            resultText.append(" ");
        });
        return resultText.toString().trim();
    }

    private void handleStatusResponse(XpMessage xpMessage) {
        String refMessageId = xpMessage.getProcessingDirective("StatusResponseMSGId");
        String status = xpMessage.getProcessingDirective("MSGStatus");
        this._messengerLog.log2dbWithHref(95, xpMessage.getDatabaseId(), "Status: " + status + "; Status Request ID: " + xpMessage.getReferenceId(), xpMessage.getReferenceId(), xpMessage.getReferenceDatabaseId(), false);
        this._messengerLog.log2dbWithHref(95, xpMessage.getReferenceDatabaseId(), "Status: " + status + "; Status Response ID: " + xpMessage.getMessageId(), xpMessage.getMessageId(), xpMessage.getDatabaseId(), true);
        long refMessageDataId = this._messageDAO.getReferenceMessageDataID(refMessageId, 0);
        if (refMessageDataId != -1L) {
            this._messengerLog.log2dbWithHref(95, refMessageDataId, "Status: " + status + "; Status Response ID: " + xpMessage.getMessageId(), xpMessage.getMessageId(), xpMessage.getDatabaseId(), true);
        }
    }

    private void setReferenceDataToAck(XpMessage xpMessage, MessageInfo referencedMessage) throws ProfileException, DbException {
        xpMessage.setProcessingDirective("ReferenceMessageType", referencedMessage.getMessageType());
        xpMessage.setProcessingDirective("ReferenceUniqueId", Long.toString(referencedMessage.getDatabaseId()));
        xpMessage.setProcessingDirective("ReferenceSchemaSet", referencedMessage.getSchemaSet());
        xpMessage.setProcessingDirective("ReferenceSchemaVersion", referencedMessage.getSchemaVersion());
        xpMessage.setProcessingDirective("ReferenceMessageId", referencedMessage.getMessageId());
        xpMessage.setProcessingDirective("ReferenceConversationId", referencedMessage.getConversationId());
        xpMessage.setProcessingDirective("ReferenceSenderId", this._profiles.getProfileForLocalId(referencedMessage.getSenderId(), true).getInternalId());
        xpMessage.setProcessingDirective("ReferenceReceiverId", this._profiles.getProfileForLocalId(referencedMessage.getReceiverId(), true).getInternalId());
        xpMessage.setProcessingDirective("ReferenceCreationTime", String.valueOf(referencedMessage.getTimestamp()));
        xpMessage.setProcessingDirective("ReferenceSequenceNumber", String.valueOf(referencedMessage.getSequenceNumber()));
        XpDatabaseMessage xpDatabaseMessage = this._messageDAO.loadXpDatabaseMessage(referencedMessage.getDatabaseId());
        if (Objects.nonNull(xpDatabaseMessage)) {
            String filename = xpDatabaseMessage.getProcessingDirective("OriginalFilename");
            if (Objects.nonNull(filename)) {
                xpMessage.setProcessingDirective("OriginalFilename", filename);
            }
            xpMessage.setProcessingDirective("ReferenceContentType", xpDatabaseMessage.getContentType());
            xpDatabaseMessage.getProcessingDirectives().forEach((key, value) -> xpMessage.setProcessingDirective("ReferenceProcessingDirective_" + value.getType(), value.getValue()));
        } else {
            Optional<XpMessage> optRefXpMessage = this.archiveProcessor.getXpMessageFromArchive(referencedMessage);
            if (optRefXpMessage.isPresent()) {
                XpMessage refXpMessage = optRefXpMessage.get();
                String filename = refXpMessage.getProcessingDirective("OriginalFilename");
                if (Objects.nonNull(filename)) {
                    xpMessage.setProcessingDirective("OriginalFilename", filename);
                }
                xpMessage.setProcessingDirective("ReferenceContentType", refXpMessage.getCurrentContentType());
                refXpMessage.getProcessingDirectives().forEach((key, value) -> xpMessage.setProcessingDirective("ReferenceProcessingDirective_" + key, (String)value));
            }
        }
    }

    void updateDestinationAdapter(XpMessage xpMessage, MessageInfo referencedMessage) throws DbException {
        String destinationAdapter = this._messageDAO.getAdapterId(xpMessage.getReferenceDatabaseId());
        AdapterInfo info = this._adapterRegistry.getAdapter(destinationAdapter);
        if (info != null && (info.getAddress() == null || info.getAddress().length() == 0 || info.getAddress().equals("ReceptionDisabled"))) {
            try {
                Agreement agreement = this._agreements.getAgreement(referencedMessage.getSenderId(), referencedMessage.getReceiverId(), true);
                xpMessage.setAdapterId(agreement.getDefaultAdapterId());
            }
            catch (AgreementException e) {
                _log.error("Agreement not found for {} and {} .. default adapter cannot be set.", (Object)referencedMessage.getSenderId(), (Object)referencedMessage.getReceiverId());
            }
        } else {
            xpMessage.setAdapterId(destinationAdapter);
            String transferId = this._messageDAO.getTransferId(xpMessage.getReferenceDatabaseId());
            xpMessage.setTransferId(transferId);
        }
    }

    private void logAckContent(XpMessage xpMessage, XpAcknowledgment ack) {
        for (XpAcknowledgment.Results ackResult : ack.getResults()) {
            if (ackResult.getCode().equals("Success")) {
                this._messengerLog.log2db(5, xpMessage.getReferenceDatabaseId(), ackResult.getDescription());
                _log.info("Received ACK for {}:{}", (Object)xpMessage.getReferenceId(), (Object)ackResult.getDescription());
                continue;
            }
            if (ackResult.getCode().equals("Warning")) {
                this._messengerLog.log2db(201, xpMessage.getReferenceDatabaseId(), ackResult.getDescription());
                _log.info("Received warning for {}:{}", (Object)xpMessage.getReferenceId(), (Object)ackResult.getDescription());
                continue;
            }
            if (!ackResult.getCode().equals("Error")) continue;
            this._messengerLog.log2db(516, xpMessage.getReferenceDatabaseId(), ackResult.getDescription());
            _log.error("Received Error for {}:{}", (Object)xpMessage.getReferenceId(), (Object)ackResult.getDescription());
        }
    }

    private void renameContentFile(XpMessage xpMessage) throws JAXBException, IOException {
        File now = xpMessage.getCurrentContentReference();
        if (now != null) {
            if (xpMessage.isAck() && this._messengerConfig.isArchiveRenameAckFiles() || xpMessage.isStatusResponse()) {
                File renamed;
                String prefix = "ack";
                if (xpMessage.isStatusResponse()) {
                    prefix = "status_response";
                }
                if (!now.renameTo(renamed = new File(now.getParentFile(), prefix + ".xml"))) {
                    throw new IOException("Could not rename file " + now.getAbsolutePath() + " to " + renamed.getAbsolutePath());
                }
                xpMessage.setCurrentContentReference(renamed);
                this.updateSignatureFile(xpMessage, now, renamed);
            } else if (!xpMessage.isAck()) {
                File renamed = null;
                try {
                    SchemaData schema = this._schemataConfig.getSchemaBySetTypeVersion(xpMessage.getSchemaSet(), xpMessage.getMessageType(), xpMessage.getMessageVersion());
                    if (!("BINARY".equals(schema.getSchemaSetName()) && "BINARY".equals(schema.getMessageType()) && "1".equals(schema.getMessageVersion()))) {
                        renamed = new File(now.getParentFile(), "payload." + schema.getDefaultFileExtension());
                    }
                }
                catch (Exception e) {
                    String extension = ".dat";
                    if (xpMessage.getCurrentContentType() != null) {
                        MimeTypeMapper.getExtension(xpMessage.getCurrentContentType());
                    }
                    renamed = new File(now.getParentFile(), "payload.dat");
                }
                if (renamed != null && !renamed.getName().equals(now.getName())) {
                    if (!now.renameTo(renamed)) {
                        throw new IOException("Could not rename file " + now.getAbsolutePath() + " to " + renamed.getAbsolutePath());
                    }
                    xpMessage.setCurrentContentReference(renamed);
                    this.updateSignatureFile(xpMessage, now, renamed);
                }
            }
        }
    }

    private void updateSignatureFile(XpMessage xpMessage, File oldPayloadFile, File newPayloadFile) throws IOException {
        final String oldPayloadFilename = oldPayloadFile.getName();
        String newPayloadFilename = newPayloadFile.getName();
        File[] sigFiles = oldPayloadFile.getParentFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().equals(oldPayloadFilename + ".p7s") || file.getName().startsWith(oldPayloadFilename) && file.getName().endsWith(".rsa") || file.getName().equals(oldPayloadFilename + ".p7smime");
            }
        });
        if (sigFiles != null) {
            for (File oldSignatureFile : sigFiles) {
                String oldSignatureFilename = oldSignatureFile.getName();
                File newSignatureFile = new File(newPayloadFile.getParent(), oldSignatureFilename.replace(oldPayloadFilename, newPayloadFilename));
                if (!oldSignatureFile.renameTo(newSignatureFile)) {
                    throw new IOException("Could not rename file " + oldSignatureFile.getAbsolutePath() + " to " + newSignatureFile.getAbsolutePath());
                }
                if (!_log.isDebugEnabled()) continue;
                _log.debug("Renamed signature file from '{}' to '{}'.", (Object)oldSignatureFilename, (Object)newSignatureFile.getName());
            }
        }
    }

    private void startPipeline(XpMessage xpMessage, ArrayList<ProcessingResult> result) throws Exception {
        Pipeline pipeline = null;
        try {
            pipeline = this._pipelinePoolFactory.getInboundPipeline(xpMessage.getCommunication().getPipelineId());
            pipeline.process(xpMessage);
        }
        catch (ValidationException e) {
            ValidationResult[] vr = e.getResult();
            if (vr != null) {
                for (int i = 0; i < vr.length && i < 10; ++i) {
                    Object location = "Unknown Location";
                    int l = vr[i].getLine();
                    int c = vr[i].getColumn();
                    if (l != -1) {
                        location = "Line " + l + " / Column " + c;
                    }
                    result.add(new ProcessingResult(1, (String)location, vr[i].getDescription()));
                }
            } else {
                result.add(new ProcessingResult(1, "Processing Pipeline", e.getMessage()));
            }
            throw e;
        }
        catch (MessageRecognitionException e) {
            _log.fatal("Payload could not be recognized");
            result.add(new ProcessingResult(6, "Processing Pipeline", e.getMessage()));
            throw e;
        }
        catch (BaseFilterException e) {
            _log.fatal("Processing Error: {}", (Object)e.getMessage());
            result.add(new ProcessingResult(6, "Processing Pipeline", e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            _log.fatal("processing pipeline could not be initialized: {}", (Object)e.getMessage());
            result.add(new ProcessingResult(6, "Processing Pipeline", "Pipeline could not be initialized"));
            throw e;
        }
    }

    private void insertMessageFileReference(XpMessage xpMessage) {
        if (xpMessage.getCurrentContentReference() != null) {
            this._fileRefDAO.insertMessageFileReference(xpMessage.getDatabaseId(), xpMessage.getCurrentContentReference().getParentFile(), xpMessage.getCurrentContentReference().getName(), xpMessage.getCurrentContentType());
        } else if (xpMessage.getCurrentContentReferenceFolder() != null) {
            this._messageDAO.updateMessageFolder(xpMessage.getDatabaseId(), xpMessage.getCurrentContentReferenceFolder());
        }
    }

    private void moveMessageToFailedArchive(XpMessage xpMessage) {
        this.moveMessageWorkFolderToDB(xpMessage);
        this.archiveProcessor.sendFilesToArchive(xpMessage.getDatabaseId(), true);
        this._messageDAO.updateMessageStatus(xpMessage.getDatabaseId(), xpMessage.getMessageId(), 4);
    }

    private void lockReference(String messageId) {
        this._lock.lock();
        try {
            while (!this._responseReferences.add(messageId)) {
                this._processSetChanged.await();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this._lock.unlock();
        }
    }

    private void unlockReference(String messageId) {
        this._lock.lock();
        try {
            if (!this._responseReferences.remove(messageId)) {
                throw new RuntimeException("Message id " + messageId + " was not found in referenceSet " + String.valueOf(this._responseReferences));
            }
            this._processSetChanged.signalAll();
        }
        finally {
            this._lock.unlock();
        }
    }
}

