/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.messenger;

import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.events.EnterMaintenanceModeEvent;
import de.pontonconsulting.xmlpipe.events.ServiceLevel;
import de.pontonconsulting.xmlpipe.events.ShutdownCompleted;
import de.pontonconsulting.xmlpipe.events.ShutdownService;
import de.pontonconsulting.xmlpipe.events.StartupCompleted;
import de.pontonconsulting.xmlpipe.events.StartupService;
import de.pontonconsulting.xmlpipe.messenger.IMaintenanceChangeListener;
import de.pontonconsulting.xmlpipe.messenger.IServiceProvider;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceService;
import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.messenger.database.tables.EventLog;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class MaintenanceManager
implements IServiceProvider {
    private static final String EVENT_ID = "messenger.maintenance";
    private static final String LOCATION = "/private/ShowMaintenance.do";
    private static final Logger _log = LogManager.getLogger((String)"Messenger.MaintenanceManager");
    private boolean _turnOffToAdapters = true;
    private boolean _turnOffToPartners = true;
    private boolean _rejectInboundMSGs = true;
    private boolean _rejectOutboundMSGs = true;
    private boolean _configError = false;
    private Date _endTime;
    private final Timer _timer;
    private final List<TimerTask> _allTasks;
    private final Object _sync = new Object();
    private final AtomicInteger _msgInProcess = new AtomicInteger(0);
    private boolean _shutdown = false;
    private boolean _startup = false;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final EventLog eventLog;
    private final ReferenceDateTask referenceDateTask;
    private final MessengerConfig _messengerConfig;
    private final List<IMaintenanceChangeListener> _maintenanceChangeListeners;
    private boolean _mainMaintenanceMode = false;

    public MaintenanceManager(ApplicationEventPublisher applicationEventPublisher, EventLog eventLog, ReferenceDateTask referenceDateTask, MessengerConfig messengerConfig) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.eventLog = eventLog;
        this.referenceDateTask = referenceDateTask;
        this._messengerConfig = messengerConfig;
        this._timer = new Timer("MaintenanceManager", true);
        this._allTasks = new ArrayList<TimerTask>();
        this._maintenanceChangeListeners = new ArrayList<IMaintenanceChangeListener>();
    }

    @PreDestroy
    public void shutdown() {
        this._timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMaintenanceChangeListener(IMaintenanceChangeListener maintenanceChangeListener) {
        List<IMaintenanceChangeListener> list = this._maintenanceChangeListeners;
        synchronized (list) {
            if (!this._maintenanceChangeListeners.contains(maintenanceChangeListener)) {
                this._maintenanceChangeListeners.add(maintenanceChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAllMaintenanceChangeListeners() {
        List<IMaintenanceChangeListener> list = this._maintenanceChangeListeners;
        synchronized (list) {
            for (IMaintenanceChangeListener maintenanceChangeListener : this._maintenanceChangeListeners) {
                try {
                    maintenanceChangeListener.onMaintenanceChange(this);
                }
                catch (Exception e) {
                    _log.error("error in maintenance listener", (Throwable)e);
                }
            }
        }
    }

    public boolean isStarted() {
        return this._startup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        if (!this._startup || this._shutdown) {
            return;
        }
        this._messengerConfig.removeOldMaintenanceServices(this.referenceDateTask.getReferenceCurrentTimeMillis());
        List<MaintenanceService> maintenanceServices = this._messengerConfig.getMaintenanceServices();
        for (MaintenanceService maintenanceService : maintenanceServices) {
            long offset = this.referenceDateTask.getOffset();
            StartTask startTask = new StartTask(maintenanceService.isTurnOffToAdapters(), maintenanceService.isTurnOffToPartners(), maintenanceService.isRejectInboundMSGs(), maintenanceService.isRejectOutboundMSGs(), new Date(maintenanceService.getEndTime()));
            Date startTime = new Date(maintenanceService.getStartTime() - offset);
            this._timer.schedule((TimerTask)startTask, startTime);
            _log.info("Scheduled StartTask for maintenance service for {}", (Object)startTime);
            EndTask endTask = new EndTask();
            Date endTime = new Date(maintenanceService.getEndTime() - offset);
            _log.info("Scheduled EndTask for maintenance service for {}", (Object)endTime);
            this._timer.schedule((TimerTask)endTask, new Date(maintenanceService.getEndTime() - offset));
            Object object = this._sync;
            synchronized (object) {
                this._allTasks.add(startTask);
                this._allTasks.add(endTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        if (!this._startup || this._shutdown || this._mainMaintenanceMode) {
            return;
        }
        Object object = this._sync;
        synchronized (object) {
            this.clear();
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        if (!this._startup || this._shutdown || this._configError) {
            return;
        }
        Object object = this._sync;
        synchronized (object) {
            for (TimerTask timerTask : this._allTasks) {
                timerTask.cancel();
            }
            if (!this._allTasks.isEmpty()) {
                _log.debug("All TimerTasks are canceled.");
            }
            this._turnOffToAdapters = false;
            this._turnOffToPartners = false;
            this._rejectInboundMSGs = false;
            this._rejectOutboundMSGs = false;
            this._endTime = null;
            this._allTasks.clear();
            this._timer.purge();
        }
        this.eventLog.deleteEvent(EVENT_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMainMaintenanceMode() {
        Object object = this._sync;
        synchronized (object) {
            this._mainMaintenanceMode = true;
            this.clear();
            this._rejectInboundMSGs = true;
            this._rejectOutboundMSGs = true;
            this._turnOffToAdapters = true;
            this._turnOffToPartners = true;
            this._endTime = new Date(this.referenceDateTask.getReferenceCurrentTimeMillis() + 600000L);
            this.waitForMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMainMaintenanceMode() {
        Object object = this._sync;
        synchronized (object) {
            if (this._mainMaintenanceMode) {
                this._mainMaintenanceMode = false;
                this.restart();
            }
        }
    }

    public boolean isMaintenanceMode() {
        return this._mainMaintenanceMode || this._configError || this._rejectInboundMSGs || this._rejectOutboundMSGs || this._turnOffToAdapters || this._turnOffToPartners;
    }

    public boolean isRejectInboundMSGs() {
        return this._rejectInboundMSGs;
    }

    public boolean isRejectOutboundMSGs() {
        return this._rejectOutboundMSGs;
    }

    public boolean isTurnOffToAdapters() {
        return this._turnOffToAdapters;
    }

    public boolean isTurnOffToPartners() {
        return this._turnOffToPartners;
    }

    public boolean isConfigError() {
        return this._configError;
    }

    public Date getEndTime() {
        return this._endTime;
    }

    @Override
    public ServiceLevel getServiceLevel() {
        return ServiceLevel.getServiceLevel(this.getClass());
    }

    @Override
    public String getServiceName() {
        return "MaintenanceManager";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof StartupService) {
            StartupService startupEvent = (StartupService)event;
            if (this.getServiceLevel() == startupEvent.getServiceLevel()) {
                Object object = this._sync;
                synchronized (object) {
                    this._startup = true;
                    this.restart();
                    this.notifyAllMaintenanceChangeListeners();
                }
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new StartupCompleted(this));
            }
        } else {
            if (event instanceof EnterMaintenanceModeEvent) {
                Object object = this._sync;
                synchronized (object) {
                    _log.warn("Received EnterMaintenanceModeEvent. Disable communication completely (inbound+outbound+adapters+partners)");
                    this.clear();
                    this._configError = true;
                    this._rejectInboundMSGs = true;
                    this._rejectOutboundMSGs = true;
                    this._turnOffToAdapters = true;
                    this._turnOffToPartners = true;
                    this._endTime = Date.from(this.referenceDateTask.getReferenceOffsetDateTime().plusYears(1L).toInstant());
                    this.notifyAllMaintenanceChangeListeners();
                }
            }
            if (event instanceof ShutdownService) {
                ShutdownService shutdownEvent = (ShutdownService)event;
                if (this.getServiceLevel() == shutdownEvent.getServiceLevel()) {
                    Object object = this._sync;
                    synchronized (object) {
                        this.clear();
                        this._startup = false;
                        this._rejectInboundMSGs = true;
                        this._rejectOutboundMSGs = true;
                        this._turnOffToAdapters = true;
                        this._turnOffToPartners = true;
                        this._endTime = null;
                        this.notifyAllMaintenanceChangeListeners();
                        this.waitForMessages();
                        this._shutdown = true;
                    }
                    this.applicationEventPublisher.publishEvent((ApplicationEvent)new ShutdownCompleted(this));
                }
            }
        }
    }

    private void waitForMessages() {
        boolean interrupted = false;
        while (this._msgInProcess.get() > 0 && !interrupted) {
            _log.info("There are " + this._msgInProcess.get() + " messages in process. Waiting.....");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                interrupted = true;
                Thread.currentThread().interrupt();
            }
        }
        _log.info("No messages in progress. shutdown continues.");
    }

    public void putLock(Object lockObject) {
        this._msgInProcess.incrementAndGet();
    }

    public void removeLock(Object lockObject) {
        this._msgInProcess.decrementAndGet();
    }

    class StartTask
    extends TimerTask {
        private final boolean _turnOffToAdapters;
        private final boolean _turnOffToPartners;
        private final boolean _rejectInboundMSGs;
        private final boolean _rejectOutboundMSGs;
        private final Date _endTime;

        StartTask(boolean turnOffToAdapters, boolean turnOffToPartners, boolean rejectInboundMSGs, boolean rejectOutboundMSGs, Date endTime) {
            this._turnOffToAdapters = turnOffToAdapters;
            this._turnOffToPartners = turnOffToPartners;
            this._rejectInboundMSGs = rejectInboundMSGs;
            this._rejectOutboundMSGs = rejectOutboundMSGs;
            this._endTime = endTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = MaintenanceManager.this._sync;
            synchronized (object) {
                MaintenanceManager.this._turnOffToAdapters = this._turnOffToAdapters;
                MaintenanceManager.this._turnOffToPartners = this._turnOffToPartners;
                MaintenanceManager.this._rejectInboundMSGs = this._rejectInboundMSGs;
                MaintenanceManager.this._rejectOutboundMSGs = this._rejectOutboundMSGs;
                MaintenanceManager.this._endTime = this._endTime;
                MaintenanceManager.this._allTasks.remove(this);
                _log.info("Maintenance mode is started. (turnOffToAdapter={} / turnOffToPartners={} / rejectInboundMSGs={} / rejectOutboundMSGs={})", (Object)this._turnOffToAdapters, (Object)this._turnOffToPartners, (Object)this._rejectInboundMSGs, (Object)this._rejectOutboundMSGs);
            }
            MaintenanceManager.this.eventLog.writeWarning(MaintenanceManager.EVENT_ID, "messenger.maintenance.component", "messenger.maintenance.descriptionKey", "", new String[]{""}, MaintenanceManager.LOCATION);
        }
    }

    class EndTask
    extends TimerTask {
        EndTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = MaintenanceManager.this._sync;
            synchronized (object) {
                MaintenanceManager.this._turnOffToAdapters = false;
                MaintenanceManager.this._turnOffToPartners = false;
                MaintenanceManager.this._rejectInboundMSGs = false;
                MaintenanceManager.this._rejectOutboundMSGs = false;
                MaintenanceManager.this._endTime = null;
                MaintenanceManager.this._allTasks.remove(this);
                MaintenanceManager.this._messengerConfig.removeOldMaintenanceServices(MaintenanceManager.this.referenceDateTask.getReferenceCurrentTimeMillis());
                MaintenanceManager.this.notifyAllMaintenanceChangeListeners();
            }
            _log.info("Maintenance mode is ended.");
            MaintenanceManager.this.eventLog.deleteEvent(MaintenanceManager.EVENT_ID);
        }
    }
}

